#version 300 es
#ifdef GL_ES
  precision mediump float;
#endif
#define GAMMA_CORRECTION  0.4545
#define sabs(p) sqrt((p)*(p)+2e-3)
#define smin(a,b) (a+b-sabs(a-b))*.5
#define smax(a,b) (a+b+sabs(a-b))*.5
uniform vec2 u_resolution;
uniform vec4 u_mouse;
#define PI 3.14159
uniform float u_time;
in vec2 v_texCoord;
uniform sampler2D u_sampler;
out vec4 out_color;
#define MAX_STEPS 128.
#define SURFACE_DIST 0.0001
#define MAX_DIST 100.0
#define MIN_DIST 0.0
#define PIXELATION 1

#define NUM_LAYERS 3.
#define FADE_TIME 2.0
#define SHORT_FADE 1.0
float t;

mat2 Rot2d(float a) {
  float s = sin(a);
  float c = cos(a);
  return mat2(c, - s, s, c);
}

mat4 RotationX(float angle){
  return mat4(1.,0,0,0,
  0,cos(angle),-sin(angle),0,
  0,sin(angle),cos(angle),0,
  0,0,0,1);
}

mat4 RotationY(float angle){
  return mat4(cos(angle),0,sin(angle),0,
  0,1.,0,0,
  -sin(angle),0,cos(angle),0,
  0,0,0,1);
}

mat4 RotationZ(float angle){
  return mat4(cos(angle),-sin(angle),0,0,
  sin(angle),cos(angle),0,0,
  0,0,1,0,
  0,0,0,1);
}

float differenceSdf(float a, float b){
  return max(a,-b);
}

float intersectSdf(float a, float b){
  return max(a, b);
}

float unionSdf(float a, float b){
  return min(a, b);
}


float sdOcta( vec3 p, float s){
  p = abs(p);
  return (p.x+p.y+p.z-s)*-tan(5.0*PI/6.0);
}

float sdSphere(vec3 p, vec4 sphere) {
  return length(p - sphere.xyz) - sphere.w;
}

float sdBox(vec3 p, vec3 box) {
  p = abs(p) - box;
  return max(p.x, max(p.y, p.z));
}

float sdGyroid(vec3 p, float scale, float thickness, float bias, float xamp, float yamp){
  p *= scale;
  return abs(dot(sin(p)*xamp, cos(p.zxy)*yamp)-bias)/scale-thickness;
}
float sdDodec(vec3 p,float r){
  float G=sqrt(5.)*.5+.5;
  vec3 n=normalize(vec3(G,1,0));
  float d=0.;
  p=sabs(p);
  d=smax(d,dot(p,n));
  d=smax(d,dot(p,n.yzx));
  d=smax(d,dot(p,n.zxy));
  return d-r;
}
float sdWarpedCubed(vec3 p) {
  p.xz *= Rot2d(t);
  p.yx *= Rot2d(t * 0.6);
  p.zx *= Rot2d(t * 0.4);
  p.y += sin(t * 0.2);
  vec3 d = abs(p) - vec3(1.4);
  float dist = length(max(d, 0.0)) + min(max(d.x, max(d.y, d.z)), 0.0);
  return dist - 0.1;
}

vec3 estnorm(vec3 p) {
  return normalize(
  vec3(
  sdWarpedCubed(vec3(p.x + SURFACE_DIST, p.yz)) - sdWarpedCubed(vec3(p.x - SURFACE_DIST, p.yz)),
  sdWarpedCubed(vec3(p.x, p.y + SURFACE_DIST, p.z)) - sdWarpedCubed(vec3(p.x, p.y - SURFACE_DIST, p.z)),
  sdWarpedCubed(vec3(p.xy, p.z + SURFACE_DIST)) - sdWarpedCubed(vec3(p.xy, p.z - SURFACE_DIST))
  )
  );
}
float sdIcosa(vec3 p,float r){
  float G=sqrt(5.)*.5+.5;
  vec3 n=normalize(vec3(G,1./G,0));
  float d=0.;
  p=sabs(p);
  d=smax(d,dot(p,n));
  d=smax(d,dot(p,n.yzx));
  d=smax(d,dot(p,n.zxy));
  d=smax(d,dot(p,normalize(vec3(1))));
  return d-r;
}

float sdAAPlane(vec3 p){
  return p.y;
}
//
vec3 Transform(vec3 p) {
  return p;
}

float GetDist(vec3 p){
  // replace with your scene
  float d = sdSphere(p, vec4(0,0,0,.5));
  return d;
}

vec4 texel(vec2 uv){
  
  return texture (u_sampler, uv);
}
vec2 distOcta(vec3 p){
  vec2 a = vec2(1),b = vec2(2),c = vec2(1);
  float t = u_time*2.;
  vec3 po = p;
  
  p = po;
  p.xy*=Rot2d(-t);
  p.yz*=Rot2d(-t);
  p.zx*=Rot2d(t);
  
  b.x = sdDodec(p,3.0);
  c.x = sdIcosa(p, 4.0-(sin(t)*.5+.5)*2.);
  b.x = max(b.x,c.x);//sdBox(p,vec3(4.0-(sin(t)*0.5+0.5)*2.0)));
  a = (a.x<b.x)?a:b;
  a = (a.x<b.x)?a:b;
  return a; 
}
vec3 norm(vec3 p, float s) {
  vec2 off=vec2(s,0);
  return normalize(
  vec3(distOcta(p+off.xyy).x, distOcta(p+off.yxy).x, distOcta(p+off.yyx).x)
  -vec3(distOcta(p-off.xyy).x, distOcta(p-off.yxy).x, distOcta(p-off.yyx).x));
}
vec3 GetNormal(vec3 p) {
  vec2 e = vec2(0.02, 0);
  float d = GetDist(p);
  vec3 n = d-vec3(GetDist(p - e.xyy), GetDist(p - e.yxy), GetDist(p - e.yyx));
  return normalize(n);
}
float GetDistGyro(vec3 p){
  //float box = sdSphere(p, vec4(vec3(0),3.4));
  // p = abs(p);
  float box = sdBox(p-vec3(0,0,0), vec3(2.5));
  //float planed=p.y;
  float t = u_time/12.;
  float gyroid = sdGyroid(p, 10., min(.12,.1*sin(u_time)+.11), -1.4,2.*sin(t), cos(t));
  // float gyroid2 = sdGyroid(p-.1, 21.);

  float d = max(box, gyroid*.7);
  // d = max(d-.05, gyroid2);
  return d;
}
vec3 GetRayDir(vec2 uv, vec3 p, vec3 l, float z) {
  vec3 f = normalize(l - p),
  r = normalize(cross(vec3(0, 1, 0), f)),
  u = cross(f, r),
  c = p+f * z,
  i = c+uv.x * r+uv.y * u,
  d = normalize(i - p);
  return d;
}
float Star(vec2 uv, float flare){
  float d = length(uv);
  float m = .05/d;
  float rays = max(0., 1.-abs(uv.x*uv.y*1000.))*0.2;
  m+=rays * flare;
  uv *= Rot2d(3.1415/4.);
  rays = max(0., 1.-abs(uv.x*uv.y*100000.))*0.9;
  m += rays*0.3*flare;
  m *= smoothstep(0.6,.01, d);
  return m;
}
#define UI0 1597334673U
#define UI1 3812015801U
#define UI2 uvec2(UI0, UI1)
#define UI3 uvec3(UI0, UI1, 2798796415U)
#define UIF (1.0 / float(0xffffffffU))

// The labeling refers to the number of values - hash(out)(in)...
//---------------------------------------------------------------------------------------------------------------
float hash11(uint q)
{
  uvec2 n = q * UI2;
  q = (n.x ^ n.y) * UI0;
  return float(q) * UIF;
}

float hash11(float p)
{
  uvec2 n = uint(int(p)) * UI2;
  uint q = (n.x ^ n.y) * UI0;
  return float(q) * UIF;
}

//---------------------------------------------------------------------------------------------------------------
float hash12(uvec2 q)
{
  q *= UI2;
  uint n = (q.x ^ q.y) * UI0;
  return float(n) * UIF;
}

float hash12(vec2 p)
{
  uvec2 q = uvec2(ivec2(p)) * UI2;
  uint n = (q.x ^ q.y) * UI0;
  return float(n) * UIF;
}
float H21(vec2 p){
  return hash12(p);
  
}
vec3 StarLayer(vec2 uv){
  vec3 col = vec3(0);
  vec2 gv = fract(uv)-.5;
  vec2 id = floor(uv);
  for(int y=-1;y<=1;y++){
    for(int x=-1;x<=1;x++){
      vec2 offset = vec2(x,y);
      float n = H21(id+offset);
      float size = fract(n*343.32);
      float star = Star(gv-offset-vec2(n,fract(n*34.))+0.5, smoothstep(.8,0.9,size));
      vec3 color = sin(vec3(0.1, 0.5,.0)*fract(n*2345.2)*123.12)*.5+.5;
      color *= vec3(.9,0.4,.1+size);
      star *= sin(u_time*n*6.3)*0.5+1.;
      col += star*size*color;
      
    }
  }
  return col;
}
vec3 starFieldEvo(vec2 uv){
  uv*=Rot2d(t);
  vec3 col = vec3(0);
  for(float i = 0.0;i<1.;i+=1./NUM_LAYERS){
    ;
    
    float depth = fract(i+t);
    float scale = mix(20.,.1,depth);
    float f = depth * smoothstep(1.,.9,depth);
    col += StarLayer(uv*scale+i*453.2)*f;
  }
  return col;
}
float RayMarch(vec3 ro, vec3 rd) {
  float dO = 0.0;
  for(float i = 0.; i < MAX_STEPS; i++ ) {
    vec3 p = ro + dO * rd;
    float ds = GetDistGyro(p);
    dO += ds;
    if (dO < SURFACE_DIST||dO > MAX_DIST) {
      break;
    }
  }
  return dO;
}
vec3 plasma(vec2 p, float scale, float speed) {
  p *= scale;
  float time = t * speed;
  float v1 = sin(p.x + time);
  float v2 = sin(p.y + time);
  float v3 = sin(p.x + time);
  float v4 = sin(p.x + p.y + time);
  float v5 = sin(length(p) + 2.0 * time);
  float v = v1 + v2 + v3+v5;
  v *= 3.0;
  vec3 col = vec3(abs(.4+sin(v * PI)*.5+.5), .8*(sin(v * PI  * PI / 3.0)*.5+.5), .015*(sin(v * PI + 4.0 * PI / 10.0)*0.5+.5));
  return col*col;
}
vec3 infiRep(in vec3 p, in vec3 c){
  return mod(p+0.5*c,c)-.5*c;
}
vec3 renderOcta(vec2 uv){
  vec3 col = vec3(0);
  vec3 camera = vec3(0,0,-15.);
  vec3 look = vec3(0);
  vec3 rd = GetRayDir(uv, camera, look, 1.0);
  float dO = 0.0;
  vec3 al;
  bool hit;
  float s=1.0;
  float shad;
  for(float i = 0.; i < MAX_STEPS; i ++ ) {
    vec3 p = camera + dO * rd;
    vec2 ds = distOcta(infiRep(p, vec3(20.)));
    dO += ds.x*s*0.825;
    if(abs(ds.x)<0.01){
      if(ds.y == 1.0)al = vec3(1.000,0.659,0.976);
      float edge = 0.004* dO *clamp(800.0/u_resolution.x,1.0,1.5);
      float edgeAmount = length(norm(p, 0.015)-norm(p, edge));
      col += smoothstep(0.0,0.1, edgeAmount)*0.25;
      s*=-1.0;
      ds.x = 0.01*s;
      if(!hit){
        shad = i/MAX_STEPS;
        hit = true;
      }
    }
    if (dO < SURFACE_DIST||dO > MAX_DIST) {
      break;
    }
  }
  vec3 wire = col;
  wire.r -= sin(u_time*2.)*.5+.5;
  wire.g -= cos(u_time*5.)*.5+.5;
  wire.b -= sin(u_time*12.)*.5+5.;
  
  return wire;
}
vec3 phong(vec3 n,vec3 lm, float shine, float dif, float amb,float glossy, float strength, float lamb, float ldiff, vec3 v){
  
  vec3 rm = 2.0*dot(lm,n)*n-lm;
  
  float ip = amb*lamb+(dif*clamp(dot(lm,n),0.0,1.1)*ldiff + shine*pow(clamp(dot(rm,v),0.0,1.0),glossy)*strength);
  
  return ip*vec3(0.1,0.2,0.5);
  
}
vec4 plasmaEvolve(vec2 fragCoord, float retroOff){
  float dt = retroOff-u_time;
  #if PIXELATION
    float modifier =(pow(dt,2.))/10.;
    
    float pixel = 10.;
    if(pixel > 6. && pixel <7.5 && u_time >1. && u_time<30.){
      pixel = 6.;
      } else {
      pixel /= modifier;
    }
    if(pixel < 2.)
    pixel = 1.0;
    fragCoord = ceil(fragCoord / pixel) * pixel;
  #endif
  vec2 uv = vec2(fragCoord - 0.5 * u_resolution.xy);
  uv = 2.2 * uv.xy / u_resolution.y;
  
  t = u_time + 0.5 * sin(uv.x * 1.76 + uv.y + u_time)+sin(uv.x*3.+u_time/2.)*.5+cos(uv.y*3.+u_time)*.5;
  
  vec3 camPos = vec3(0, 0, - 6.+u_time/100.);
  vec3 at = vec3(0, 0, 0);
  vec3 camForward = normalize(at - camPos);
  vec3 camRight = normalize(cross(vec3(0.0, 1.0, 0.0), camForward));
  vec3 camUp = normalize(cross(camForward, camRight));
  vec3 rayDir = normalize(uv.x * camRight + uv.y * camUp + camForward * 2.0);
  float depth = MIN_DIST;

  vec3 col = vec3(0.0);
  for(float i = 0.; i < MAX_STEPS; i ++ ) {
    vec3 p = camPos + depth * rayDir;
    p.xz *= Rot2d(t);
    p.yx *= Rot2d(t * 0.6);
    p.zx *= Rot2d(t * 0.4);
    p.y += sin(t * 0.2);
    p.xy += plasma(p.xy, 3.,3.).xy*.03;
    p.xz += plasma(p.xz,3.,3.).yx*.02;
    float dist = sdWarpedCubed(p);
    if (dist < SURFACE_DIST) {
      vec3 light = normalize(vec3(sin(t) * 1.0, cos(t * 0.5) + 0.5, - 0.5));
      vec3 norm = estnorm(p);
      vec3 directional = vec3(1.80, 1.27, 0.99) * max(dot(norm, light), 0.0);
      vec3 ambient = vec3(0.0, 0.0, 0.0);
      vec3 diffuse = plasma(p.xy, 3.0,3.0) * (directional + ambient);
      
      col = diffuse;
      col += pow(phong(norm,light,3.,1.4, .4, 20.,.1,0.2,0.2, vec3(1.)),vec3(1.5));
      break;
    }
    depth += dist;
    if (depth >= MAX_DIST) {
      break;
    }
  }
  
  col = pow(col, vec3(GAMMA_CORRECTION));
  return vec4(smoothstep(0.0, 1.0, col), 1.0);
}
vec3 render(vec2 uv){
  vec3 color = vec3(0);

  // camera
  vec3 camO = vec3(0, 3, -3);
  vec3 lookAt = vec3(0, 0, 0);
  camO.yz *= Rot2d(-u_mouse.y*3.14+1.);
  camO.xz *= Rot2d(-u_mouse.x*6.2831);
  vec3 rd = GetRayDir(uv, camO, lookAt, 1.0);

  // trace scene
  float d = RayMarch(camO, rd);

  // material
  if (d < MAX_DIST) {
    vec3 p = camO + rd * d;
    vec3 n = GetNormal(p);
    float height = p.y;
    float dif = dot(n, normalize(vec3(1,2,3)))*.5+.5;
    color += dif;
  }
  color = pow(color, vec3(.4545)); //correct gamma

  return color;
}

vec3 starField(vec2 p,float tt){
  float s = u_time/(80./u_time);
  if(tt > 4.){
    p.x+= .5*sin(u_time/(PI*2.)*5.);
    p.y+= .5*cos(u_time/(PI*2.)*4.);
    p *= Rot2d(u_time/(PI*2.));
  }
  float l = .2+s/10.;
  if(l > 2.){
    l = 2.;
  }

  float t = atan(p.x, p.y) * 2e2
  ,b = ceil(t)
  ,r = length(p)
  ,h = abs(cos(b)/(4.))
  ,o = h * b + s;
  o -= ceil(h/r*1.4 + o) - .5;
  
  r+=h/o;
  return vec3(0.)+(l - 1e4 * r *r) / o / o;
}
vec3 fade(vec3 src, vec3 dst, float secs, float start){
  vec3 maskcolor = vec3(0.0);

  if(u_time<start){
    return src;
  }
  float dt = u_time - start;
  if(dt>secs){
    return dst;
  }
  float progress = mod(dt,secs)/secs;
  
  float s = min(progress,0.5)*2.0;
  vec3 o = mix(src,maskcolor,s);
  
  if(progress > 0.5){
    s = (progress-0.5)*2.0;
    o = mix(maskcolor,dst,s);
  }
  return o;;
}
float startFade = 0.;
bool between(float time, float from, float to){
  bool res = (floor(time)>=from && floor(time)<to);
  return res;
}
vec3 runScene(vec3 a, vec3 b, float time, float from, float to, float fadetime){
  vec3 black = vec3(0.);
  vec3 color = vec3(0.);
  float dur = (to-from)-fadetime; //2
  float ain = from;//0
  float aout = from+dur;//4
  float bin = aout;//6
  float bout = to-fadetime;
  
  float dur2 = (to-dur); //4
  if(between(time, ain, ain+fadetime)){
    color = fade(black,a,fadetime,ain);
    } else if (between(time, ain+fadetime,aout)){
    color = a;
    } else if(between(time, aout, bin)){
    color = fade(a,black,fadetime, aout);
    } else if(between(time, bin,to)){
    color = fade(a,b ,fadetime, bin);
  }

  return color;
}
float GetLight(vec3 p){
  mat4 r = RotationY(u_time);
  vec4 lpos=vec4(1,2,3,1)*r;
  
  vec3 l=normalize(lpos.xyz-p);
  vec3 n=GetNormal(p);
  float diff=dot(n,l)*.5+.5;
  float d=RayMarch(p+n*.02,l);
  if(d<length(lpos.xyz-p)){
    diff*=.4;
  }
  return diff;
}


vec3 spooky(vec2 uv){
  vec3 color=vec3(0);
  
  float t = u_time/10.;
  // camera
  vec3 ro = vec3(0, 3, -2);
  
  ro.yz *= Rot2d(t*3.14+1.);
  ro.xz *= Rot2d(t*6.2831);
  

  vec3 rd=GetRayDir(uv, ro, vec3(0),1.);

  // trace scene
  float d=RayMarch(ro,rd);

  // material
  vec3 p=ro+rd*d;
  vec3 n = GetNormal(p);
  float diffuse=GetLight(p);
  float o=0.;
  color=vec3(diffuse-o);
  color.rg += n.xy*.2-d*.05;
  return color;
}
vec2 scene1 = vec2(0.,6.); //title
vec2 scene2 = vec2(6., 10.); //docz
vec2 scene3 = vec2(10., 14.); //64
vec2 scene4 = vec2(14., 18.); //simple
vec2 scene5 = vec2(18., 22.); //space
vec2 scene6 = vec2(22., 36.); //stars / startrot
vec2 scene7 = vec2(36, 40.); //place
vec2 scene8 = vec2(40., 55.); //plasma
vec2 scene9 = vec2(55., 59.); //evolve
vec2 scene10 = vec2(59.,64.); //solve
vec3 blendAdd(vec3 base, vec3 blend) {
  return min(base+blend,vec3(1.0));
}
vec2 scene11 = vec2(64., 76.); //starsEvo
vec2 scene12 = vec2(76., 91.); //plasmaEvo
vec2 scene13 = vec2(91, 96.); //
vec2 scene14 = vec2(96, 100.);
vec2 scene15 = vec2(100., 120.);//
vec2 cresc = vec2(120., 150.);
vec2 end = vec2(150.,155.);
void main(){
  t = u_time / 5.0;
  vec2 uv = (gl_FragCoord.xy-0.5 * u_resolution) / u_resolution.y;
  
  vec3 color = vec3(0.,0.,0.);
  vec3 a,b;
  //color = texel(v_texCoord).rgb;
  if(between(u_time, scene1.x, scene1.y)){
    color = runScene(texel(v_texCoord).rgb, vec3(0.), u_time, scene1.x, scene1.y, FADE_TIME); //title
  } else
  if(between(u_time, scene2.x, scene2.y)){
    color = runScene(texel(v_texCoord).rgb,  vec3(0), u_time, scene2.x,scene2.y, FADE_TIME); //docz
  } else
  if(between(u_time, scene3.x, scene3.y)){
    color = runScene(texel(v_texCoord).rgb,  vec3(0), u_time, scene3.x,scene3.y, FADE_TIME); //64
  } 
  if(between(u_time, scene4.x, scene4.y)){
    color = runScene(texel(v_texCoord).rgb,  vec3(0), u_time, scene4.x,scene4.y, FADE_TIME); // easie
  } 
  if(between(u_time, scene5.x, scene5.y)){
    color = runScene(texel(v_texCoord).rgb, vec3(0), u_time, scene5.x,scene5.y, SHORT_FADE); //space
  } 
  if(between(u_time, scene6.x, scene6.y-5.)){
    color = runScene(starField(uv,1.0),vec3(0),   u_time, scene6.x,scene6.y, SHORT_FADE); //starfiel 
  } 
  if(between(u_time, scene6.y-5., scene6.y)){
    color = runScene(starField(uv,4.0),vec3(0),   u_time, scene6.x,scene6.y, SHORT_FADE); //starfiel 
  } 
  if(between(u_time, scene7.x, scene7.y)){
    color = runScene(texel(v_texCoord).rgb,vec3(0),   u_time, scene7.x,scene7.y, FADE_TIME); //place
  }
  if(between(u_time, scene8.x, scene8.y)){
    color = runScene(plasma(uv,6.,4.).rgb, vec3(0),u_time, scene8.x, scene8.y, FADE_TIME);//plasma
  }
  if(between(u_time, scene9.x, scene9.y)){
    color = runScene(texel(v_texCoord).rgb,  vec3(0), u_time, scene9.x,scene9.y, FADE_TIME);//evolve
  } 
  if(between(u_time, scene10.x, scene10.y)){
    color = runScene(texel(v_texCoord).rgb, vec3(0), u_time, scene10.x,scene10.y, FADE_TIME); //solve
  } 

  if(between(u_time, scene11.x, scene11.y)){
    color = runScene(starFieldEvo(uv).bgr,  vec3(0), u_time, scene11.x,scene11.y, FADE_TIME);
  } 
  if(between(u_time, scene12.x, scene12.y)){
    color = runScene(plasmaEvolve(gl_FragCoord.xy, scene12.y-5.).rgb,  vec3(0), u_time, scene12.x,scene12.y, FADE_TIME);
  } 
  if(between(u_time, scene13.x, scene13.y)){
    color = runScene(texel(v_texCoord).rgb, vec3(0), u_time, scene13.x,scene13.y, FADE_TIME); //solve
  } 

  if(between(u_time, scene14.x, scene14.y)){
    color = runScene(texel(v_texCoord).rgb, vec3(0), u_time, scene14.x,scene14.y, FADE_TIME); //solve
  } 
  if(between(u_time, scene15.x, scene15.y)){
    color = runScene(spooky(uv),  vec3(0), u_time, scene15.x,scene15.y, FADE_TIME);
  } 
  int idx=0;
  if(between(u_time, cresc.x, cresc.y)){
    float a = floor(mod(u_time,2.0));
    vec3 ca;
    vec3 cb;
    
    if(a == 0.0){
      idx = ++idx % 4;      
    }
    if(idx == 0){
      ca = starFieldEvo(uv);
      cb = plasmaEvolve(gl_FragCoord.xy,0.).rgb;
    }
    if(idx == 1){
      ca = spooky(uv);
      cb = blendAdd(starField(uv,5.)*.2, starFieldEvo(uv)/2./ vec3(sin(u_time*3.)*.5+.5));
    }
    if(idx == 2){
      ca = plasmaEvolve(gl_FragCoord.xy,u_time+5.).rgb;
      cb = plasma(uv,6.,4.);
    }
    if(idx == 3){
      ca = plasmaEvolve(gl_FragCoord.xy,u_time+5.).grb;
      cb = spooky(uv);
    }
    color = blendAdd(ca*.5,(cb/vec3(cos(u_time*14.)*.5+.5))*.2);
    color *= vec3(sin(u_time*4.), cos(u_time*3.), sin(u_time*12.))*.5+.5;

  }
  if(between(u_time, end.x, end.y-5.)){
    color = runScene(texel(v_texCoord).rgb, vec3(0), u_time, end.x,end.y-5., FADE_TIME); //solve
  }
  if(between(u_time, end.x+5., end.y+5.)){
    color = runScene(texel(v_texCoord).rgb, vec3(0), u_time, end.x+5.,end.y+5., FADE_TIME); //solve
  }
  // color = blendAdd(spooky(uv),plasmaEvolve(gl_FragCoord.xy, 0.).grb);
  vec4 ocolor = vec4(color, 1.);
  if(mod(floor(uv.y*540.), 2.0) == 0.0 && (u_time < scene9.x || u_time > cresc.x)){
    ocolor -=.2;
  }
  out_color=ocolor;

}



