import processing.core.*; public class Symbows_Solitaire extends PMIDlet{
final int D_LEFT = 2;
final int D_RIGHT = 5;
final int D_UP = 1;
final int D_DOWN = 6;
final int D_SELECT = 8;
final int anim = 4;
int backgroundColor;
int cursorColor;
int selectedColor;
Klondike klondike;

public void setup() {
  softkey("Reset");
  //noLoop();
  backgroundColor = color(51, 153, 0);
  cursorColor = color(204, 153, 0, 79);
  selectedColor = color(255, 153, 51, 255);
  klondike = new Klondike();
}

public void draw() {
  background(backgroundColor);
  klondike.draw();
}

public void keyPressed() {
  if (keyCode == D_SELECT) {
    klondike.selectKey();
  } 
  else if (keyCode == D_LEFT || keyCode == D_RIGHT || keyCode == D_UP || keyCode == D_DOWN) {
    int direction = -1;
    if (keyCode == D_LEFT) {
      direction = 0;
    } else if (keyCode == D_RIGHT) {
      direction = 1;
    } else if (keyCode == D_UP) {
      direction = 2;
    } else if (keyCode == D_DOWN) {
      direction = 3;
    }
    klondike.directionKey(direction);
  }
}

public void softkeyPressed(String label) {
  if (label.equals("Reset")) {
    klondike = new Klondike();
    redraw();
  }
}


class Card {
  private final Suit suit;
  private final Rank rank;
  private final Deck deck;
  //private Pile pile;
  private Position pos;
  boolean faceUp = false;

  Card(Deck d, Suit s, Rank r) {
    deck = d;
    suit = s;
    rank = r;
    pos = new Position();
  }
  
  public boolean equals(Card c) {
    if (this.suit.equals(c.suit()) && this.rank.equals(c.rank())) {
      return true;
    } else {
      return false;
    }
  }
  
  public String toString() {
    return rank.toString() + " of " + suit.toString();
  }

  public Suit suit() {
    return suit;
  }

  public SuitColour suitColour() {
    return suit.colour();
  }

  public Rank rank() {
    return rank;
  }

  public int value() {
    return rank.value();
  }
  
  public boolean isFaceDown() {
    return !faceUp;
  }

  public boolean isFaceUp() {
    return faceUp;
  }

  public void turnFaceDown() {
    faceUp = false;
  }

  public void turnFaceUp() {
    faceUp = true;
  }
  
  public void moveTo(int x, int y) {
    this.moveTo(x, y, 1);
  }
  
  public void moveTo(int x, int y, int s) {
    println("move " + this + " to " + x + ", " + y + " in " + s + " steps");
    pos.moveTo(x, y, s);
  }
  
  public void moveTo(Position p) {
    this.moveTo(p.x(), p.y());
  }
  
  public void moveTo(Position p, int s) {
    this.moveTo(p.x(), p.y(), s);
  }
  
  public void draw() {
    pushMatrix();
    translate(pos.x, pos.y);
    if (faceUp) {
      int col = rank.value() - 1;
      if (col == 0) col = 13;
      int row = suit.value();
      
      image(deck.art(), col * 35 + 1, row * 47 + 1, 33, 45, 0, 0);
    }
    else {
      image(deck.art(), 1, 1, 33, 45, 0, 0);
    }
    popMatrix();
    pos.update();
  }
  
  public void drawMoving() {
    if (pos.state.equals("moving")) this.draw();
  }
}


class Cursor {
  private PImage art;
  private Position pos;
  
  Cursor() {
    pos = new Position(160, 240);
    art = loadImage("cursor.png"); 
  }
  
  public void draw() {
    image(art, pos.x, pos.y);
    pos.update();
  }
  
  public void moveTo(int x, int y) {
    pos.moveTo(x, y, anim);
  }
  
  public void moveTo(Position p) {
    this.moveTo(p.x, p.y);
  }
  
  public Position pos() {
    return pos;
  }
}


class Deck extends Pile {
  private SuitColour[] suitColours;
  private Suit[] suits; 
  private Rank[] ranks;
  private PImage art;

  Deck(CardGame p) {
    super(p);
    super.name = "Deck";
    super.cards = new Card[52];
    art = loadImage("cards.png");
    suitColours = new SuitColour[2];
    suitColours[0] = new SuitColour(0, "Red");
    suitColours[1] = new SuitColour(1, "Black");

    suits = new Suit[4];
    suits[0] = new Suit(0, "Hearts", suitColours[0]);
    suits[1] = new Suit(1, "Spades", suitColours[1]);
    suits[2] = new Suit(2, "Diamonds", suitColours[0]);
    suits[3] = new Suit(3, "Clubs", suitColours[1]);

    ranks = new Rank[13];
    ranks[0] = new Rank(1, "Ace", "A");
    ranks[1] = new Rank(2, "Two", "2");
    ranks[2] = new Rank(3, "Three", "3");
    ranks[3] = new Rank(4, "Four", "4");
    ranks[4] = new Rank(5, "Five", "5");
    ranks[5] = new Rank(6, "Six", "6");
    ranks[6] = new Rank(7, "Seven", "7");
    ranks[7] = new Rank(8, "Eight", "8");
    ranks[8] = new Rank(9, "Nine", "9");
    ranks[9] = new Rank(10, "Ten", "10");
    ranks[10] = new Rank(11, "Jack", "J");
    ranks[11] = new Rank(12, "Queen", "Q");
    ranks[12] = new Rank(13, "King", "K");

    for (int i = 0; i < 4; i++) {
      for (int j = 0; j < 13; j++) {
        super.cards[i*13+j] = new Card(this, suits[i], ranks[j]);
      }
    }
  }
  
  public PImage art() {
    return this.art;
  }
  
  public String type() {
    return "Deck";
  }
}


class Suit {
  
  private int value;
  private String name;
  private SuitColour colour;

  Suit(int v, String n, SuitColour c) {
    value = v;
    name = n;
    colour = c;
  }
  
  public boolean equals(Suit s) {
    return this.value() == s.value();
  }

  public String toString() {
    return name;
  }

  public SuitColour colour() {
    return colour;
  }

  public int toColor() {
    return colour.toColor();
  }

  public int value() {
    return value;
  }
}


class SuitColour {

  private int num;
  private String name;

  SuitColour(int n1, String n2) {
    num = n1;
    name = n2;
  }

  public String toString() {
    return name;
  }
  
  public int toColor() {
    //returns hardcoded int values that correspond to relevant processing colors because we can't use static method color() from here
    switch(this.num) {
    case 0:
      return -65536;
    case 1:
      return -16777216;
    default:
      return 0;
    }
  }
}


class Rank {

  private int value;
  private String name;
  private String mark;

  Rank(int v, String n, String m) {
    this.value = v;
    this.name = n;
    this.mark = m;
  }
  
  public boolean equals(Rank r) {
    return this.value() == r.value();
  }
  
  public int value() {
    return value;
  }

  public String toString() {
    return name;
  }
  
}


class Foundation extends Pile {
  private Rank base;
  private Suit suit;
  private int index;
  
  Foundation(Klondike p, Rank b, int i) {
    super(p);
    base = b;
    index = i;
    name = "Foundation " + index;
  }
  
  public boolean validate(Card c) {
    if (c != null) {  
      if (this.empty()) {
        if (base.equals(c.rank())) {
          return true;
        } else {
          return false;
        }
      } else if (c.suit().equals(this.topCard().suit()) && (c.value() - this.topCard().value()) == 1) {
        return true;
      } else {
        return false;
      }
    } else {
      return false;
    }
  }
  
  public String name() {
    return name + " " + index;
  }
    
  public boolean setBase(Rank r) {
    if (base == null) {
      base = r;
      return true;
    } else {
      return false;
    }
  }
  
  public String type() {
    return "Foundation";
  }
  
  public void draw() {
    if (!this.empty()) {
      for (int i=length(super.cards)-1; i>=0; i--) {
        super.cards[i].draw();
      }
    } else {
      super.drawEmpty();
    }
  }
}


class Hand extends Pile {

  private Pile src;
  private Pile dst;

  Hand(Klondike p) {
    super(p);
    this.name = "Hand";
  }

  public void pickup(Pile src) {
    if (!src.empty()) {
      this.pickup(src, src.topCard());
    }
  }

  public void pickup(Pile src, Card c) {
    this.src = src;
    this.moveTo(src.pos());
    boolean done = false;
    int j = 1;
    while (!done) {
      this.takeTopCardFromPile(src);
      j++;
      if (super.topCard().equals(c)) {
        done = true;
      }
    }
    super.parent.setState("move");
  }

  public void drop(Pile dst) {
    if (!this.empty()) {
      this.dst = dst;
      if (dst.type().equals("Tableau")) {
        if (dst.validate(this.topCard())) {
          while (this.size() > 0) {
            dst.takeTopCardFromPile(this);
          }
          if (src.type().equals("Tableau")) {
            if (!src.empty()) {
              src.topCard().turnFaceUp();
            }
          }
        } else {
          this.undo();
        }
      } else if (dst.type().equals("Foundation")) {
        if (dst.validate(this.topCard())) {
          while (this.size() > 0) {
            dst.takeTopCardFromPile(this);
          }
          if (src.type().equals("Tableau")) {
            if (!src.empty()) {
              src.topCard().turnFaceUp();
            }
          }
        } else {
          this.undo();
        }
      } else {
        this.undo();
      }
      super.parent.setState("choose");
    }
  }
  
  private void undo() {
    super.parent.setState("undo");
    while (this.size() > 0) {
      src.takeTopCardFromPile(this);
    }
  }

  //just for moving between piles
  public boolean move(Pile p1, Pile p2, Card c) {
    if (p1 != p2) {
      boolean done = false;
      int j = 1;
      while (!done) {
        this.takeTopCardFromPile(p1);
        j++;
        if (super.topCard().equals(c)) {
          done = true;
        }
      }
      j = 1;
      while (this.size() > 0) {
        p2.takeTopCardFromPile(this);
      }
      if (!p1.empty()) {
        p1.topCard().turnFaceUp();
      }
      return true;
    } 
    else {
      return false;
    }
  }

  public void moveTo(int x, int y) {
    super.moveTo(x, y);
    if (!super.empty()) {
      for (int i=0; i<length(super.cards); i++) {
        super.cards[i].moveTo(x - 24, y + i * 8 - 3, anim+i/2);
      }
    }
  }
  
  public void moveTo(Position pos) {
    moveTo(pos.x(), pos.y());
  }
  
  public void draw() {
    if (!this.empty()) {
      for (int i=0; i<length(super.cards); i++) {
        super.cards[i].draw();
      }
    }
  }
  
  public String type() {
    return "Hand";
  }
}


class Klondike extends CardGame {

  Klondike() {
    super.setState("init");
    //set the cursor to start on the waste pile
    super.cursorPileIndex = 1;
    //create a new deck and shuffle it
    super.decks = new Deck[1];
    super.decks[0] = new Deck(this);
    deck().shuffle();
    //create the empty piles
    super.piles = new Pile[13];
    super.piles[0] = new Stock(this);
    stock().moveTo(11,7);
    super.piles[1] = new Waste(this);
    waste().moveTo(55, 7);
    for (int i=0; i<7; i++) {
      super.piles[i+2] = new Tableau(this, i);
      tableau(i).moveTo(11+44*i, 57);
    }
    for (int i=0; i<4; i++) {
      super.piles[i+9] = new Foundation(this, deck().ranks[0], i);
      foundation(i).moveTo(143+44*i, 7);
    }
    // deal out the 7 tableau piles and turn top card of each face up
    for (int i=0; i<7; i++) {
      for (int j=i; j<7; j++) {
        tableau(j).takeTopCardFromPile(deck());
      }
    }
    for (int i=0; i<7; i++) {
      tableau(i).topCard().turnFaceUp();
    }
    //add the remainder of the cards to the stock pile
    while (deck().cards() != null) {
      stock().takeTopCardFromPile(deck());
    }
    //create the waste pile and draw 3 cards from stock
    for (int i=0; i<3; i++) {
      waste().takeTopCardFromPile(stock());
    }
    // create the hand
    super.hand = new Hand(this);
    super.cursor = new Cursor();
    updateCursor();
    super.setState("choose");
  }
  
  public void draw() {
    for (int i=0; i<length(super.piles); i++) {
      super.piles[i].draw();
    }
    super.hand.draw();
    super.cursor.draw();
  }
  
  public void directionKey(int direction) {
    int[][] cursorMoveLookup = {
      {12, 0, 8, 2, 3, 4, 5, 6, 7, 1, 9, 10, 11}, //LEFT
      {1, 9, 3, 4, 5, 6, 7, 8, 2, 10, 11, 12, 0}, //RIGHT
      {2, 3, 0, 1, 1, 9, 10, 11, 12, 5, 6, 7, 8}, //UP
      {2, 3, 0, 1, 1, 9, 10, 11, 12, 5, 6, 7, 8}  //DOWN
    }; 
    boolean newpile = true;
    if (cursorPile().type() == "Tableau" && (direction == 2 || direction == 3)) {
      if (super.hand.empty()) {
        int depth = ((Tableau)cursorPile()).getCursorDepth();
        if (direction == 2) { //UP
          if (((Tableau)cursorPile()).setCursorDepth(depth+1)) {
            newpile = false;
          }
        } else { //DOWN
          if (((Tableau)cursorPile()).setCursorDepth(depth-1)) {
            newpile = false;
          }
        }
      } else if (super.hand.size() > 1) {
        newpile = false;
      }
    }
    if (newpile) {
      super.cursorPileIndex = cursorMoveLookup[direction][super.cursorPileIndex];
      if (!super.hand.empty() && super.cursorPileIndex <= 1) {
        super.cursorPileIndex = 9;
      }
      if (cursorPile().type() == "Tableau") {
        ((Tableau)cursorPile()).setCursorDepth(0);
      }
    }
    updateCursor();
  }
  
  public void selectKey() {
    if (super.hand.empty()) {
      println("hand empty");
      if (cursorPile().type().equals("Stock")) {
        println("stock");
        if (stock().empty()) {
          println("stock empty");
          if (!waste().empty()) {
            while (waste().size() > 0) {
              stock().takeTopCardFromPile(waste());
            }
            waste().reset();
            for (int i=0; i<3; i++) {
              waste().takeTopCardFromPile(stock());
            }
          }
        } else {
          println("stock not empty");
          waste().condense();
          for (int i=0; i<3; i++) {
            waste().takeTopCardFromPile(stock());
          }
        }
      } else if (cursorPile().type().equals("Waste")) {
        super.hand.pickup(cursorPile());
      } else if (cursorPile().type().equals("Tableau") && !cursorPile().empty()) {
        Card c = ((Tableau)cursorPile()).getCursorCard();
        super.hand.pickup(cursorPile(), c);
      }
      updateCursor();
    } else {
      println("hand not empty");
      super.hand.drop(cursorPile());
      if (cursorPile().type() == "Tableau") {
        ((Tableau)cursorPile()).setCursorDepth(0);
      }
      updateCursor();
    }
  }
  
  public Deck deck() {
    return super.decks[0];
  }
  
  public Stock stock() {
    return (Stock)super.piles[0];
  }
  
  public Waste waste() {
    return (Waste)super.piles[1];
  }
  
  public Tableau tableau(int i) {
    return (Tableau)super.piles[i+2];
  }
  
  public Foundation foundation(int i) {
    return (Foundation)super.piles[i+9];
  }
  
  private Pile getPile(int i) {
    if (i >= 0 && i < length(super.piles)) {
      return super.piles[i];
    } else {
      return null;
    }
  }
  
  private Pile cursorPile() {
    return getPile(super.cursorPileIndex);
  }
  
  private void updateCursor() {
    Pile p = cursorPile();
    int x = p.x() + 24;
    if (p.type().equals("Waste")) x += 12 * (((Waste)p).fanout() - 1);
    int y = cursorPile().y() + 3;
    if (p.type().equals("Tableau") && !p.empty()) y += 8 * (p.size() - ((Tableau)p).getCursorDepth() - 1);
    if (!super.hand.empty()) {
      x += 6;
      y += 8;
    }
    super.hand.moveTo(x, y);
    super.cursor.moveTo(x, y);
  }
}

class CardGame {
  private int cursorPileIndex;
  private Cursor cursor;
  private Deck[] decks;
  private Hand hand;
  private Pile[] piles;
  private String state;
  
  public String state() {
    return state;
  }
  
  public void setState(String s) {
    state = s;
  }
}


class Pile {
  private CardGame parent;
  private Card[] cards;
  private Position pos;
  String name;
  
  Pile(CardGame p) {
    parent = p;
    cards = null;
    name = null;
    pos = new Position();
  }
  
  // draw methods
  
  public void draw() {
    if (!this.empty()) {
      this.topCard().draw();
    } else {
      this.drawEmpty();
    }
  }
  
  private void drawEmpty() {
    pushMatrix();
    translate(pos.x, pos.y);
    image(((Klondike)parent).deck().art(), 1, 95, 33, 45, 0, 0);
    popMatrix();
  }
  
  // methods that return information about cards
  
  public Card[] cards() {
    return cards;
  }
  
  public Card card(int i) {
    if (!empty() && i >= 0 && i < length(cards)) {
      return cards[i];
    } else {
      return null;
    }
  }
  
  public Card anyCard() {
    if (!empty()) {
      return card(random(length(cards)-1));
    } else {
      return null;
    }
  }
  
  public Card bottomCard() {
    if (!empty()) {
      return card(length(cards)-1);
    } else {
      return null;
    }
  }
  
  public Card topCard() {
    if (!empty()) {
      return card(0);
    } else {
      return null;
    }
  }
  
  public boolean hasCard(Card c) {
    if (!empty()) {
      boolean has = false;
      for (int i=0; i<length(cards); i++) {
        if (cards[i].equals(c)) {
          has = true;
          break;
        }
      }
      return has;
    } else {
      return false;
    }
  }
  
  public int indexOfCard(Card c) {
    if (hasCard(c)) {
      int i;
      for (i=0; i<length(cards); i++) {
        if (cards[i].equals(c)) {
          break;
        }
      }
      return i;
    } else {
      return -1;
    }
  }
  
  // methods that remove cards from this pile
  
  public Card removeCard(int i) {
    if (!empty() && i >= 0 && i < length(cards)) {
      Card c = cards[i];
      if (length(cards) > 1) {
        Card[] t = new Card[length(cards) - 1];
        int k = 0;
        for (int j = 0; j < length(cards); j++) {
          if (j == i) {
            continue;
          } else {
            t[k] = cards[j];
            k++;
          }
        }
        cards = t;
      } else {
        cards = null;
      }
      return c;
    } else {
      return null;
    }
  }
  
  public Card removeCard(Card c) {
    return removeCard(indexOfCard(c));
  }
  
  // methods that do other things to cards
  
  public boolean add(Card c, boolean moveTo) {
    if (c != null) {
      if (cards == null) {
        this.cards = new Card[1];
        this.cards[0] = c;
      } else {
        Card[] temp = new Card[length(cards) + 1];
        for (int i = 1; i < length(temp); i++) {
          temp[i] = this.cards[i - 1];
        }
        this.cards = temp;
        this.cards[0] = c;
      }
      if (moveTo) {
        if (parent.state().equals("init")) {
          c.moveTo(this.pos.x, this.pos.y);
        } else {
          c.moveTo(this.pos.x, this.pos.y, anim);
        }
      }
      return true;
    } else {
      return false;
    }
  }
  
  public boolean add(Card c) {
    return this.add(c, true);
  }
  
  public void reverse() {
    Card[] temp = new Card[length(cards)];
    for (int i=0; i<length(cards); i++) {
      temp[length(cards)-i-1] = cards[i];
    }
    cards = temp;
  }
  
  public void shuffle() {
    //Fisher-Yeats shuffle
    for (int i = length(cards) - 1; i > 0; i--) {
      int j = random(i);
      Card t = cards[i];
      cards[i] = cards[j];
      cards[j] = t;
    }
  }

  // utility methods

  public boolean empty() {
    return (this.cards == null);
  }
  
  public String name() {
    return name;
  }
  
  public int size() {
    if (!empty()) {
      return length(cards);
    } else {
      return 0;
    }
  }
  
  public String toString() {
    String s = new String();
    for (int i = 0; i < length(cards); i++) {
      s += cards[i].toString() + "\n";
    }
    return s;
  }
  
  public String type() {
    return "Pile";
  }
  
  public boolean validate(Card c) {
    if (c != null) {
      return true;
    } else {
      return false;
    }
  }
  
  public boolean validate(Pile p) {
    return false;
  }
  
  // methods that take cards from other piles
  
  public boolean takeCardFromPile(Card c, Pile p) {
    if (c != null) {
      println(this.name + " tries to take " + c + " from " + p.name());
      if (p.hasCard(c) && (this.validate(c) || this.validate(p))) {
        println(this.name + " takes " + c + " from " + p.name());
        this.add(p.removeCard(c));
        return true;
      } else {
        return false;
      }
    } else {
      return false;
    }
  }
  
  public boolean takeTopCardFromPile(Pile p) {
    return this.takeCardFromPile(p.topCard(), p);
  }
  
  /*
  public boolean takeFromBottomOfPile(Pile p) {
    if (this.add(p.takeBottomCard())) {
      return true;
    } else {
      return false;
    }
  }
  
  public Card drawBottomCard() {
    Card c;
    try {
      c = cards[length(cards) - 1];
      if (length(cards) > 1) {
        Card[] temp = new Card[length(cards) - 1];
        for (int i = 0; i < length(temp); i++) {
          temp[i] = cards[i];
        }
        cards = temp;
      } else {
        cards = null;
      }
    } catch (IndexOutOfBoundsException e) {
      c = null;
    } catch (NullPointerException e) {
      c = null;
    }
    return c;
  }
  
  public Card drawTopCard() {
    Card c;
    try {
      c = cards[0];
      if (length(cards) > 1) {
        Card[] temp = new Card[length(cards) - 1];
        for (int i = 0; i < length(temp); i++) {
          temp[i] = cards[i + 1];
        }
        cards = temp;
      } else {
        cards = null;
      }
    } catch (IndexOutOfBoundsException e) {
      c = null;
    } catch (NullPointerException e) {
      c = null;
    }  
    return c;
  }
  */
  
  // methods that change pile position
  
  public Position getPos() {
    return pos;
  }
  
  public void moveTo(int x, int y) {
    pos.moveTo(x, y);
  }
  
  public void moveTo(Position p) {
    pos.moveTo(p);
  }
  
  public void update() {
    pos.update();
  }
  
  // methods that return information about pile position
  
  public int x() {
    return pos.x();
  }
  
  public int y() {
    return pos.y();
  }
  
  public Position pos() {
    return pos;
  }
}


class Position {
  private int x;
  private int y;
  private int steps = 1;
  private int fx; //fixed-point
  private int fy; //fixed-point
  private int tx; //fixed-point target x
  private int ty; //fixed-point target y
  private String state;
  
  Position() {
    this(0, 0);
  }
  
  Position(int x, int y) {
    this.state = "static";
    this.x = x;
    this.y = y;
    fx = itofp(x);
    fy = itofp(y);
    tx = fx;
    ty = fy;
  }
  
  public String toString() {
    return x + ", " + y;
  }
  
  public int x() {
    return this.x;
  }
  
  public int y() {
    return this.y;
  }
  
  public void moveTo(int x, int y, int s) {
    this.steps = max(s, 1);
    if (steps > 1) {
      this.state = "moving";
      this.tx = itofp(x);
      this.ty = itofp(y);
    } else {
      this.state = "static";
      this.x = x;
      this.y = y;
      fx = itofp(x);
      fy = itofp(y);
      tx = fx;
      ty = fy;
    }
  }
  
  public void moveTo(int x, int y) {
    this.moveTo(x, y, 1);
  }
  
  public void moveTo(Position p, int s) {
    this.moveTo(p.x, p.y, s);
  }
  
  public void moveTo(Position p) {
    this.moveTo(p.x, p.y);
  }
  
  public void update() {
    int dx;
    int dy;
    if (fx != tx) {
      dx = div(abs(fx - tx), itofp(steps));
      if (fx > tx) {
        fx -= dx;
      } else {
        fx += dx;
      }
    } else {
      dx = -1;
    }
    if (fy != ty) {
      dy = div(abs(fy - ty), itofp(steps));
      if (fy > ty) {
        fy -= dy;
      } else {
        fy += dy;
      }
    } else {
      dy = -1;
    }
    x = fptoi(fx);
    y = fptoi(fy);
    if (dx <= 0 && dy <= 0) {
      state = "static";
      x = fptoi(tx);
      y = fptoi(ty);
    }
  }
}


class Stock extends Pile {
  Stock(Klondike p) {
    super(p);
    this.name = "Stock";
  }
  
  public boolean add(Card c) {
    if (c != null) {
      c.turnFaceDown();
      c.moveTo(super.pos);
      return super.add(c, false);
    } else {
      return false;
    }
  }
  
  public String type() {
    return "Stock";
  }
  
  public void draw() {
    if (!this.empty()) {
      this.topCard().draw();
    } else {
      this.drawEmpty();
    }
  }
  
  private void drawEmpty() {
    pushMatrix();
    translate(super.pos.x, super.pos.y);
    image(((Klondike)super.parent).deck().art(), 1, 142, 33, 45, 0, 0);
    popMatrix();
  }
}


class Tableau extends Pile {
  private int index;
  private int cursorDepth = -1;

  Tableau(Klondike p, int i) {
    super(p);
    index = i;
    name = "Tableau " + index;
  }
  
  public void draw() {
    if (!super.empty()) {
      for (int i=length(super.cards)-1; i>=0; i--) {
        super.cards[i].draw();
      }
    } else {
      //super.drawEmpty();
    }
  }
  
  public boolean add(Card c) {
    if (c != null) {
      if (super.cards == null) {
        super.cards = new Card[1];
        super.cards[0] = c;
      } else {
        Card[] temp = new Card[length(super.cards) + 1];
        for (int i = 1; i < length(temp); i++) {
          temp[i] = super.cards[i - 1];
        }
        super.cards = temp;
        super.cards[0] = c;
      }
      int x = super.pos.x;
      int y = super.pos.y + 8*(length(super.cards)-1);
      int s = 25;
      if (super.parent.state().equals("init")) {
        s = 1;
      }
      c.moveTo(x, y, s);
      return true;
    } else {
      return false;
    }
  }
  
  public boolean validate(Card c) {
    if (!super.empty()) {
      Card t = super.topCard();
      if (!c.suitColour().equals(t.suitColour()) && (t.rank().value()-c.rank().value()) == 1) {
        return true;
      } else {
        return false;
      }
    } else {
      if (c.rank() == ((Klondike)super.parent).deck().ranks[12]) {
        return true;
      } else {
        return false;
      }
    }
  }
  
  public boolean validate(Pile p) {
    if (p != null) {
      if (p.type().equals("Deck") || (p.type().equals("Hand") && p.parent.state().equals("undo"))) {
        return true;
      } else {
        return false;
      }
    } else {
      return false;
    }
  }
  
  public int getCursorDepth() {
    return cursorDepth;
  }
  
  public Card getCursorCard() {
    return super.cards[cursorDepth];
  }
  
  public boolean setCursorDepth(int d) {
    if ((d >= 0) && (d < this.cardsFacingUp())) {
      cursorDepth = d;
      return true;
    } else {
      return false;
    }
  }
  
  private int cardsFacingUp() {
    if (super.empty()) {
      return 0;
    } else if (super.size() == 1) {
      return 1;
    } else {
      int n = super.size();
      for (int i=0; i<super.size(); i++) {
        if (super.cards[i].isFaceDown()) {
          n = i;
          break;
        }
      }
      return n;
    }
  }
  
  public String type() {
    return "Tableau";
  }
}


class Waste extends Pile {
  Waste(Klondike p) {
    super(p);
    name = "Waste";
  }
  
  int fanout = 0;
  
  public boolean add(Card c) {
    if (c != null) {
      if (fanout < 3) {
        c.turnFaceUp();
        if (super.parent.state().equals("undo")) {
          c.moveTo(super.pos.x+12*fanout, super.pos.y, anim);
        } else {
          c.moveTo(super.pos.x+12*fanout, super.pos.y);
        }
        fanout++;
        return super.add(c, false);
      } else {
        for (int i=0; i<fanout; i++) {
          super.cards[fanout-i-1].moveTo(super.pos.x, super.pos.y);
        }
        fanout = 0;
        c.turnFaceUp();
        c.moveTo(super.pos.x+12*fanout, super.pos.y);
        fanout++;
        return super.add(c, false);
      }
    } else {
      return false;
    }
  }
  
  public boolean validate(Card c) {
    return false;
  }
  
  public boolean validate(Pile p) {
    if (p != null) {
      if (p.type().equals("Stock") || (p.type().equals("Hand") && p.parent.state().equals("undo"))) {
        return true;
      } else { 
        return false;
      }
    } else {
      return false;
    }
  }
  
  public Card removeCard(Card c) {
    c = super.removeCard(c);
    if (c != null) {
      fanout--;
    }
    return c;
  }
  
  public boolean condense() { 
    for (int i=0; i<fanout; i++) {
      super.cards[fanout-i-1].moveTo(super.pos.x, super.pos.y);
    }
    fanout = 0;
    return true;
  }
  
  public void draw() {
    if (!super.empty()) {
      if (length(super.cards) > fanout) {
        super.cards[fanout].draw();
      }
      for (int i=0; i<fanout; i++) {
        super.cards[fanout-i-1].draw();
      }
    }
  }
  
  public int fanout() {
    return fanout;
  }
  
  public void reset() {
    fanout = 0;
  }
  
  public String type() {
    return "Waste";
  }
}

}