/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import processing.core.PImage;
import processing.core.PMIDlet;

public class PFont {
    public int charCount;
    public PImage[] images;
    public char[] value;
    public byte[] heights;
    public byte[] width;
    public byte[] setWidth;
    public byte[] topExtent;
    public byte[] leftExtent;
    protected int[] ascii;
    public final int baseline;
    public final int height;
    public Font font;

    public PFont(Font font) {
        this.font = font;
        this.height = font.getHeight();
        this.baseline = font.getBaselinePosition();
    }

    public PFont(InputStream inputStream, int n, int n2) {
        try {
            int n3;
            int n4;
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            this.charCount = dataInputStream.readInt();
            int n5 = dataInputStream.readInt();
            this.value = new char[this.charCount];
            this.heights = new byte[this.charCount];
            this.width = new byte[this.charCount];
            this.setWidth = new byte[this.charCount];
            this.topExtent = new byte[this.charCount];
            this.leftExtent = new byte[this.charCount];
            this.ascii = new int[128];
            for (n4 = 0; n4 < 128; ++n4) {
                this.ascii[n4] = -1;
            }
            n4 = 0;
            int n6 = 0;
            for (n3 = 0; n3 < this.charCount; ++n3) {
                this.value[n3] = dataInputStream.readChar();
                this.heights[n3] = dataInputStream.readByte();
                this.width[n3] = dataInputStream.readByte();
                this.setWidth[n3] = dataInputStream.readByte();
                this.topExtent[n3] = dataInputStream.readByte();
                this.leftExtent[n3] = dataInputStream.readByte();
                if (this.value[n3] < '\u0080') {
                    this.ascii[this.value[n3]] = n3;
                }
                n4 = Math.max(n4, this.topExtent[n3]);
                n6 = Math.max(n6, n4 + this.heights[n3] - this.topExtent[n3]);
            }
            this.baseline = n4;
            this.height = n6;
            this.images = new PImage[this.charCount];
            byte[] byArray = null;
            for (int i = 0; i < this.charCount; ++i) {
                n3 = dataInputStream.readInt();
                if (n3 <= 0) continue;
                byte[] byArray2 = new byte[n3];
                dataInputStream.readFully(byArray2);
                if (n != 0 || n2 != 0xFFFFFF) {
                    if (byArray == null) {
                        int n7;
                        int n8 = (n2 & 0xFF0000) >> 16;
                        int n9 = (n2 & 0xFF00) >> 8;
                        int n10 = n2 & 0xFF;
                        int n11 = ((n & 0xFF0000) >> 16) - n8;
                        int n12 = ((n & 0xFF00) >> 8) - n9;
                        int n13 = (n & 0xFF) - n10;
                        int n14 = 41;
                        for (n7 = 0; n7 < 256; ++n7) {
                            byArray2[n14++] = (byte)(n8 + n7 * n11 / 255);
                            byArray2[n14++] = (byte)(n9 + n7 * n12 / 255);
                            byArray2[n14++] = (byte)(n10 + n7 * n13 / 255);
                        }
                        n7 = PMIDlet.crc(byArray2, 37, 772);
                        byArray2[809] = (byte)((n7 & 0xFF000000) >> 24);
                        byArray2[810] = (byte)((n7 & 0xFF0000) >> 16);
                        byArray2[811] = (byte)((n7 & 0xFF00) >> 8);
                        byArray2[812] = (byte)(n7 & 0xFF);
                        byArray = new byte[772];
                        System.arraycopy(byArray2, 41, byArray, 0, 772);
                    } else {
                        System.arraycopy(byArray, 0, byArray2, 41, 772);
                    }
                }
                this.images[i] = new PImage(byArray2);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    public int getIndex(char c) {
        if (c < '\u0080') {
            return this.ascii[c];
        }
        return this.getIndex(c, 0, this.charCount - 1);
    }

    private int getIndex(int n, int n2, int n3) {
        int n4 = (n2 + n3) / 2;
        if (n == this.value[n4]) {
            return n4;
        }
        if (n2 >= n3) {
            return -1;
        }
        if (n < this.value[n4]) {
            return this.getIndex(n, n2, n4 - 1);
        }
        return this.getIndex(n, n4 + 1, n3);
    }

    public int charsWidth(char[] cArray, int n, int n2) {
        int n3 = 0;
        if (this.font != null) {
            n3 = this.font.charsWidth(cArray, n, n2);
        } else {
            int n4 = n + n2;
            for (int i = n; i < n4; ++i) {
                int n5 = this.getIndex(cArray[i]);
                if (n5 >= 0) {
                    n3 += this.setWidth[n5];
                    continue;
                }
                n3 += this.setWidth[this.ascii[105]];
            }
        }
        return n3;
    }

    public int charWidth(char c) {
        int n;
        int n2 = this.font != null ? this.font.charWidth(c) : ((n = this.getIndex(c)) >= 0 ? this.setWidth[n] : this.setWidth[this.ascii[105]]);
        return n2;
    }

    public int stringWidth(String string) {
        int n = this.font != null ? this.font.stringWidth(string) : this.substringWidth(string, 0, string.length());
        return n;
    }

    public int substringWidth(String string, int n, int n2) {
        int n3 = 0;
        if (this.font != null) {
            n3 = this.font.substringWidth(string, n, n2);
        } else {
            int n4 = n + n2;
            for (int i = n; i < n4; ++i) {
                int n5 = this.getIndex(string.charAt(i));
                if (n5 >= 0) {
                    n3 += this.setWidth[n5];
                    continue;
                }
                n3 += this.setWidth[this.ascii[105]];
            }
        }
        return n3;
    }

    /*
     * WARNING - void declaration
     */
    public void draw(Graphics graphics, String string, int n, int n2, int n3) {
        if (this.font != null) {
            void var6_10;
            graphics.setFont(this.font);
            int n4 = 16;
            if (n3 == 0) {
                int c = n4 | 1;
            } else if (n3 == 5) {
                int n5 = n4 | 8;
            } else {
                int n6 = n4 | 4;
            }
            graphics.drawString(string, n, n2 - this.font.getBaselinePosition(), (int)var6_10);
        } else {
            if (n3 != 2) {
                int n7 = this.stringWidth(string);
                if (n3 == 0) {
                    n -= n7 >> 1;
                } else if (n3 == 5) {
                    n -= n7;
                }
            }
            int n8 = string.length();
            for (int i = 0; i < n8; ++i) {
                char c = string.charAt(i);
                int n9 = this.getIndex(c);
                if (n9 >= 0) {
                    graphics.drawImage(this.images[n9].image, n + this.leftExtent[n9], n2 - this.topExtent[n9], 20);
                    n += this.setWidth[n9];
                    continue;
                }
                n += this.setWidth[this.ascii[105]];
            }
        }
    }
}

