#!/usr/bin/env python3
from random import shuffle
from math import gcd
from itertools import product
from string import ascii_lowercase
from PIL import Image
from glob import glob
from os import path, makedirs, system
from sys import stdout
from shutil import rmtree, copytree

def w(bla):
	stdout.write(bla)
	stdout.flush()

class Frame(object):
	def __init__(self, img):
		self.img = Image.new("RGBA", (16, 16), (68, 102, 163, 255))
		self.img.alpha_composite(img.convert("RGBA"))
		self.duration = img.info["duration"] or 100
		self.repetitions = 1

files_to_process = glob("gifs/*.gif")
shuffle(files_to_process)
rmtree("out", True)
		
for fnum, (fname, dname) in enumerate(zip(files_to_process, product(ascii_lowercase, repeat=3))):
	with Image.open(fname) as img:
		frames = []
		durations = []
		repeat = []
		total_duration = 0
		w(fname)
		for i in range(img.n_frames):
			w(".")
			img.seek(i)
			frames.append(Frame(img))			
			
		if len(set(f.duration for f in frames)) == 1:
			frame_delay = max(30, frames[0].duration)
		else:
			raster = frames[0].duration
			for f in frames[1:]:
				raster = gcd(raster, f.duration)
			while raster < 30:
				raster *= 2
			for f in frames:
				f.repetitions = f.duration // raster
			frame_delay = raster
		
		w("%d " % frame_delay)
		
		outdir = path.join("out", "".join(dname))
		makedirs(outdir)
		i = 0
		for f in frames:
			for j in range(f.repetitions):
				f.img.save(path.join(outdir, "%d.bmp" % i))
				i += 1
		w("%d" % i)
		
		with open(outdir + "/config.ini", "wb") as f:
			f.write(b"[animation]\nhold = %d\nloop = true\n" % frame_delay)
		
		w("\n")

	if (fnum % 10) == 0:
		rev = (fnum // 10) % 3
		copytree("rev%d" % rev, outdir+"_")
	