#version 330 core
out vec4 FragColor;

// also for this learned a lot from Flopine's HBHS series. Thanks a bunch, Flopine!!


in vec3 ourColor; // is this necessary?
in vec2 TexCoord;

uniform vec2 u_resolution;
uniform float u_time;
uniform sampler2D texture15; 
float pi = 3.141592;
float iter = 100.;
float time = u_time;
#define deg_to_rad(degree) (degree*pi/180.) // radians to degree
float b_time = u_time -236.;

float BPM = (120/2.)/60.; // for less visual change but synced

//vec2 uv = (gl_FragCoord.xy -.5*u_resolution.xy)/u_resolution.y;
//vec2 UV = gl_FragCoord.xy/u_resolution.xy; // to change the width of the thing based on the location on screen
												// original uv coordinates without any changes :: 0,0 to 1,1    
float sdSphere( vec2 p, float s )
{
  return length(p)-s;
}

float stmin(float a, float b, float k, float n)
{

	float st = k/n;
	float u = b-k;
	return min(min(a,b), .5*(u+a+abs(mod(u-a+st, 2.*st)-st)));

}

float smin( float a, float b, float k)
{

	float h = clamp(.5 + .5 * (b-a) / k, 0.0, 1.);
	return mix(b, a, h) - k*h*(1. - h);

}

mat2 rot (float a)
{
	return mat2(cos(a), sin(a), -sin(a), cos(a));

}

void mo(inout vec2 p, vec2 d)
{

	p = abs(p) - d;
	if (p.y > p.x) p = p.yx;
}

float sc (vec3 p, float s) // sine cross?
{
	vec3 pp = p;
	//p.xz *= rot(time);
	p = (1.-p) * min(p, p.xyz);	// p = abs(p);
	//p = max(p, p.yzx);
	float d = min(p.x, min(1.-p.y, 1.-p.z)) / s;
	//return d;
	return max(d, -(abs(pp.y))); //return max(d, -(abs(pp.x)-((pi + pp.y)* .1)));//return max (d, -pp.x); //return max(d, p.y);
	
}

float od(vec3 p, float d)
{
	//p.xz += vec2(sin(time), cos(b_time));
	return dot(p, normalize(sign(p)))-d;

}



float box(vec3 p, vec3 c) // p position of box, c position of corner
{

	vec3 q = abs(p)-c;
	vec3 movey = pow(q, vec3(-1.));
	
	movey.yz *= rot(abs(atan(b_time)));
	
	return min(0., max(movey.x, max(movey.y, q.z))) + length(max(pow(q, vec3(1.3)), 0.)); //+ length(max(q, 0.))

}

float sdf (vec3 p)
{
	float dt = pi / 5. * (floor(b_time * BPM) + pow(fract(b_time), pi));
	p.yz *= rot(-atan(1./sqrt(3.))) / dot(p.y, pow(p.y, -1.));
	p.xz *= rot(deg_to_rad(45.));
	//mo(p.xz, vec2(2.5));
	mo(p.yx, vec2(p.z - (1.-abs(sin(b_time))), p.y / p.z));
	if(b_time < 12)p.z += p.y	;
	if(b_time > 12)p.z *= atan(b_time * BPM) - 1.;
	//p.y -= 1.3*cos(-b_time);
	//p.xz *=rot(time);
	mo(p.yx, vec2((b_time*.3), 1. - atan(b_time)*.3));
	p.z += 4.;
	mo(p.zx, vec2(0.799));	//mo(p.xy, vec2(.2*cos(b_time)));
	p.x += 1.- (sin(p.y)) + p.z;
	p.xz += vec2(atan(dt), cos(-dt)); //p.xz += vec2(cos(b_time), sin(b_time)); 
	
	
	//p.xz += vec2(cos(b_time), sin(-b_time)); // or .. p.yz
	//return min(box(p + vec3(0., 0., -5.), vec3(1.)), max(-sc(p, 0.79),box(p, vec3(1.))));
	if(b_time < 17)return max(-sc(p, 4.79), box(p, vec3(p.y, p.x, p.z)));
	if(b_time > 17)return min(box(p, vec3(pi)), max(sc(p, pi),sdSphere(vec2(2. - fract(p.x), 4. -p.z), -1.)));
	//p.xy *= rot(time);
	
	
	
	//return min(length(p)-(.1 + exp(-fract(time))*.3), max(-sc(p, .79), box(p, vec3(1.))));
	//return stmin(od(p,.5), max(-sc(p,.799),box(p, vec3(1.))),.5, 5.);//return max(-sc(p, .799), box (p, vec3(1.)));
	//return smin(od(p, .5), max(-sc(p, 1.799), box (p, vec3(1.))), .91);
}


void main()
{
	vec2 uv = vec2(gl_FragCoord.x / u_resolution.x, gl_FragCoord.y / u_resolution.y);
	uv -= .5;
	uv /= vec2(u_resolution.y / u_resolution.x, 1);
	//vec2 uv = (2.*gl_FragCoord.xy-u_resolution.xy) / u_resolution.y;

	// there was going to be a whole projection matrix, but instead
	// "rays with a fixed direction like vec3(0,0,1) and an origin vec3(uv, -5)
	
	vec3 ro = vec3(1.-uv.x*6.+sin(b_time), -.1 + (dot(length(uv.y), pow(uv.x, -1.))), -12.99), // vec3(uv*20, -20.) to not cut off so quickly?
	
	rd = normalize(vec3(0., 0., 1.)),
	
	
	p = ro,
	col = vec3(.0, .0, .3);
	
	bool hit = false;
	float shad = 0.;
	for (float i=0.; i < 70.; i++)
	{
	
		float d = sdf(p);
		if(d < 0.001)
		{
			hit = true;
			shad = i/64.;
			break;
		
		}
		p += d * rd *.6; // position is = distance times ray direction -> marching along the ray
	}
	if (hit)
	{
	
	col = vec3(.712 - fract(shad), .3- ceil(shad), .79 - shad); //col = vec3(1. - shad); // 
		
	}
	
	FragColor = vec4(col, 1.);
}