#version 330 core
out vec4 FragColor;

// learned much for this, from Flopine's HBHS series. Thank you Flopine!!


in vec3 ourColor; // is this necessary?
in vec2 TexCoord;
varying vec3 position;
vec3 could_you = position;
uniform vec2 u_resolution;
uniform float u_time;
uniform sampler2D texture15; // if textures // why 15. not zero or one? (need to adjust the source file of course)
float pi = 3.141592;
float iter = 100.;
float time = u_time - 35.;
float b_time = u_time - 35.;
#define deg_to_rad(degree) (degree*pi/180.) // radians to degree
float draws = 0.;
float draws2 = 0.;

float BPM = (138/2.)/60.; // for less visual change but synced

//vec2 uv = (gl_FragCoord.xy -.5*u_resolution.xy)/u_resolution.y;
//vec2 UV = gl_FragCoord.xy/u_resolution.xy; // to change the width of the thing based on the location on screen
												// original uv coordinates without any changes :: 0,0 to 1,1    

float strip(float t, float start, float end, float blur)
{

	float step1 = smoothstep(start-blur, start+blur, t);
	float step2 = smoothstep(end+blur, end-blur, t);
	return step1*step2;
}

float rect(vec2 uv, float left, float right, float bottom, float top, float blur)
{
	float band1 = strip(uv.x, left, right, blur);
	float band2 = strip(uv.y, bottom, top, blur);

	return band1+band2;
}

float remap01(float a, float b, float t)
{
	return (t - a) / (b - a); // gives either 0 or 1
}

float remap(float a, float b, float c, float d, float t)
{
	return remap01(a, b, t) * (d-c) + c;
}

float strip2(float t, float start, float end, float blur)
{

	float step1 = smoothstep(start, end, t);
	float step2 = smoothstep(end, start, t);
	return step1-step2;

}

float rect2(vec2 uv, float left, float right, float bottom, float top, float blur)
{
	float band = strip2(uv.x, bottom, left, blur);
	return band;
}

void main()
{

	if (time > 14) time = time - 14;
	vec2 uv = vec2(gl_FragCoord.x / u_resolution.x, gl_FragCoord.y / u_resolution.y);
	uv -= .5;
	uv /= vec2(u_resolution.y / u_resolution.x, 1);
	//vec2 uv = (2.*gl_FragCoord.xy-u_resolution.xy) / u_resolution.y;
	uv *= 2.;
	float cx = (u_resolution.x - (.5 * uv.x)) / (u_resolution.x - (.75 * uv.x));
	float cy = (u_resolution.y - (.5 * uv.y)) / (u_resolution.x - (.75 * uv.y));
	


	vec3 col = vec3(0.);
	
	
	float x = uv.x ;
	float m = sin(time + x * 1.9) * .1;
	float y = uv.y - m;
	float blur = remap(-.2, .2, .01, .25, smoothstep(y * x, (pi) *time  , sin(uv.y*uv.x))) ;
	blur = pow( blur + (x/y - pi), sin(time)*.5 - ( x * normalize(y) ) );
	draws = rect(vec2(x, y), -.65, .65, -.1, .1, blur);
	draws += smoothstep(floor((time *.6))*x, ceil(cos(normalize(floor(y+x)))/pi), floor(abs(tan(x+y))+pi));
	
	draws2 = rect2(vec2(could_you.y, atan(could_you.x)), -.65, .65, sqrt(y), sqrt(x), blur);
	draws2 += smoothstep(floor((time)+2), ceil(cos(normalize(floor(could_you.y + could_you.x)))/pi), floor(abs(tan(x+y))/(sqrt(cos(y-x)))));
	
	if (b_time < 14) col = vec3(.24, .47, .56)*draws;
	if (b_time > 14) col = vec3(.51, .24, .56)*draws2;
	FragColor = vec4(col, 1.);
}