#version 330 core
out vec4 FragColor;

in vec3 ourColor; // is this necessary?
in vec2 TexCoord;

uniform vec2 u_resolution;
uniform float u_time;
uniform sampler2D texture14; 
float pi = 3.141592;
float b_time = u_time - 212;
#define deg_to_rad(degree) (degree*pi/180.) // radians to degree
//vec2 uv = (gl_FragCoord.xy -.5*u_resolution.xy)/u_resolution.y;
//vec2 UV = gl_FragCoord.xy/u_resolution.xy; // to change the width of the thing based on the location on screen
												// original uv coordinates without any changes :: 0,0 to 1,1    
vec2  hr = vec2(1., sqrt(3.));
float detail = 10.;

// raymarcher things
float BPM = (138/2.)/60.; // for less visual change but synced

float iter = 100.;
float time = b_time;

float stmin(float a, float b, float k, float n)
{

	float st = k/n;
	float u = b-k;
	return min(min(a,b), .5*(u+a+abs(mod(u-a+st, 2.*st)-st)));

}

float smin( float a, float b, float k)
{

	float h = clamp(.5 + .5 * (b-a) / k, 0.0, 1.);
	return mix(b, a, h) - k*h*(1. - h);

}

mat2 rot (float a)
{
	return mat2(cos(a), sin(a), -sin(a), cos(a));

}

void mo(inout vec2 p, vec2 d)
{

	p = abs(p) - d;
	if (p.y > p.x) p = p.yx;
}

float sc (vec3 p, float s) // sine cross?
{
	vec3 pp = p;
	//p.xz *= rot(time);
	p = abs(1.-p)+max(p, p.xyz);	// p = abs(p);
	//p = max(p, p.yzx);
	float d = min(p.x, min(1.-p.y, 1.-p.z)) / s;
	return d;
	//return max(d, -(abs(pp.x)-.3)); //return max(d, -(abs(pp.x)-((pi + pp.y)* .1)));//return max (d, -pp.x); //return max(d, p.y);
	
}

float od(vec3 p, float d)
{
	//p.xz += vec2(sin(time), cos(time));
	return dot(p, normalize(sign(p)))-d;

}

float sdSphere( vec2 p, float s )
{
  return length(p)-s;
}

float box(vec3 p, vec3 c) // p position of box, c position of corner
{

	vec3 q = abs(p)-c;
	return min(0., max(q.x, max(q.y, q.z))) + length(max(q, 0.));

}

float sdf (vec3 p)
{
	float dt = pi / 5. * (floor(time) + pow(fract(time), pi));
	p.yz *= rot(-atan(1.2/sqrt(3.)));
	p.xz *= rot(deg_to_rad(45.) * cos(b_time));
	//mo(p.xz, vec2(2.5));
	mo(p.yx, vec2(p.z * (1.-abs(atan(time))), pi));
	p.z += 1. + p.x;
	//p.y -= 1.3*cos(-time);
	//p.xz *=rot(time);
	mo(p.yx, vec2(-1.*cos(time)*.3, -1.*sin(time)*.3));
	p.z += 4.;
	mo(p.zx, vec2(0.5, pi));	//mo(p.xy, vec2(.2*cos(time)));
	p.x += .15- (sin(p.y)) + p.z;
	p.xz += vec2(atan(dt), cos(-dt)); //p.xz += vec2(cos(time), sin(time)); 
	
	
	//p.xz += vec2(cos(time), sin(-time)); // or .. p.yz
	//return min(box(p + vec3(0., 0., -5.), vec3(1.)), max(-sc(p, 0.79),box(p, vec3(1.))));
	//return max(-sc(p, 0.79), sdSphere(p, vec3(1.)));
	//p.xy *= rot(time);
	
	
	//return min(length(p)-(.1 + exp(-fract(time))*.3), max(-sc(p, .79), box(p, vec3(1.))));
	//return stmin(od(p,.5), max(-sc(p,.799),box(p, vec3(1.))),.5, 5.);//return max(-sc(p, .799), box (p, vec3(1.)));
	return smin(od(p, 2.5), max(sc(p * .1, 2.), sdSphere(vec2((p.x) * 2., sin(p.y) * 2.), p.y * (ceil(1.4 - p.x)) - (p.y)*(.033))), (pi/2.));
}




float HexDist (vec2 uv)
{

	uv = abs(uv);
	return max(dot(uv, normalize(hr)), uv.x);
}

vec4 HexGrid(vec2 uv)
{
	uv *= detail;
	vec2 ga = mod(uv, hr)-hr*0.5;
	vec2 gb = mod(uv-hr*0.5, hr) - hr*0.5;
	vec2 guv = dot(ga, ga) < dot(gb, gb) ? ga : gb;
	
	vec2 id = uv-guv;
	//guv.y = HexDist(guv);
	guv.y = .5-HexDist(guv);
	return vec4(guv.x, guv.y, id.x, id.y);
}

vec2 megaplasma(vec2 v)
{
	vec2 mp = mod(v, vec2(ceil(pow(v.y, -1))))*abs(sin(b_time)*.1);
	mp.y = mp.y - atan(ceil(mp.x));
	float coord = (sqrt(pow(mp.x/mp.x, 2.))) - (sqrt(mp.y/mp.y))*pi + distance(cos(mp.x/mp.x)-pi, (sqrt(mp.y/mp.y * 2.))-(2*pi));
	mp.x += coord;
	mp.y *= coord;
	return vec2(mp.x, mp.y);

}

vec4 plas(vec2 v, float time)
{
	vec2 me = megaplasma( v);
	v.x -=  me.x;
	v.y -=  me.y;
	v.x -= step(ceil(v.x), pow(v.x, 2.)) + cos(v.x) *2.;
	v.y -= smoothstep(ceil(v.y), floor(v.x)  ,pow(v.y, -1.)) - sin(v.y) - 4.;
	//float c = 0.3 + sin(v.x ) + cos( sin( time + v.y) );
	float c = smoothstep((cos(v.x), -1.), atan(v.x * .1) , ceil(pow(atan(v.y), 2.)));
	c -= 0.5 + sin(v.x ) + cos( sin( time - v.y) );
	c *= atan(pow(me.y, -1.) / pow(v.y, -1));
	return vec4(vec3(c), 0.5);
}


void main()
{
	vec2 uv = vec2(gl_FragCoord.x / u_resolution.x, gl_FragCoord.y / u_resolution.y);
	uv -= .5;
	uv /= vec2(u_resolution.y / u_resolution.x, 1);
	
	vec3 col = vec3(0.);
	vec2 curly = vec2(0.);
	
	if(b_time < 15.5){
	vec2 m = vec2(.0);
	m.x = atan(uv.x / uv.y) / 3.14;
	m.y = .25 / length(uv);
	m.y *= ((distance((length(uv.x/uv.x /  uv.y/uv.y)) * sin(uv.x) / 1.-atan(uv.y), sqrt(pow(uv.y/uv.y, 2)) / atan(uv.x))) + abs(tan(b_time *.2)* .7)) ;
	float d = m.y + m.x;
	
	float f = texture(texture14, vec2(d * .12)).b * 95.; // col += texture(texture15, tUv).rgb*mask;
	m.x += cos(b_time) * .1;
	m.y += b_time * .125;
	
	vec4 t = plas( m * 3.14, (b_time *.42)) / d;
	curly = megaplasma(vec2(t.x, t.y));
	t = clamp(t *.1, .01, pi);
	
	//vec3 tex = texture(texture15, vec2(d)).r * 100.;
	col = vec3(t * f);
	
	//vec4 hc = HexGrid(uv);
	//col += vec3(hc.x, hc.y, hc.z);
	}

	if(b_time > 10){
	// raymarching??
		vec3 ro = vec3(1.-uv.x*12.+sin(time), -.75 + uv.y*7.2, -25.99), // vec3(uv*20, -20.) to not cut off so quickly?
	
		rd = normalize(vec3(0., 0., 1.)),
		p = ro,
		rcol = vec3(0.);
	
		bool hit = false;
		float shad = 0.;
		for (float i=0.; i < 64.; i++)
		{
	
			float d = sdf(p);
			if(d < 0.001)
			{
				hit = true;
				shad = i/64.;
				break;
		
			}
			p += d * rd *.6; // position is = distance times ray direction -> marching along the ray
		}
		if (hit)
		{
			rcol = vec3(.712 - ceil(shad), .6-shad, .79 - fract(shad)); //col = vec3(1. - shad); // 
		}
	// raymarching done??
	
		float mixer = .5;
		if(b_time < 15.5)FragColor = mix( vec4( col.x * curly.x, col.y * .1, col.z * curly.y, 1.0) , vec4(rcol.x, rcol.y, rcol.z, 1.), abs(sin(mixer * b_time)));
		if(b_time > 15.5 && b_time < 20.)FragColor = mix( vec4( col.x * curly.x, col.y * .1, col.z * curly.y, 1.0) , vec4(rcol.x, rcol.y, rcol.z, (2.2 - (b_time*.1))), abs(sin(mixer * b_time)));
		if(b_time > 20.)FragColor = vec4(rcol.x, rcol.y, rcol.z, 1.);
	}
	
	if(b_time < 10) FragColor = vec4( col.x * curly.x, col.y * .1, col.z * curly.y, 1.0);
}