#version 330 core

out vec4 FragColor;

in vec3 ourColor; 
in vec2 TexCoord;

uniform vec2 u_resolution;
uniform float u_time;
uniform sampler2D texture12;
varying vec3 position;
float b_time = u_time - 305.0;
float MAX_STEPS = 100.;
float MAX_DIST = 100.;
float SURF_DIST = .001;
float pi = 3.141592;
#define S smoothstep;
#define T u_time;
float turbulence = atan(2. / pi) * (pi + b_time) -.3;

float sdSphere( vec2 p, float s )
{
  return length(p)-s;
}

float sdTorus(vec2 p, vec2 r)
{

	float x = length(p.x) - r.x;
	return length(vec2(x, p.y)) - r.y;


}
mat2 Rot(float a) {
    float s=sin(a), c=cos(a);
    return mat2(c, -s, s, c);
}

float Hash21(vec2 p) {
	p = fract(p*vec2(123.34, 233.53));
	p += dot(p, p+23.234);
	return fract(p.x * p.y);
}

float sdBox(vec3 p, vec3 s) {
    p = abs(p)-s;
	return length(max(p, 0.))+min(max(p.x, max(p.y, p.z)), 0.);
}

float sdBox2d(vec2 p, vec2 s) {
    p = abs(p)-s;
	return length(max(p, 0.))+min(max(.5 * p.x, .5 * p.y), 0.);
}

float GetDist(vec3 p) {
    //float d = sdBox(p, vec3(1));

    float r1 = 1.7, r2 = .2;
	float r3 = 5.;
	
	vec2 cp = vec2(length(p.xz)-r1, p.y);
	
	// added stuff
	vec2 xy = vec2(p.x, p.y);
	vec2 third = vec2(length(p.y) +1., length(p.x*.5)) ;
	vec2 fourth =  vec2(cos(p.x), sin(p.y));
	vec3 f1 = vec3(fourth.x, fourth.y, 1.);
	vec3 f2 = vec3(p.x, p.y, p.z);
	vec3 f3 = vec3(sin(p.y), cos(p.x), 1.);
	//cp.x *= cos(third);
	
	if (b_time < 14) {
	//	cp =  .5+  abs(cos(fourth));
	//	cp.x *= dot(f3.x, f1.y);
	//	cp.y = atan(dot(f1.y, f3.y)) * sin(dot(f3.x, f1.x));
	float t = length(p.y) +1. + length(p.x*.5) ;
	vec2 t2 =  vec2(cos(p.x), sin(p.y));
	cp.x *= cos(t);
	cp =  .5+  abs(cos(t2));
	float a = atan(p.x, p.z); // angle around center point
						     // polar angle between -pi and pi
	cp *= Rot(a *2.5 + b_time *.5);
	cp.y = abs(cp.y)-.4;
	float d = length(cp)-r3;
	
    if(b_time < 5) d = sdBox2d(cp, vec2(.1, .3*(atan(a)*.5+.5)))-.1;
	if(b_time > 5 && b_time < 14)d = sdBox2d(cp, vec2(.1, (atan(a)*.7 - .5*sin(1.- cos(dot(vec2(2.*pi, 2.), vec2(2.*pi/.5, 1.) ))))));
	return d * .5; // can make points dissapear, but makes raymarcher slower
	
	}
	if (b_time > 14 && b_time < 20) {
		float a = atan(cp.x, cp.y);
		cp.y = (pow(cp.y, 2.))- (pi/2.);
		vec2 t2 =  vec2( (sin((cp.x ))*(pi/2.), 5.01)) * (atan(b_time));
		cp.x += (cp.x / t2.x) + (cp.y / t2.y) * (sqrt( pi+ cp.x))* (pi / 2.);
		cp.y += sin(dot(-cp.x, (pi/2.))) * pi ;
		cp.y *= ( (cp.y - (cp.y * .01)) / (cp.x - (cp.x * .01))) * (cp.x - length(cp.x));
		
		cp *= Rot(-a *1.5 + b_time *.3);
		float d = sqrt(pow(length(cp.x) + length(cp.y), -1.) *.5) *.2;
		//float d = sdTorus(cp, vec2(.1, .3*(atan(a)-(dot(f3.y, f2.z))+.5)))-.1;
		
		
		return d * .45;
	}
	if(b_time > 20 && b_time < 24){
		cp =  .1+  abs(cos(fourth));
		cp.x *= dot(f3.x + sin(f2.x), sin(f2.y) * cos(f2.x));
	
	}
	if (b_time > 24 ) cp -= .5 +  abs(cos(fourth));
	
	if(b_time > 32 && b_time < 42) {
		float a = atan(p.x, p.z); // angle around center point
						     // polar angle between -pi and pi
		
		// you can do length on vec2 too!!
		
		//float d = length(cp)-r2;
		cp = vec2(atan((p.y - length(p.y + turbulence)) / (p.x - length(p.x+1.))), sqrt(p.y+1.));
		cp.y += abs(cp.y)-.4;
		cp.x *= p.x /2.;
		cp *= Rot(a *2.5 -b_time *.5);
		
		float d = sdTorus(cp, vec2(.5, (atan(a)*.1+.5)));
		return d * .1;
		
		
		}
	if(b_time > 42){
		float a = atan(p.x, p.z);
		cp =  .5+  abs(cos(fourth));
		vec3 fifth = vec3((length(p.x) - .5),sqrt(length(p.y + .25)), .5);
		
		if(b_time < 49){
			p = vec3(dot(vec3(p.y/ 2.),  vec3(p.z /2.))) -1.5;
			p.x -= p.x / 2. + atan(p.y);
			cp = vec2(length(p.xz) * ( p.x - length(p.x)), length(p.y)-1.);
			cp *= Rot(a *2.5  - b_time *.5);
			float d = sdBox2d(cp, vec2(.75, (atan(a + length(a))*.7 - .5*sin(1.- cos(dot(vec2(2.*pi, 2.), vec2(2.*pi/.5, 1.) ))))));
		return d * .5;
			}
		if(b_time > 49){
			vec2 dx = vec2((dot(cp.y, p.y) / pow(p.y, 2.)) * p.y) + .01 * (floor(p.x) - 1. * pi); 
			p -= vec3(2.6 - (length(dx.x )+ cp.y / cp.x))* 1.2 * (pi / 2.);
			cp.y -= ((1.1 - p.xz) *(pi/2.), dot((p.y)+.1, 0.21+(p.z)));
			cp.x *=  1.51 -((pi / 2.) *(sqrt(dx.x - 0.1))) + 0.75 / ceil(p.x * 0.11 * dx.y) / length(sqrt(dx.x)) ;
			vec3 fifth = 0.5 + vec3(((p.y - cos(b_time * .01)) - .5),((p.y + .25)), pi * cp.y);
			cp.x -= sin(cp.x)-.1 + (length(cp.x - .75));
			cp *= Rot(atan(dx.x) + a *  b_time *.5);
			float d = sdTorus(cp, vec2(.1, (atan(a)*.1+.5)));
		return d * .5;
		}
		
		
		float d = sdTorus(cp, vec2(.25, (atan(a + length(a))*.7 - .5*sin(1.- cos(dot(vec2(2.*pi, 2.), vec2(2.*pi/.5, 1.) ))))));
		return d * .5;
	}
	//

	//cp *= Rot(u_time); in and out rotation of 2 donuts
	float a = atan(p.x, p.z); // angle around center point
						     // polar angle between -pi and pi
	//a += sin(p.y) * sin(b_time);
	cp *= Rot(a *2.5 + b_time *.5);
	cp.y = abs(cp.y)-.4;
	// you can do length on vec2 too!!
	float d = length(cp)-r2;
	
	if(b_time < 32)d = sdTorus(cp, vec2(.1, .3*(atan(a)-(dot(f3.y, f2.z))+.5)))-.1;
    
	if(b_time > 42)  d = sdTorus(cp, vec2(.1, .3*(atan(a)*.5+.5)))-.1;
	return d * .5; // can make points dissapear, but makes raymarcher slower
}

float RayMarch(vec3 ro, vec3 rd)
	{
	
	float Do = 0.;
	
    for(int i=0; i < MAX_STEPS; i++) {
    	vec3 p = ro + rd * Do;
        float dS = GetDist(p);
        Do += dS;
        if( Do > MAX_DIST || abs(dS) < SURF_DIST) break;
    }
    
    return Do;
}

vec3 GetNormal(vec3 p) {
	float d = GetDist(p);
    vec2 e = vec2(.001, 0);
    
    vec3 n = d - vec3(
        GetDist(p-e.xyy),
        GetDist(p-e.yxy),
        GetDist(p-e.yyx));
    
    return normalize(n);
}

vec3 GetRayDir(vec2 uv, vec3 p, vec3 l, float z) {
    vec3 f = normalize(l-p),
        r = normalize(cross(vec3(0,1,0), f)),
        u = cross(f,r),
        c = f*z,
        i = c + uv.x*r + uv.y*u,
        d = normalize(i);
    return d;
}

vec3 Bg(vec3 rd){
	float k = rd.y * .5 + .5 ; // 0 - 1 range
	vec3 col = vec3(.0);
	if(b_time < 32)col = mix(vec3(.1, .61, .1), vec3(.12 , .5, .67), k);
	if(b_time > 32)col = mix(vec3(turbulence, .61, .1), vec3(turbulence, .5, .67), k);
	return col;
}

void main()
{
	vec2 uv = (gl_FragCoord.xy - .5*u_resolution.xy) /u_resolution.y;
	vec3 col = vec3(0);
	vec3 ro = vec3(0, 3, -3);
    ro.yz *= Rot(-0.5);
    ro.xz *= Rot(.995);
    vec3 rd = GetRayDir(uv, ro, vec3(0,0.,0), 1.);
    
	
	col += Bg(rd);
   
    float d = RayMarch(ro, rd);

    if(d<MAX_DIST) {
        vec3 p = ro + rd * d;
        vec3 n = GetNormal(p);
        vec3 r = reflect(rd, n);
		
		// for allowing spec to go negative :: float spec = r.y;
		// or not::
		//float spec = max(0., r.y);
		// or even sharper::
		float spec = pow(max(0., r.y), 30./ abs(tan(b_time *.2)));
		
        float dif = dot(n, normalize(vec3(1,2,3)))*.5+.5;
        //col += vec3(dif);
		//col = Bg(r);
		col = mix(Bg(r), vec3(dif * .65, dif * .3, dif * .3), .5)+spec;
	}

	FragColor = vec4(col, 1.);
}