@tool
extends Node3D

@export var useCommonAntennaRodAngle:bool = true:
	get:
		return useCommonAntennaRodAngle
	set(newUseCommonAntennaRodAngle):
		useCommonAntennaRodAngle = newUseCommonAntennaRodAngle
		
@export var commonAntennaRodAngle:float = 10:
	get:
		return commonAntennaRodAngle
	set(newCommonAntennaRodAngle):
		commonAntennaRodAngle = newCommonAntennaRodAngle

@export var antennaBaseAngle:float:
	get:
		return antennaBaseAngle
	set(newAntennaBaseAngle):
		antennaBaseAngle = newAntennaBaseAngle
#		$Antenna1.baseAngle = antennaBaseAngle

@export var commonAntennaBaseLocalTranslation:Vector3:
	get:
		return commonAntennaBaseLocalTranslation
	set(newCommonAntennaBaseLocalTranslation):
		commonAntennaBaseLocalTranslation = newCommonAntennaBaseLocalTranslation
#		$Antenna1.localTranslation = commonAntennaBaseLocalTranslation

@export var bodyMorphFraction:float
@export var exoFrameFraction:float
@export var scopeActive:bool
@export var scopeLightEnergy:float = 1
@export var haloAlbedo:Color = Color(0, 1, 0, 1)

# This is added due to bug:
# https://github.com/godotengine/godot/issues/57543
# Order is YXZ
@export var useRotationOverride:bool = true
@export var rotationOverride:Vector3 = Vector3(0,0,0)

@export var editorCameraPath:NodePath

#@onready var tunePlayer:AudioStreamPlayer = get_node("/root/Main/MainTunePlayer")

var initDone:bool = false

var animResetStashDone:bool = false

@export var trigStashToolData:bool = false:
	set(param):
		print("trigStashToolData setter called (satellite): ", param)
		if (!animResetStashDone && param):
			stashToolData()
			animResetStashDone = true
	get:
		return false

func _ready():
#	print_debug("_ready\t",Time.get_ticks_msec(),"\t",self.get_path())
	$AnimationPlayer_BodyMorph.current_animation = "Morph"
	$AnimationPlayer_ExoFrames.current_animation = "ExoFramesFlying"

	if ((!Global) || (Engine.is_editor_hint() && Global.cleanTempToolData)):
		# @tool-scripts will generate changes that are saved into .tscn (scene)-files.
		# Clean them when requested
		
		print("Cleaning data generated by @tool, ", self.name)
		$SoundHalo.material_override.set_shader_parameter("soundDataSampler", null)
		return


func _process(_delta):
	if ((!Global) ||(Engine.is_editor_hint() && Global.cleanTempToolData)):
		return
		
	var editorCameraNode = get_node_or_null(editorCameraPath)
	
	if (editorCameraNode && (editorCameraNode is Node3D)):
		$SoundHalo.editorCameraNode = editorCameraNode

	if (Global.lowPassFilteredSoundDataTexture != null) && (!initDone):
		$SoundHalo.material_override.set_shader_parameter("soundDataSampler", Global.lowPassFilteredSoundDataTexture)
		initDone = true

	if (animResetStashDone):
		stashPullToolData()
		animResetStashDone = false

	# Animations seem to loop around if not clamped:
	if ($AnimationPlayer_BodyMorph.current_animation_position != clamp(bodyMorphFraction, 0, 1)):
		$AnimationPlayer_BodyMorph.seek(clamp(bodyMorphFraction, 0, 1))
		
	if ($AnimationPlayer_ExoFrames.current_animation_position != clamp(exoFrameFraction, 0, 1)):
		$AnimationPlayer_ExoFrames.seek(clamp(exoFrameFraction, 0, 1))
	
	if (useCommonAntennaRodAngle):
		if ($Antenna1.antennaRodAngle != commonAntennaRodAngle):
			$Antenna1.antennaRodAngle = commonAntennaRodAngle
			$Antenna2.antennaRodAngle = commonAntennaRodAngle
			$Antenna3.antennaRodAngle = commonAntennaRodAngle
			$Antenna4.antennaRodAngle = commonAntennaRodAngle
	
		if ($Antenna1.baseAngle != antennaBaseAngle):
			$Antenna1.baseAngle = antennaBaseAngle
			$Antenna2.baseAngle = antennaBaseAngle
			$Antenna3.baseAngle = antennaBaseAngle
			$Antenna4.baseAngle = antennaBaseAngle

		if ($Antenna1.localTranslation != commonAntennaBaseLocalTranslation):
			$Antenna1.localTranslation = commonAntennaBaseLocalTranslation
			$Antenna2.localTranslation = commonAntennaBaseLocalTranslation
			$Antenna3.localTranslation = commonAntennaBaseLocalTranslation
			$Antenna4.localTranslation = commonAntennaBaseLocalTranslation

#	$Frame_Lower/DishAntenna/ScopeLight.visible = scopeActive
#	$Frame_Lower/DishAntenna/DbgSignal/BlockableGNSSSignal.visible = scopeActive

#	if (scopeActive && tunePlayer && Global.soundData):
#		var tunePlaybackPosition:float = tunePlayer.getFilteredPlaybackPosition()
	var tunePlaybackPosition:float = Global.masterReplayTime

	if (scopeActive && Global.soundData):
#		$Frame_Lower/DishAntenna/ScopeLight.light_energy = abs((Global.soundData[tunePlaybackPosition * 8000] - 128.0) / 128.0) * scopeLightEnergy
		if (!$Frame_Lower/DishAntenna/ScopeLight.visible):
			$Frame_Lower/DishAntenna/ScopeLight.visible = true
		$Frame_Lower/DishAntenna/ScopeLight.light_energy = Global.lowPassFilteredSoundAmplitudeData[tunePlaybackPosition * 8000] * scopeLightEnergy
	else:
		if ($Frame_Lower/DishAntenna/ScopeLight.visible):
			$Frame_Lower/DishAntenna/ScopeLight.visible = false
			$Frame_Lower/DishAntenna/ScopeLight.light_energy = 0

	$SoundHalo.material_override.set_shader_parameter("soundPos", tunePlaybackPosition * 8000)
	$SoundHalo.material_override.set_shader_parameter("baseAlbedo", haloAlbedo)

	if (useRotationOverride):
		var newBasis = Basis.IDENTITY.rotated(Vector3.UP, deg_to_rad(rotationOverride.y)).rotated(Vector3.RIGHT, deg_to_rad(rotationOverride.x)).rotated(Vector3. BACK, deg_to_rad(rotationOverride.z))
		
		# TODO: This scaling should actually be outside this if, maybe...
		# And then found out that actually satellite doesn't want to be scaled.
		# Scaling causes FPS to drop to 10 (from >100)
		# So just leave it be. Works with World though. What's different here? Lighting?
		if (false):
			var camera:Camera3D = get_viewport().get_camera_3d()
			var distance:float = (global_transform.origin - camera.global_transform.origin).length()
			
		#	var scaling:float = 1.0 - (0.9999 * smoothstep(100, 400, distance))
		#	var scaling:float = 1.0 / (20000.0 - (19999.0 * (1.0 - smoothstep(500, 3500, distance))))
			var scaling:float = 1.0 / (20000.0 - (19999.0 * (1.0 - smoothstep(100, 3900, distance))))
			
			
			self.transform.basis =  newBasis.scaled(Vector3(scaling, scaling, scaling))
		elif (self.transform.basis != newBasis):
			self.transform.basis = newBasis

class StashData:
	var haloSoundDataSampler

var stashStorage:StashData = StashData.new()

func stashToolData():
	var soundHalo = get_node_or_null("SoundHalo")
	
	if (soundHalo):
		print("Stashing tool data (satellite)")
		stashStorage.haloSoundDataSampler = soundHalo.material_override.get_shader_parameter("soundDataSampler")
		soundHalo.material_override.set_shader_parameter("soundDataSampler", null)

func stashPullToolData():
	var soundHalo = get_node_or_null("SoundHalo")
	
	if (soundHalo):
		print("Stash pulling tool data (satellite)")
		soundHalo.material_override.set_shader_parameter("soundDataSampler", stashStorage.haloSoundDataSampler)
