@tool
extends MeshInstance3D

@export var soundLength:float = 4096

var initDone:bool = false

# Called when the node enters the scene tree for the first time.
func _ready():
#	print_debug("_ready\t",Time.get_ticks_msec(),"\t",self.get_path())
	if ((!Global) ||(Engine.is_editor_hint() && Global.cleanTempToolData)):
		# @tool-scripts will generate changes that are saved into .tscn (scene)-files.
		# Clean them when requested
		
		print("Cleaning data generated by @tool, ", self.name)
		material_override.set_shader_parameter("soundDataSampler", null)
		return

# Called every frame. 'delta' is the elapsed time since the previous frame.
func _process(_delta):
	if ((!Global) ||(Engine.is_editor_hint() && Global.cleanTempToolData)):
		return
	
	if (Global.soundDataTexture != null) && (!initDone):
		material_override.set_shader_parameter("soundDataSampler", Global.lowPassFilteredSoundDataTexture)
		initDone = true

#	$Surface.material_override.set_shader_param("soundOffset", soundSampleOffset)
	material_override.set_shader_parameter("soundPos", Global.oscilloscopeSoundMasterPosition - (soundLength / 2))
	material_override.set_shader_parameter("soundLength", soundLength)
#	$Surface.material_override.set_shader_parameter("startOrigin_Object", Vector3($Surface.mesh.size.x / 2, 0, 0) + $Surface.mesh.center_offset)
#	$Surface.material_override.set_shader_parameter("endOrigin_Object", Vector3(-$Surface.mesh.size.x / 2, 0, 0) + $Surface.mesh.center_offset)

class StashData:
	var soundDataSampler

func stashToolData():
	var stashStorage:StashData = StashData.new()
	stashStorage.soundDataSampler = material_override.get_shader_parameter("soundDataSampler")
	material_override.set_shader_parameter("soundDataSampler", null)

	return stashStorage

func stashPullToolData(stashStorage:StashData):
	material_override.set_shader_parameter("soundDataSampler", stashStorage.soundDataSampler)
