@tool
extends Node3D

@export var eventHorizonRadius:float = 0.5
@export var gravity:float = 0.5
@export var radius:float = 0.5
@export var shader:Shader

# Called when the node enters the scene tree for the first time.
func _ready():
#	print_debug("_ready\t",Time.get_ticks_msec(),"\t",self.get_path())
	if ((!Global) || (Engine.is_editor_hint() && Global.cleanTempToolData)):
		# @tool-scripts will generate changes that are saved into .tscn (scene)-files.
		# Clean them when requested
		
		print("Cleaning data generated by @tool, ", self.name)
		$Visibles/DistorterMesh.material_override = null
		return

	$Visibles/DistorterMesh.material_override = ShaderMaterial.new()
	$Visibles/DistorterMesh.material_override.shader = shader

# Called every frame. 'delta' is the elapsed time since the previous frame.
func _process(_delta):
	if ((!Global) || (Engine.is_editor_hint() && Global.cleanTempToolData)):
		return

	$Visibles/DistorterMesh.material_override.set_shader_parameter("eventHorizonRadius", eventHorizonRadius)
	$Visibles/DistorterMesh.material_override.set_shader_parameter("gravity", gravity)

	# This is needed due to unorthodox way to billboard
	# ( see shader )
#	global_transform.basis = Basis(Vector3(randf(), randf(), randf()),
#			Vector3(randf(), randf(), randf()),
#			Vector3(randf(), randf(), randf()))
	$Visibles.global_transform.basis = (Basis.IDENTITY * radius * 2)

	# Scale event horizon sphere
	$Visibles/EventHorizonSphere.basis = Basis.IDENTITY * (eventHorizonRadius)

