#version 430

in float vaporizeTimeInvV;

layout(location = 0) out vec4 frag;
// layout(location = 1) out vec4 frag2;

vec2 rotateXY2(vec2 p, float a) {
  vec2 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

float randCen(vec2 co) {
    return rand(co)-float(0.5);
}

// from pouet raymarching thread by las of mercury
float perlin(vec3 p) {
    vec3 i = floor(p);
    vec4 a = dot(i, vec3(1., 57., 21.)) + vec4(0., 57., 21., 78.);
    vec3 f = cos((p-i)*3.14159265)*(-.5)+.5;
    a = mix(sin(cos(a)*a),sin(cos(1.+a)*(1.+a)), f.x);
    a.xy = mix(a.xz, a.yw, f.y);
    return mix(a.x, a.y, f.z);
}

float turb(vec3 c) {
        float r=0.0;
        float s=0.5;
        c*=1.0;
        for (int i=0;i<3;i++) {
                //if (i<2) continue;
                r+=s*(perlin(c)*1.0+0.0);
                c*=2.0;
                s*=0.75;
        }
        return r;
}

float per2(vec3 p) {
    float r1 = perlin(p);
    vec3 p2 = p;
    p2.z = 0.5-p.z;
    float r2 = perlin(p2);
    return (r1+r2)*0.5;
}

uniform float noiseAspect = 0.0;
uniform float noiseStartAngle = 0.0;
uniform float noiseOctAngle = 0.0;

float turb2(vec3 c) {
        float r=0.0;
        float s=0.50;
        c*=1.0;
        c.xy = rotateXY2(c.xy, noiseStartAngle);
        c.x *= noiseAspect;
        for (int i=0;i<3;i++) {
                //if (i<2) continue;
                c.xy = rotateXY2(c.xy, noiseOctAngle);
                r+=s*(per2(c)*1.0+0.0);
                c*=2.0;
                s*=0.5;
        }
        return r;
}


layout(binding=0) uniform sampler2D tex;
layout(binding=1) uniform sampler2D texPrev;
layout(binding=2) uniform sampler2D texDist;


layout(binding=0, rgba32f) uniform image2D partorPos;
layout(binding=1, rgba32f) uniform image2D partorSUV;
layout(binding=2, rgba32f) uniform image2D partorVel;


uniform float g_windowWidth;
uniform float g_windowHeight;
uniform float g_time;
uniform float g_timeStep;

uniform float effectWidth = 1280.0;
uniform float effectHeight = 720.0;

uniform float approachOrigSize = -14.0;
uniform float approachRandSize = 0.0;
uniform float approachNoiseFreq = 128.0;
uniform float approachNoiseDist = 0.50;
uniform float approachNoiseDistOfs = 1.0;
uniform float approachNoiseAmp = 0.10;
uniform float approachNoiseSpeed = 0.20;
uniform float approachSpeed = 8.0;
uniform float approachLimit = 0.02;

uniform float vaporizeOrigShape = 2.0;
uniform float vaporizeNoiseFreq = 32.0;
uniform float vaporizeNoiseDist = 0.02;
uniform float vaporizeNoiseDistOfs = 2.0;
uniform float vaporizeNoiseAmp = 2.0;
uniform float vaporizeNoiseSpeed = 2.0;
uniform float vaporizeSpeed = 0.20;


uniform float distAttractLim = 0.5;
uniform float distAttractAmount = 1.0;
uniform float distAttractExp = 1.0;

uniform float distAttract2Lim = 0.5;
uniform float distAttract2Amount = 1.0;
uniform float distAttract2Exp = 1.0;

uniform float distParallelLim = 0.5;
uniform float distParallelAmount = 1.0;
uniform float distParallelExp = 1.0;

uniform float distGradWidth = 20.0;

uniform float velocityAmount = 0.0;

uniform float followerSpeed = 0.5;
uniform float followerDist = 0.0;
uniform float followerDistFade = 0.0;


void main() {

    ivec2 tcp = ivec2(gl_FragCoord.xy);
    vec4 pi = imageLoad(partorPos, tcp);

    if (pi.z < 0.01) {
        return; // sim not active for this particle
    }

    vec4 suv = imageLoad(partorSUV, tcp);

    ivec2 followPUV = ivec2(-1,-1);
    vec2 followPos = vec2(0.0, 0.0);
    int isFollower = 0;
    if (suv.z > 0.50) {
      isFollower = 1;
      followPUV = ivec2(suv.z, suv.w);
      followPos = imageLoad(partorPos, followPUV).xy;
      //return;
    }

    vec2 tcs = suv.xy;
    vec2 uvs = tcs;

    vec4 velo = vec4(0.0);

    if (abs(velocityAmount)>0.001) {
        velo = imageLoad(partorVel, tcp);
    }


    vec4 cur = texture2D(tex, tcs);
    vec4 prev = texture2D(texPrev, tcs);

    vec2 pixDiff = distGradWidth*vec2(1.0/g_windowWidth, 1.0/g_windowHeight);

    vec2 ss = pi.xy*0.50+vec2(0.50);

    vec4 dist = texture2D(texDist, ss);

    vec4 grad = vec4(0);

    grad.x = (texture2D(texDist, ss+vec2(pixDiff.x, 0.0))-texture2D(texDist, ss+vec2(-pixDiff.x, 0.0))).x;
    grad.y = (texture2D(texDist, ss+vec2(0.0, pixDiff.y))-texture2D(texDist, ss+vec2(0.0, -pixDiff.y))).x;


    grad.xy *= -1.0;
    // vec4

    vec2 s = uvs*2.0-vec2(1.0);

    vec2 pp = pi.xy;


    //if (cur.r < 0.01 && prev.r > 0.5) {
    //if (cur.r < 0.2 && pi.z <= 1.0 && pi.z >= 0.01) { // SDF1
    //if (cur.r < 0.02 && pi.z <= 1.0 && pi.z >= 0.01) {
    if (cur.r < approachLimit && pi.z <= 1.0 && pi.z >= 0.01) {
        pi.z = 2.0;
    }

    if (pi.z >= 2.0) {
        pi.z += g_timeStep*vaporizeTimeInvV;
        //if (pi.z > 3.0) pi.z = 0.011;
        if (pi.z > 3.0) pi.z = 0.0;
    } else if (pi.z >= 0.01) {
        pi.z += g_timeStep*vaporizeTimeInvV;
        if (pi.z >= cur.r) pi.z = cur.r;
    } else {
        return; // sim not active for this particle
    }
    // pi.z = 0.0;



    vec2 so = s;
    vec2 pd = s-pp;
    float d = 1.0;

    vec2 sd = vec2(1.5, 1.23);

    float fr = 1.0;

    float v = 1.0;

    vec2 noiske = vec2(0.0);

    float amn = 1.0;

    fr = 32.0;
//    grad.xy = vec2(turb(vec3(pp*fr, g_time*approachNoiseSpeed)), turb(vec3(pp*fr+sd, g_time*approachNoiseSpeed)));

    if (pi.z < 2.0) {
        // approaching
        fr = approachNoiseFreq;

        float kallu = 1.0;
        kallu = max(pi.z, 0.0);
        //kallu = min(1.0, max(1.0-dot(pd,pd)*20.0, 0));

        d = approachNoiseAmp*max(1.0-kallu/approachNoiseDist+approachNoiseDistOfs, 0.0); // 1.0*min(max(dot(pd,pd)*2.0-0.10, 0.0), 10.0);

        amn = clamp((1.0-kallu*2.0)*1.0, 0.0, 1.0);

        // noiske = d*vec2(turb(vec3(so*fr, g_time*approachNoiseSpeed)), turb(vec3(so*fr+sd, g_time*approachNoiseSpeed)));
        noiske = d*vec2(turb2(vec3(pp*fr, g_time*approachNoiseSpeed)), turb2(vec3(pp*fr+sd, g_time*approachNoiseSpeed)));
        v = approachSpeed;
    } else if (pi.z >= 2.0) {
        // going away
        s += so*vaporizeOrigShape;
        fr = vaporizeNoiseFreq;
        float kallu = 1.0;
        kallu = max(pi.z-2.0, 0.0);
        d = vaporizeNoiseAmp*min(max(0.0+kallu/vaporizeNoiseDist+vaporizeNoiseDistOfs, 0.0), 10.0);

        amn = clamp(kallu*1.0, 0.0, 1.0);
        //amn = 1.0;
        //d = vaporizeNoiseAmp*min(max(0.0-dot(pd,pd)/vaporizeNoiseDist+vaporizeNoiseDistOfs, 0.0), 10.0);
        noiske = d*vec2(turb2(vec3(pp*fr, g_time*vaporizeNoiseSpeed)), turb2(vec3(pp*fr+sd, g_time*vaporizeNoiseSpeed)));
        v = vaporizeSpeed;
    }

    //s += noiske;
    //pd = s-pp;
    pd = (s-pp)*(1.0-amn)+noiske;


    float limStep = min(0.5, max(0.0, g_timeStep));

    vec2 pc = vec2(0.0);


    pc = min(0.5, max(0.0, g_timeStep*v))*pd;

    float signer = 1.0;

    if (dist.x < 0.0) {
        signer = -1.0;
        dist.x = -dist.x;
    }

    float distAttractFact = pow(dist.x, distAttractExp);
    if (distAttractFact > distAttractLim) {
        distAttractFact = 0.0;
    }
    distAttractFact *= signer;

    float distAttract2Fact = pow(dist.x, distAttract2Exp);
    if (distAttract2Fact > distAttract2Lim) {
        distAttract2Fact = 0.0;
    }
    distAttract2Fact *= signer;


    float distParallelFact = pow(dist.x, distParallelExp)+1.0;
    if (dist.x > distParallelLim) {
        float am = clamp((dist.x-distParallelLim)*10.0, 0.0, 1.0);
        distParallelFact = distParallelFact*(1.0-am)+am*1000.0;
    }
    distParallelFact *= signer;


    pc.xy += (distAttractAmount*distAttractFact + distAttract2Amount*distAttract2Fact)*grad.xy*limStep*100.0;


    vec3 gradz = vec3(grad.xy, 0.0);
    vec3 zet = vec3(0.0, 0.0, 1.0);

    vec3 dors = cross(gradz, zet);

    pc.xy += -dors.xy*limStep*distParallelAmount/(distParallelFact);


    if (isFollower > 0) {
      vec2 fp = (followPos-pp);
      float fd = sqrt(dot(fp,fp))*1000.0;

      if (fd < 1.0) pi.z = 0.01;

      if (fd>(followerDist-followerDistFade)) {
        float kumd = 1.0;
        if (abs(followerDistFade) > 0.001) {
          kumd = clamp((fd-followerDist+followerDistFade)/followerDistFade, 0.0, 1.0);
        }
        pc.xy += (fp)*followerSpeed*kumd;
      } else {
        pc.xy += vec2(0.0);
      }
    }


    if (abs(limStep) > 0.00001) {
        velo.xy += pc.xy/limStep;
    }

    pp.xy += velo.xy*limStep;

    velo *= velocityAmount;

    // pp.xy += -dors.xy*limStep*distParallelAmount*distParallelFact;

  //  pp += min(0.5, max(0.0, g_timeStep*v))*pd*(1.0-amn) + min(0.5, max(0.0, g_timeStep))*noiske*amn;

    vec4 result = vec4(1.0);

    result.xy = pp;

    result.z = pi.z;

    imageStore(partorPos, tcp, result);


    if (abs(velocityAmount)>0.001) {
        imageStore(partorVel, tcp, velo);
    }


    frag = result;
}


