#version 430

// layout (location=0) in vec3 vertexPosition;

layout(binding=0) uniform sampler2D texPartPos;
layout(binding=1) uniform sampler2D texPartCol;
layout(binding=2) uniform sampler2D texPal;
layout(binding=3) uniform sampler2D texPartSUV;

out vec2 posV;
out vec4 colV;
out float fadeV;

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform float g_time;

uniform float effectWidth;
uniform float effectHeight;

uniform float ptw;
uniform float pth;

uniform float approachFade = 10.0;

uniform float paletteFreq = 1.0;
uniform float paletteOfs = 0.0;

uniform float layer = 0.0;

uniform float colorMode = 1.0;

uniform float zoom = 1.0;

void main() {
  vec4 vp = vec4(0.0);

  float id = float(gl_VertexID);
  vp = vec4(0.0, 0.0, 0.0, 1.0);
  float idq = id; // quad index

  vec2 fpt;
  ivec2 pt;
  fpt.y = floor(idq/ptw);
  fpt.x = idq-fpt.y*ptw;

  fpt.y += pth/8.0*layer;

  pt = ivec2(fpt);

  vec4 pp = texelFetch(texPartPos, pt, 0);

  colV.w = 1.0;
  if (pp.z < 0.01) {
    colV.w = 0.0;
    return;
  }


  vec4 suv = texelFetch(texPartSUV, pt, 0);
  vec4 pc = texture2D(texPartCol, suv.xy);

  // vec4 pc = texelFetch(texPartCol, pt, 0);
  //vec4 pp = texture2D(tex, fpt/vec2(effectWidth, effectHeight));

  vp.xy += pp.xy*1.0+0.0*(fpt.xy/effectWidth*2.0-vec2(1.0));

  if (pp.z < 0.01) vp.xy*=0.0;

  float palPos = 0.0;

  float fd = 1.0;
  float brb = 1.0;
  if (pp.z > 2.0) {
    fd = 1.0-min(pp.z-2.0, 1.0);
    palPos = fd;
    fd *= fd;
  } else if (pp.z > 0.0) {
    fd = pp.z;
    palPos = fd;
    fd = min(pp.z*approachFade, 1.0);
    fd *= fd;

    brb = 1.0/clamp(fd+0.05, 0.05, 1.0);
  }

//  vp.xy *= 1.0;

  posV = vp.xy*zoom;

  vec3 pal = texture2D(texPal, vec2(fract(palPos*0.9999*paletteFreq+paletteOfs), 0.0)).rgb;

  //colV = vec4(pal, 1.0)*fd;




  if (colorMode < 0.5) {
    colV = vec4(pal*pc.rgb, 1.0)*brb;
  } else {
    colV = vec4(pal, 1.0)*brb;
  }
  //colV.z = fd;
  fadeV = fd;
  colV.w = 1.0;
  if (pp.z < 0.01) colV.w = 0.0;



}
