#version 430

layout(binding=0) uniform sampler2D tex;
//layout(binding=1) uniform sampler2D texBump;
layout(binding=2) uniform sampler2D texRep;
//layout(binding=3) uniform sampler2D texPrevFrame;
//layout(binding=4) uniform sampler2D texPrevBlurFrame;
//layout(binding=5) uniform sampler2D texPrevNorm;
//layout(binding=6) uniform sampler2D texMul;
layout(binding=7) uniform sampler2D texRep2;
//// layout(binding=7) uniform sampler2D texDepth;

//layout(binding=0, rgba16f) uniform image2D velBuf;

// layout(early_fragment_tests) in;

in vec4 posG;
in vec4 posSG;
in vec4 prevPosG;
in vec4 prevPosSG;
in vec3 normalG;
in vec3 normalWSG;
in vec3 velG;
in vec2 uvG;
in vec3 tangentG;
in vec3 colorG;
in vec4 posW;
// in vec4 posInst;
in vec3 randG;
in vec4 posWM;

layout(location = 0) out vec4 frag; // .rgb

uniform float g_time;
uniform float g_windowWidth = 1280.0;
uniform float g_windowHeight = 720.0;


uniform float g_genUV = 0.0;
uniform float g_uvOfsX = 0.0;
uniform float g_uvOfsY = 0.0;
uniform vec4 g_uvScale = vec4(1.0, 1.0, 1.0, 1.0);
uniform float g_texBrightness = 1.0;


// TEXREPE begins

vec2 rotateXY2(vec2 p, float a) {
  vec2 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

uniform float g_repTex1 = 0.0;
uniform float g_repUVBase1 = 1.0;
uniform float g_repUVOp1 = 0.0;
uniform float g_repUVAmp1 = 0.0;
uniform float g_repUVSca1 = 1.0;
uniform float g_repUVOfsX1 = 0.0;
uniform float g_repUVOfsY1 = 0.0;
uniform float g_repUVRot1 = 0.0;

uniform float g_repTex2 = 0.0;
uniform float g_repUVBase2 = 0.0;
uniform float g_repUVOp2 = 0.0;
uniform float g_repUVAmp2 = 0.0;
uniform float g_repUVSca2 = 1.0;
uniform float g_repUVOfsX2 = 0.0;
uniform float g_repUVOfsY2 = 0.0;
uniform float g_repUVRot2 = 0.0;

uniform float g_repTex3 = 0.0;
uniform float g_repUVBase3 = 0.0;
uniform float g_repUVOp3 = 0.0;
uniform float g_repUVAmp3 = 0.0;
uniform float g_repUVSca3 = 1.0;
uniform float g_repUVOfsX3 = 0.0;
uniform float g_repUVOfsY3 = 0.0;
uniform float g_repUVRot3 = 0.0;

uniform float g_repPow = 1.0;

vec4 texRepe(sampler2D tRep1, sampler2D tRep2, sampler2D tRep3, vec2 uv) {
   vec4 r = vec4(0.0);
   vec2 uvr;
   vec4 rep;

   //     float repLum = dot(vec3(0.299, 0.587, 0.114), rep.rgb);
   //     if (repLum > 0.001) {
   //       r.rgb /= repLum;
   //       repLum = pow(repLum, 1.0);
   //       r.rgb *= repLum;
   //     }

   float hp = 0.5*3.141592;

   if (g_repUVOp1 < 0.5) {
       return vec4(1.0, 1.0, 1.0, 1.0);
   }

   if (g_repUVOp1 > 0.5) {
     uvr = rotateXY2(uv, hp*g_repUVRot1/90.0)+vec2(g_repUVOfsX1, g_repUVOfsY1);
     if (g_repTex1 < 0.5) {
       rep = texture2D(tRep1, uvr*g_repUVSca1);
     } else {
       rep = texture2D(tRep1, uvr*g_repUVSca1);
     }
     if (g_repUVOp1 < 1.5) {
      r.rgb += vec3(g_repUVBase1)+rep.rgb*rep.a*g_repUVAmp1;
     } else {
      r.rgb += (r.rgb+vec3(g_repUVBase1))*rep.rgb*rep.a*g_repUVAmp1;
     }
   }

   if (g_repUVOp2 > 0.5) {
     uvr = rotateXY2(uv, hp*g_repUVRot2/90.0)+vec2(g_repUVOfsX2, g_repUVOfsY2);
     if (g_repTex2 < 0.5) {
       rep = texture2D(tRep1, uvr*g_repUVSca2);
     } else {
       rep = texture2D(tRep2, uvr*g_repUVSca2);
     }
     if (g_repUVOp2 < 1.5) {
      r.rgb += vec3(g_repUVBase2)+rep.rgb*rep.a*g_repUVAmp2;
     } else {
      r.rgb *= vec3(g_repUVBase2)+rep.rgb*rep.a*g_repUVAmp2;
     }
   }
   if (g_repUVOp3 > 0.5) {
     uvr = rotateXY2(uv, hp*g_repUVRot3/90.0)+vec2(g_repUVOfsX3, g_repUVOfsY3);
     if (g_repTex3 < 0.5) {
       rep = texture2D(tRep1, uvr*g_repUVSca3);
     } else {
       rep = texture2D(tRep3, uvr*g_repUVSca3);
     }
     if (g_repUVOp3 < 1.5) {
      r.rgb += vec3(g_repUVBase3)+rep.rgb*rep.a*g_repUVAmp3;
     } else {
      r.rgb *= vec3(g_repUVBase3)+rep.rgb*rep.a*g_repUVAmp3;
     }
   }
   r = clamp(r, 0.0, 10000.0);
   r = pow(r, vec4(g_repPow));

   r.a = 1.0;
   return r;
}
// TEXREPE ends



void main() {


    float br = clamp(sin(uvG.x)+cos(uvG.y), 0.0, 1.0);
    br = 1.0;
    frag.rgb = vec3(br);


    vec2 uv = uvG;
    vec3 tangent = tangentG;
    vec3 color = colorG;

    vec2 myUv;
    if (g_genUV < 0.5) {
      myUv = uv*g_uvScale.xy;
    } else {
        if (g_genUV < 1.5) {
          myUv = posW.xy*g_uvScale.xy;
        } else {
          myUv = posW.xz*g_uvScale.xy;
        }
    }
  //  myUv += randG.yz;
    myUv.y *= -1.0;
    myUv.x += g_uvOfsX;
    myUv.y += g_uvOfsY;

    vec4 diffuse = texRepe(tex, texRep, texRep2, myUv.xy)*g_texBrightness;

    frag.rgb *= diffuse.rgb;

    //frag.rg = myUv.xy;


    frag.a = 0.0;
}

