#version 430

layout (location=0) in vec3 vertexPosition;
//layout (location=1) in vec3 vertexNormal;
//layout (location=2) in vec2 vertexUV;
//layout (location=3) in vec3 vertexTangent;

out vec2 uv;

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform float g_time;

uniform float flip=1.0;
uniform vec4 centerScale = vec4(0.0, 0.0, 1.0, 1.0);

uniform float g_overlayScale = 1.0;

uniform float rot=0.0;

vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}


void main() {
  vec3 vp = (vertexPosition*2.0-1.0*vec3(1.0, 1.0, 1.0));
  gl_Position = vec4(vp, 1.0);
  uv = vertexPosition.xy;
  if (flip > 0.5) {
      uv.y = 1.0-uv.y;
  }

  uv -= vec2(centerScale.xy);
 // uv *= g_overlayScale;
  uv.x *= centerScale.z;
  uv.y *= centerScale.w;
  uv = rotateXY(vec4(uv, 0.0, 0.0), rot).xy;
  uv += vec2(centerScale.xy);
}
