import QtQuick 2.3
import "."
import AdaptDemoSystem 1.0

// handle storing of the previous blurred version of the scene
// for shaders using the ultimate fake GI with g_prevBlurAmount
Group {
    id: effect
    name: "prevblur"
    effectName: "PrevBlur"
    enabled: syncRootOn(effect.name, effectName)

    Blit { textureRT: "depth"; blitRT: 1 }
    Blit { textureRT: "prev" }
    BlurRt {
      name: effect.name;
      effectName: effect.effectName
      textureRT: "prev";
      targetTextureRT: "prevBlur"
    }

    RenderTarget {
        RenderTargetLayer {
            textureRT: "prevNormal"
            format: "RGBA32F"
            width: demo.windowWidth
            height: demo.windowHeight
        }
        Texture {
            textureUnit: 0
            textureRT: "mainDepth"
        }
        Shader {
            file: "fx/_SharedQML/drawRtTexel"
        }
        DrawVB {
            type: "quad"
            depthTest: false
            depthWrite: false
            ShaderParam {
                paramName: "flip"
                paramValue: 1.0
            }
            blendMode: "off"
        }
    }


    BlurRtImpl {
        name: effect.name+".depth"
        effectName: effect.effectName
        textureRT: "prevNormal"
    }

    Texture {
        textureUnit: 0
        textureRT: "prev"
    }
    Shader {
        file: "fx/_SharedQML/drawRt"
    }

    DrawVB {
        type: "quad"
        depthTest: false
        depthWrite: false
        ShaderParam {
            paramName: "flip"
            paramValue: 1.0
        }
        ShaderParam { paramName: "g_overlayScale"; paramValue: 1.0 }
        blendMode: "off"
    }

}

