import QtQuick 2.3
import AdaptDemoSystem 1.0

GroupBase {
  id: effect
  name: "partor4k"
  effectName: "Partor4k"
  property bool enabledIn: true
  enabled: syncRootOn(effect.name, effectName) && enabledIn;

  property PartorImpl impl
  Component {
    id: ec
    PartorImpl {}
  }

  property bool effectExists: false
  onEnabledChanged: {
    if (!enabled && effectExists) {
      effectExists = false;
      impl.destroy(0);
      impl = undefined;
    }
  }
  Connections {
    target: demo
    onFrameRendered: {
      if (effect.enabled && !effectExists) {
        effectExists = true;
        impl = ec.createObject(effect, { name: effect.name } );
      }
    }
  }

}
