import QtQuick 2.3
import AdaptDemoSystem 1.0

Effect {
    id: glow
    name: "glow"
    effectName: "Glow"
    enabled: syncRootOn(name, effectName);

    Blit {
        textureRT: "bg"
        blitRT: 0
    }
    BlurGlow {
        name: glow.name
        effectName: glow.effectName
        shader: "blurGlow"
        targetTextureRT: "bgBlur"
    }
//    Blit {
//        textureRT: "bgBlur"
//        blitRT: 0
//    }
    Shader {
        file: "fx/_SharedQML/glow"
    }
    Texture {
        textureUnit: 0
        textureRT: "bg"
    }
    Texture {
        textureUnit: 1
        textureRT: "bgBlur"
    }
    DrawVB {
        ShaderParam { paramName: "flip"; paramValue: 0.0 }
        ShaderParam { paramName: "overlayAlpha"; paramValue: sync(glow.name+".bright") }
        ShaderParam { paramName: "g_overlayScale"; paramValue: 1.0 }
        ShaderParam { paramName: "g_origAmount"; paramValue:  s("orig", 1.0) }
        type: "quad"
        depthTest: false
        depthWrite: false
        blendMode: "off"
        drawBuffers: 1
    }

}
