import QtQuick 2.3

import AdaptDemoSystem 1.0

Effect {
    id: fx
    name: "circlos"
    effectName: "Circlos"

    Blit { textureRT: "colorBuffer" }
    Texture { textureUnit: 0; textureRT: "colorBuffer" }

    Shader { file: "fx/_SharedQML/circlos" }
    TextureSel { id: ovlTex; textureUnit: 1; name: fx.name; textureWrap: sync(group.name+".texClamp", 1.0) > 0.5 ? "clamp" : "repeat" }

    //    Texture {
    //        enabled: group.textureRT !== ""
    //        textureUnit: 1
    //        textureRT: group.textureRT
    //    }

    DrawVB {
        type: "quad"
        blendMode: "off"
        depthTest: false; depthWrite: false

        drawBuffers: 1
        // drawBufferRT2: "emitBuf"

        ShaderParam { paramName: "segments"; syncName: ns("segments"); syncDefault: 1.0 }
        ShaderParam { paramName: "radius"; syncName: ns("radius"); syncDefault: 1.0 }
        ShaderParam { paramName: "angle"; syncName: ns("angle"); syncDefault: 0.0 }
        ShaderParam { paramName: "angleDelta"; syncName: ns("angle"); syncDelta: true; syncDefault: 0.0 }
        ShaderParam { paramName: "motion"; syncName: ns("motion"); syncDefault: 0.0 }
        ShaderParam { paramName: "bright"; syncName: ns("bright"); syncDefault: 1.0 }
    }
}

