import QtQuick 2.2
import QtQuick.Window 2.2
import Qt.labs.settings 1.0

import AdaptDemoSystem 1.0


Demo {
    id: demo

    property string focusedTrackName: ""
    property real focusedTrackValue: syncRocketRoot(focusedTrackName)
    property real focusedTrackVal: 0.0 // updated by DebugInfoOverDemo

    onFocusedTrackValueChanged: {
        root.rocketFocusedTrackValueChanged(focusedTrackName, focusedTrackValue)
    }

    Rocket {
        id: rocket

        onTrackFocused: {
            console.log("RocketDemo: trackFocused from rocket:"+trackName+","+trackValue)
            // root.rocketTrackFocused(trackName, trackValue);
            focusedTrackName = trackName;
        }
    }

    function getRootRocket() {
        return rocket;
    }

    Item {
      enabled: !root.bReleaseVer
      Settings {
          property alias windowPosX: demo.windowPosX
          property alias windowPosY: demo.windowPosY
      }
    }

    function getSavePointX2D(name) {
        var a = demo.savePointX2D(name);
        var b = rocket.syncUpdate;
        return a;
    }
    function getSavePointY2D(name) {
        var a = demo.savePointY2D(name);
        var b = rocket.syncUpdate;
        return a;
    }
    function getSavePointZ2D(name) {
        var a = demo.savePointZ2D(name);
        var b = rocket.syncUpdate;
        return a;
    }

    function getSavePointX(name) {
        var a = demo.savePointX(name);
        var b = rocket.syncUpdate;
        return a;
    }
    function getSavePointY(name) {
        var a = demo.savePointY(name);
        var b = rocket.syncUpdate;
        return a;
    }
    function getSavePointZ(name) {
        var a = demo.savePointZ(name);
        var b = rocket.syncUpdate;
        return a;
    }

    function getSavePointCX(name) {
        var a = demo.savePointCX(name);
        var b = rocket.syncUpdate;
        return a;
    }
    function getSavePointCY(name) {
        var a = demo.savePointCY(name);
        var b = rocket.syncUpdate;
        return a;
    }
    function getSavePointCZ(name) {
        var a = demo.savePointCZ(name);
        var b = rocket.syncUpdate;
        return a;
    }

    property int g_uid: 0

    function getUniqueId() {
        g_uid++;
        return g_uid;
    }

    // joni check kumpi
    //property bool demoLoadedAndInitReady: true
    property bool demoLoadedAndInitReady: false

    Connections {
        target: root
        onDemoLoaded: {
            demoLoadedAndInitReady = true;
        }
    }

    function getEffectNameFromTrack(trackName) {
      var s = trackName;
      var sa = s.split(".");
      if (sa.length > 1) {
        return sa[1];
      }
      return "";
    }

    function syncRocketRoot(track, defaultValue) {
        if (!demoLoadedAndInitReady) {
            if (track.indexOf(".ON") !== -1) {
                return 1.0;
            } else {
                return 0.0;
            }
        }

        if (fxFromTL("", track)) {
            if (track.indexOf(".ON") !== -1) {
                var efn = getEffectNameFromTrack(track);
                // console.log("EFN getting .ON start & end time for efn:"+efn);
                var stet = demoBlocksTimes[efn];
                if (stet !== undefined) {
                    var st = stet.st;
                    var et = stet.et;
                    if ((rocket.time>=st) && (rocket.time<et)) {
                        return fxV(track);
                    } else {
                        return 0.0;
                    }
                }
                return fxV(track);
            } else {
                return fxV(track);
            }
        }

     //     return 1.0;

        var a = rocket.sync(track);
        var b = rocket.syncUpdate;
        if (defaultValue !== undefined && defaultValue !== "" && a===0.0) {
            var trackKeys = rocket.getTrackNumKeys(track);
            if (trackKeys === 0) {
                rocket.setTrackFirstValue(track, defaultValue);
                return defaultValue;
            } else {
                return a;
            }
        }
        return a;
    }

    function syncTriggerRocketRoot(track) {
        if (!demoLoadedAndInitReady) {
            return 1.0;
        }

        var a = rocket.syncTrigger(track);
        var b = rocket.syncUpdate;
        //  console.log("syncRocketRoot, track:"+track+" value:"+a)
        return a;
        //  return 0.0;
    }


    function modValue(propertyName, propertyValue) {
        demo.modifySkeneValue(editorLoader.sceneName, propertyName, "", propertyValue);
    }

    function demoTime() {
        return rocket.time;
    }
    function time() {
        return rocket.time;
    }

    function markUpdateFrequent() {
        rocket.markUpdateFrequent();
    }

    Component.onCompleted: {
        demo.reloadDemo();
    }
}

