ORG 256
 DW 127                 ; constant 127 -> amplitude for sinus table
 DW 3C00H               ; constant 1/128 -> calculating PI/128 for sinus table

 MOV AL,13H
.1:
 INT 10H
 IMUL DX,BX,88
 IMUL CX,BX,64
 IMUL AX,BX,80
 MOV CL,AH
 ADD DH,24+1
 ADD CX,29*256+2
 INC BL                 ; DH/CH/CL->R/G/B
 MOV AX,1010H           ; set only one color by the VGA BIOS
 JNZ .1

 MOV BH,63
.2:
 FLDPI                  ; PI
 FMUL DWORD [SI]        ; PI/128
 FIMUL WORD [DI]        ; counter*PI/128
 FSIN                   ; SIN(counter*PI/128)
 FIMUL WORD [SI]        ; 127*SIN(counter*PI/128)
 FISTP WORD [BX+SI]     ; -
 INC BX
 DEC BYTE [DI]          ; loop 256x
 JNZ .2                 ; BX = sinus LUT

 MOV BL,144
nextframe:
 PUSH WORD 0A000H
 POP ES
 MOV DI,320*12
 HLT
 CALL bars
nextpixel:
 PUSH DI
 MOV AX,0CCCDH
 MUL DI
 SUB DL,128
 SUB DH,100
 PUSH DX

 MOV CH,8

nextstar:
 PUSH BX
 PUSH CX
 MOV AL,CL
 MUL AL
 MOV CH,0
 MOV CL,AH
 PUSH CX
 MOV SI,SP

 MOV AL,BYTE [BX]
 CBW
 IMUL CX
 ADD BL,BH
 PUSH AX
 MOV AL,BYTE [BX]
 CBW
 IMUL CX
 POP CX
 MOV CL,AH

 MOV DX,[SI+6]
 SUB DL,CL
 JO skipstar
 SUB DH,CH
 JO skipstar

 IMUL BP,[SI],6
 MOV CL,112
nextpoly:
 MOV BL,[SI+2]
 MOV AL,[BX]
 IMUL CL
 SAR AX,5
 ADD AL,51
 MOV BL,AL

 MOV CH,5
nextedge:
 MOV AL,[BX]
 IMUL DL
 ADD BL,BH
 XCHG DI,AX
 MOV AL,[BX]
 IMUL DH
 ADD AX,DI
 SUB BL,64+51
 CMP AX,BP
 JG skippoly
 DEC CH
 JNZ nextedge
 XCHG AX,CX
 POP CX
 POP CX
 POP BX
 JMP setpixel

skippoly:
 ADD BP,[SI]
 ADD BP,[SI]
 ADD BP,[SI]
 SUB CL,14
 JNZ nextpoly

skipstar:
 POP CX
 POP CX
 POP BX
 ADD CL,32;BH
 ADD BL,BH
 DEC CH
 JNZ nextstar
; MOV AL,[SI+6]
; IMUL AL
; XCHG DI,AX
; MOV AL,[SI+7]
; IMUL AL
; ADD AX,DI
; SHR AX,10
; SUB AL,225
; NEG AL
 MOV AL,1
setpixel:
 POP DI
 POP DI
 STOSB
 CMP DI,64000-320*12
 JNE nextpixel

 CALL bars
 PUSHA
 MOV AX,1300H
 MOV BX,199;20
 MOV CX,6
 MOV DX,1821H
 PUSH CS
 POP ES
 MOV BP,text
 INT 10H
 POPA

 INC CX
 IN AL,60H
 CMP AL,1
 JNZ nextframe

bars:
 PUSH CX
 MOV CX,320
 MOV AL,200
 REP STOSB
 POP CX
RETN

text:
 DB 'Peace!'
