;'Deliriometry' by Kuemmel
; a 256 Byte entry for FreeDOS for Revision 2022
 
org 100h
use16

WIDTH=640
HEIGHT=480

;---init stuff
fninit
push 0a000h
pop es
mov si,data_start-2
;---init screen mode 640x480 TrueColour
mov bx,112h
mov ax,4f02h
int 10h

;---main intro loop
main_loop:
  ;---inc and scale timer
  fild	word[si+16] ;get timer
  fmul dword[si+ 4] ;timer * factor
  inc	word[si+16] ;save timer

  ;---zoom variation over time precalc
  fld st0
  fimul word[si+12] ;ti*8                  ti
  fsin              ;SIN(ti*8)             ti
  fmul dword[si+2]  ;0.4*SIN(ti*8)         ti
  fadd dword[si]    ;0.8+0.4*SIN(ti*8)     ti
  fmul dword[si+12] ;f*(0.8+0.4*SIN(ti*8)) ti
  fstp dword[si+32] ;ti

  ;---2d roto matrix constants precalc
  fsincos           ;cs=COS(ti*8)          si=SIN(ti*8)
  fld dword[si+8]   ;1.15                  cs=COS(ti*8)      si=SIN(ti*8)
  fmul	st2,st0     ;1.15                  cs=COS(ti*8)      1.15*si=SIN(ti*8)
  fmulp st1,st0     ;cs=1.15*COS(ti*8)     si=1.15*SIN(ti*8)

  cwd               ;clear dx as ax is positive here always
  xor di,di         ;init screen start pixel
  mov cx,-(HEIGHT/2)
  y_loop:
    mov  ax,-(WIDTH/2)
    x_loop:
      push cx
      push ax
      fldz                ;c=0
      mov  word[bp+si],cx
      fild word[bp+si]    ;y           c
      fmul dword[si+32]   ;y*f         c       cs  si
      mov  word[bp+si],ax
      fild word[bp+si]    ;x           c       cs  si
      fmul dword[si+32]   ;px=x*f      py=y*f  c   cs  si
      test di,di 
      jnz skip_bank_switch
        mov ax,4f05h
        int 10h           ;needs bx to be zero
        inc dx
      skip_bank_switch:
      call calc_pixel
      stosd               ;plot RGB pixel
      pop ax
      pop cx
      inc ax
    cmp ax,WIDTH/2
    jl x_loop
  inc cx
  cmp cx,HEIGHT/2
jne y_loop

fcompp       ;empty stack
xchg ax,cx   ;clear ah for exit as ch=0 here

;---vsync for timing
mov dx,03dah
vsync:
  in al,dx
  test al,8
jz vsync

;---check keyboard and exit to screenmode if so
in al,0x60
dec ax
jnz main_loop
mov al,3
int 10h   ;textmode...skip if 4 Bytes needed

;---subroutine for near jmp optimization, saves 3 Bytes, no speed impact
calc_pixel:
                      ;st0             st1         st2   st3 st4 st5 st6 st7
    ;---calculate distance to center
    fld  st0          ;px              px          py    c   cs  si
    fmul st0,st0      ;px*px           px          py    c   cs  si
    fld  st2          ;py              px*px       px    py  c   cs  si
    fmul st0,st0      ;py*py           px*px       px    py  c   cs  si
    faddp st1,st0     ;px*px+py*py     px          py    c   cs  si
    fsqrt             ;le=length       px          py    c   cs  si

    ;---adjust inside and outside colour gradient
    fldl2t            ;3.32
    fmulp st1,st0     ;3.32*le
    fld1              ;1               le*f1       px    py  c   cs  si
    fdiv   st0,st1    ;1/le	           le          px    py  c   cs  si
    fcomi  st0,st1    ;1/le	           le          px    py  c   cs  si
    fcmovb st0,st1    ;l/le	           le or 1/le  px    py  c   cs  si
    fstp   st1	      ;le or 1/le      px          py    c   cs  si
    fmul dword[si+ 6] ;le*ff           px          py    c   cs  si
    fstp dword[bp+si] ;px              py          c     cs  si

    mov bx,14         ;iterations...bx to clear bx for screen bank
      iterate:
      fld   st0       ;px              px=nx       py=ny c   cs  si
      fmul  st0,st5   ;px*cs           px          py    c   cs  si
      fld   st2       ;py              px*cs       px    py  c   cs  si
      fmul  st0,st5   ;py*si           px*cs       px    py  c   cs  si
      fsubp st1,st0   ;nx=px*cx-py*si  px          py    c   cs  si
      fld   st1       ;px              nx          px    py  c   cs  si
      fmul  st0,st5   ;px*si           nx          px    py  c   cs  si
      fld   st3       ;py              px*si       nx    px  py  c   cs  si
      fmul  st0,st7   ;py*cs           px*si       nx    px  py  c   cs  si
      faddp st1,st0   ;ny=px*si+py*cs  nx          px    py  c   cs  si
      fstp  st3       ;nx              px          ny    c   cs  si
      fst   st1       ;nx              nx          ny    c   cs  si
      fmul  st0,st2   ;nx*ny           nx          ny    c   cs  si
      fabs            ;abs(nx*ny)      nx          ny    c   cs  si
      fsub dword[si]  ;d=abs(nx*ny)-t  nx          ny    c   cs  si
      fabs            ;abs(d)          nx          ny    c   cs  si
      fld1            ;1.0             abs(d)      nx    ny  c   cs  si
      fdivrp st1,st0  ;1.0/abs(d)      nx          ny    c   cs  si
      faddp  st3,st0  ;nx              ny          c+... cs  si
      dec bx
    jnz iterate

    fcompp            ;c               cs          si
    fmul  dword[bp+si];c*le*f          cs          si
    fistp dword[bp+si];cs              si

    mov bl,3
    mov ecx,dword[bp+si]
    rgb_loop:
      shl eax,8
      cmp ecx,255     ;ouch...
      mov al,cl
      jbe skip_clamp
        mov al,255
      skip_clamp:
      shr ecx,1
      dec bx
    jnz rgb_loop   ;0RGB = clamp(c,255) | clamp((c>>1),255) | clamp((c>>2),255)
    ;not eax       ;switch to dark cold blue-ish style
ret

data_start:  ; si = data_start-2
dw 0x3f4d    ; [si   ] float 0.8=0x3f4d 0.7=0x3f33 0.6=0x3f1a zoom range offset
dw 0x3ecd    ; [si+ 2] float 0.5=0x3f00 0.4=0x3ecd 0.3=0x3e99 zoom range range
dw 0x3af7    ; [si+ 4] float 0.00189=0x3af7 timer factor, lower is slower
dw 0x4090    ; [si+ 6] float 4.5=0x4090     brightness, higher is brighter 
dw 0x3f93    ; [si+ 8] float 1.15=0x3f93    shape shift for each iteration
dw 8         ; [si+12] int   8              twist vs zoom speed, higher is faster twist
dw 0x3ba4    ; [si+12] float 0.005=0x3ba4   global zoom factor
dw 0         ; [si+16] timer init to have a clear start
