#include "longnight.hpp"
#include <math.h>
#include <turbojpeg.h>

using namespace cg_engine;

Startrail::Startrail()
{
	int i;
	char path[30];
	unsigned char *imagedata;
	tjhandle jpegh;
        FILE *jpgfile;
        unsigned long filesize;
        unsigned char *rawjpg;
        int subsample;
	int width;
	int height;

	start = 0;
	end   = 92;

	fssprite = new Sprite();

	glGenTextures(1, &tex);
	glActiveTexture(GL_TEXTURE0);
	glBindTexture(GL_TEXTURE_2D_ARRAY, tex);
	glTexStorage3D(GL_TEXTURE_2D_ARRAY, 1, GL_RGBA8, 1728, 1152, 116);
	for(i = 0; i < 116; i++){
		sprintf(path, "data/textures/IMG_%d.JPG", 9350 + i);
	        jpgfile = fopen(path, "rb");
	        fseek(jpgfile, 0L, SEEK_END);
        	filesize = ftell(jpgfile);
	        fseek(jpgfile, 0L, SEEK_SET);
        	rawjpg = (unsigned char*)malloc(filesize);
	        fread(rawjpg, filesize, 1, jpgfile);
        	fclose(jpgfile);

	        jpegh = tjInitDecompress();
        	tjDecompressHeader2(jpegh, rawjpg, filesize, &width, &height, &subsample);
	        imagedata = (unsigned char*)malloc(width * height * 3);
        	tjDecompress2(jpegh, rawjpg, filesize, imagedata, width, 0, height, TJPF_RGB, TJFLAG_BOTTOMUP);
	        tjDestroy(jpegh);
        	free(rawjpg);

		glTexSubImage3D(GL_TEXTURE_2D_ARRAY, 0, 0, 0, i, 1728, 1152, 1, GL_RGB, GL_UNSIGNED_BYTE, imagedata);
		free(imagedata);
	}

	glActiveTexture(GL_TEXTURE1);
	logo = new Texture("data/textures/longnight.jpg", JPEGType);

	glActiveTexture(GL_TEXTURE2);
	preface = new Texture("data/textures/preface.jpg", JPEGType);

	ubershader = new ShaderProgram();
	ubershader->addShader("data/shaders/ubershader.vs", GL_VERTEX_SHADER);
	ubershader->addShader("data/shaders/ubershader.fs", GL_FRAGMENT_SHADER);

	ubershader->compile();
}

void Startrail::show(double time)
{
	float fade = 0.0;
	int starti;
	int stopi;
	int skipi = 1;
	int limi = 1;
	float ofx = 0.0;
	float ofy = 0.0;
	float zoom = 1.0;
	float showlogo = 0.0;
	float showpreface = 0.0;

	if(time < 2.30){
		fade = 1.0;
	}
	else if(time > 2.30 && time < 10.90){
		fade = (cos((time - 2.3)/1.365) + 1.0) / 2.0;
		starti = (int)round((time - 2.3) * 10.0) % 116;
		stopi  = starti + 1;
	}
	else if(time > 10.90 && time < 16.40){
		showpreface = 1.0;
	}
	else if(time > 16.40 && time < 24.25){
		fade = (cos((time - 16.40)/1.365) + 1.0) / 2.0;
		starti = (int)round((time - 16.40) * 10.0) % 116;
		stopi  = starti + 1;
	}
	else if(time > 24.25 && time < 25.0){
		showlogo = 1.0;
	}
	else if(time > 25.0 && time < 30.7){
		float percentage = (time - 25.0) / (30.7 - 25.0);
		showlogo = 1.0 - percentage;
		ofx  = drand48() / 20.0 * percentage * -1.0;
		ofy  = drand48() / 20.0 * percentage * -1.0;
		zoom = 1.0 + (1.0 / 10.0);
	}
	else if(time > 30.7 && time < 44.2){
		float beat = (time - 30.8734) / 0.8933;
		float resid = beat - round(beat);
		resid  = sqrt(resid * resid);
		starti = (time - 30.7 + resid) * 5.0;
		stopi = starti + 10;
	}
	else if(time > 44.2 && time < 44.95) {
		// rewind
		starti = 67 - (int)round((time - 44.2) * 88.0) % 116;
		stopi  = starti + 10;
	}
	else if(time > 44.95 && time < 58.414){
		float beat = (time - 45.7602) / 0.8891;
		float resid = beat - round(beat);
		resid = sqrt(resid * resid);
		starti = (time - 44.95 + resid) * 5.0;
		stopi = starti + 20;
		limi  = 10;
		skipi = 5;
	}
	else if(time > 58.414 && time < 59.389){
		// rewind 2
		starti = 66 - (int)round((time - 58.414) * 83.0) % 116;
		stopi = 86;
	}
	else if(time > 59.389 && time < 72.673){
		starti = 0;
		stopi  = 86;
		float beat = (time - 58.654) / 0.8883;
		limi = 7 + beat;
		skipi = 5;
	}
	else if(time > 72.673 && time < 73.682){
		// rewind 3
		starti = 0;
		stopi = 86.0 - (time - 72.673) * 149.8257;
		stopi = stopi < 0 ? 0 : stopi;
		limi = 23;
		skipi = 5;
	}
	else if(time > 73.682 && time < 87.107){
		starti = (sin(time - 73.682) + 1.0) * 40.0;
		stopi = starti + (sin(time - 72.0) + 1.0) * 15.0;
	}
	else if(time > 87.107 && time < 90.0){
		starti = 0;
		stopi = (int)round(((time - 87.107) / (88.197 - 87.107)) * 116.0);
		stopi = stopi < 116 ? stopi : 116;
	}
	else if(time > 90.0 && time < 91.5){
		starti = 0;
		stopi = 116;
		fade = (time - 90.0) / (91.5 - 90.0);
	}
	else {
		fade = 1.0;
	}

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	ubershader->use();
	ubershader->setParam("starti", starti);
	ubershader->setParam("stopi", stopi);
	ubershader->setParam("fade", fade);
	ubershader->setParam("blendp", (float)1.0);
	ubershader->setParam("offset", ofx, ofy);
	ubershader->setParam("zoom", zoom);
	ubershader->setParam("skipi", skipi);
	ubershader->setParam("limi", limi);
	ubershader->setParam("showlogo", showlogo);
	ubershader->setParam("showpreface", showpreface);

	glActiveTexture(GL_TEXTURE0);
	glBindTexture(GL_TEXTURE_2D_ARRAY, tex);
	GLint loc = glGetUniformLocation(ubershader->getProgramID(), "stars");
	glUniform1i(loc, 0);

	glActiveTexture(GL_TEXTURE1);
	glBindTexture(GL_TEXTURE_2D, logo->getTexID());
	loc = glGetUniformLocation(ubershader->getProgramID(), "logo");
	glUniform1i(loc, 1);

	glActiveTexture(GL_TEXTURE2);
	glBindTexture(GL_TEXTURE_2D, preface->getTexID());
	loc = glGetUniformLocation(ubershader->getProgramID(), "preface");
	glUniform1i(loc, 2);

	fssprite->draw();
}

MyDemo::MyDemo(int w, int h): Demo(w, h){
	glClearColor(0.0, 0.0, 0.0, 0.0);
	glEnable(GL_DEPTH_TEST);
	glEnable(GL_PROGRAM_POINT_SIZE);
}

void MyDemo::init(){
	scenes.push_back(new Startrail());
}

