#pragma once
#include <GL/glew.h>
namespace cg_engine {

	enum ImgType {JPEGType, PNGType, TGAType};

	class Texture
	{
	private:
		GLuint texid = 0;
		int width;
		int height;
	public:
		Texture(const char *filename, ImgType imgtype);
		~Texture();
		GLuint getTexID();
		void loadTGA(const char *filename, GLuint texid);
		void loadJPEG(const char *filename, GLuint texid);
		void loadPNG(const char *filename, GLuint texid);
		int getWidth();
		int getHeight();
	};

}

