#pragma once

#include <GL/glew.h>
#include "Shader.hpp"
#include "Texture.hpp"
#include "Matrix.hpp"

namespace cg_engine
{
	class ShaderProgram
	{
	public:
		ShaderProgram();
		~ShaderProgram();
		void compile();
		void addShader(const char *filename, GLenum shadertype);
		void addTexture(const char *varname, Texture *texture);
		void addTexture(const char *varname, GLuint texnum);
		void use();
		void setParam(const char *varname, int value);
		void setParam(const char *varname, Matrix value);
		void setParam(const char *varname, float value);
		void setParam(const char *varname, float v1, float v2);
		GLuint getProgramID();
	private:
		GLuint programid;
		int texturecount;
	};
}

