#include "RenderBuffer.hpp"
#include "Matrix.hpp"

using namespace cg_engine;

RenderBuffer::RenderBuffer(int w, int h, int sy, int texnum)
{
	isError    = false;
	maxtexture = texnum;
	width      = w;
	height     = h;
	starty     = sy;

	glGenFramebuffers(1, &framebuffer);
	glBindFramebuffer(GL_FRAMEBUFFER, framebuffer);

	glGenTextures(maxtexture, renderTexture);
	GLenum *drawBuffer = (GLenum*)malloc(sizeof(GLenum) * maxtexture);
	for (int i = 0; i < maxtexture; i++) {
		glBindTexture(GL_TEXTURE_2D, renderTexture[i]);
		glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, width, height, 0, GL_RGBA, GL_UNSIGNED_BYTE, 0);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);

		glFramebufferTexture(GL_FRAMEBUFFER, GL_COLOR_ATTACHMENT0 + i, renderTexture[i], 0);
		drawBuffer[i] = GL_COLOR_ATTACHMENT0 + i;
	}

	glDrawBuffers(maxtexture, drawBuffer);
	if (glCheckFramebufferStatus(GL_FRAMEBUFFER) != GL_FRAMEBUFFER_COMPLETE) {
		isError = true;
		//printf("Render to texture initialization failed\n");
	}
	glBindFramebuffer(GL_FRAMEBUFFER, 0);
	free(drawBuffer);

	outsprite = new Sprite();
	vao = outsprite->getVAO();
}


RenderBuffer::~RenderBuffer()
{
	glDeleteTextures(maxtexture, renderTexture);
	glDeleteFramebuffers(1, &framebuffer);
}

GLuint RenderBuffer::getFramebuffer() {
	return framebuffer;
}

GLuint RenderBuffer::getRenderTexture(int index) {
	if (index >= maxtexture) {
		return 0;
	}
	return renderTexture[index];
}

bool RenderBuffer::getError() {
	return isError;
}

void RenderBuffer::firstPass() {
	glBindFramebuffer(GL_FRAMEBUFFER, framebuffer);

	glClear(GL_COLOR_BUFFER_BIT);
	glViewport(0, 0, width, height);
}

void RenderBuffer::addShader(ShaderProgram *prg) {
	postprocessing = prg;
}

void RenderBuffer::secondPass()
{
	glBindFramebuffer(GL_FRAMEBUFFER, 0);
	glClear(GL_COLOR_BUFFER_BIT);
	glViewport(0, starty, width, height);
	glUseProgram(postprocessing->getProgramID());

	Matrix pm;
	pm.perspective(35.0, 1920.0 / 1080.0, 0.1, 1500);
	postprocessing->setParam("pmatrix", pm);

	for(int i = 0; i < maxtexture; i++){
		glActiveTexture(GL_TEXTURE0 + i);
		glBindTexture(GL_TEXTURE_2D, renderTexture[i]);
		postprocessing->setParam("color", i);
	}

	postprocessing->setParam("height", height);
	postprocessing->setParam("fadeperc", fade);
	postprocessing->setParam("kernelsize", kernelsize);
	postprocessing->setParam("vignette", vignette);
	postprocessing->setParam("avg", avg);
	postprocessing->setParam("zoom", zoom);

	glBindVertexArray(vao);
	glDrawArrays(GL_TRIANGLE_FAN, 0, 4);
}

void RenderBuffer::setFade(float f) {
	fade = f;
}

void RenderBuffer::setKernelSize(int ks) {
	kernelsize = ks;
}

void RenderBuffer::setVignette(float v) {
	vignette = v;
}

void RenderBuffer::setAvg(int s) {
	avg = s;
}

void RenderBuffer::setZoom(float z) {
	zoom = z;
}
