#include "MeshIndex.hpp"
#include <cstring>
#include <string>
#include <cstdlib>

using namespace cg_engine;

char *MeshIndex::strsep(char **input, char *delim)
{
    char *psz_string = *input;
    if( !psz_string )
        return NULL;

    char *p = strpbrk( psz_string, delim );
    if( !p )
    {
        *input = NULL;
        return psz_string;
    }
    *p++ = '\0';

    *input = p;
    return psz_string;
}

MeshIndex::MeshIndex(char *line)
{
	char *d, *block, *v;
	strtok_r(line, " \n", &d);

	for(int i = 0; i < 3; i++){
		block = strtok_r(NULL, " \n", &d);

		if( (v = strsep(&block, (char*)"/")) != NULL){
			vertex[i] = atoi(v);
		}
		else{
			vertex[i] = atoi(block);
		}

		if( (v = strsep(&block, (char*)"/")) != NULL){
			texture[i] = atoi(v);
		}

		if( (v = strsep(&block, (char*)"/")) != NULL){
			normal[i] = atoi(v);
		}
	}
}

MeshIndex::~MeshIndex(void)
{
}

int MeshIndex::getVertex(int i)
{
	return vertex[i] - 1;
}

int MeshIndex::getNormal(int i)
{
	return normal[i] - 1;
}

int MeshIndex::getText(int i)
{
	return texture[i] - 1;
}
