#version 450

layout (location=0) out vec4 FragColor;

uniform sampler2DArray stars;
uniform int starti;
uniform int stopi;
uniform int limi;
uniform int skipi;
uniform float fade;
uniform float blendp;
uniform float zoom;
uniform vec2 offset;
uniform sampler2D logo;
uniform float showlogo;
uniform sampler2D preface;
uniform float showpreface;

in vec2 texcoord;

void main() {
   int i;
   vec4 first, blending;
   vec4 black = vec4(0.0, 0.0, 0.0, 1.0);

   first = texture(stars, vec3(texcoord / zoom + offset, starti));
   blending = first;
   for(i = starti+1; i < stopi; i++){
      if( i % limi < skipi) {
         blending = max(blending, texture(stars, vec3(texcoord / zoom + offset, i))); //lighten blending mode
      }
   }
   blending = clamp(blending, 0.0, 1.0);
   vec4 pic = mix(first, blending, blendp);
   vec4 pic2 = mix(pic, texture(logo, texcoord), showlogo);
   vec4 pic3 = mix(pic2, texture(preface, texcoord), showpreface);

   FragColor = mix(pic3, black, fade);
}
