anthem_drops={}
bowls = {}
end_starts = 30
frame_width2 = 0.13

anthem_length = 128
anthem_ticks = {}
for i,note in pairs(lead_rhythm) do
  for j=1,(note-1) do table.insert(anthem_ticks, false) end
  table.insert(anthem_ticks, true)
end
table.remove(anthem_ticks)

function scene_rain_anthem_init()
  cls(0.01,0.01,0.1,1)
  setframe(0.5-frame_width2,0,0.5+frame_width2,1)
  setflatcolour(colour_bg[1]/355,colour_bg[2]/355,colour_bg[3]/355,0)
  rainpos = 0
  bucket = 1
  for i,tick in pairs(anthem_ticks) do
      if tick then 
        anthem_drops[i]= {model = model("raindrop.stl"), bucket=bucket, active=false}
        model_colour(anthem_drops[i]["model"], colour_raindrop_1[1]/255, colour_raindrop_1[2]/255, colour_raindrop_1[3]/255, 1)
      bucket = (bucket % 4) + 1
      end
  end
  bowls[1] = {
      model = model("bowl.stl"),
      water = model("water.stl"),
      x=0.05, z=-12.5
  }
  bowls[2] = {
      model = model("bowl.stl"),
      water = model("water.stl"),
      x=1, z=-14
  }
  bowls[3] = {
      model = model("bowl.stl"),
      water = model("water.stl"),
      x=1, z=-9
  }
  bowls[4] = {
      model = model("bowl.stl"),
      water = model("water.stl"),
      x=-1.5, z=-12
  }
  for i,bowl in pairs(bowls) do 
    model_colour(bowl["water"], 0.01, 0.01, 0.1, 1)
   end
end

function ra_rot(m)
  rotate(m,1,0,0,0.4)
  translate(m,0,-44,0)
  scale(m,8,8,8)
end

function scene_rain_anthem_frame(time_beats)
  if time_beats > end_starts+4 then
    setframe(0.5-frame_width2, 0 + ((time_beats-end_starts-4)/4),0.5+frame_width2,1)
  elseif time_beats > end_starts then
    frame_width2 = frame_width2*0.99
    setframe(0.5-frame_width2, 0,0.5+frame_width2,1)
  end
  if time_beats > 40 then exit() end

  time_ticks = time_beats * 4
    for y = 1,#anthem_ticks do
      drop = anthem_drops[y]
      if drop then
        ra_rot(drop["model"])
        translate(drop["model"],bowls[drop["bucket"]]["x"], (time_ticks - anthem_length < 0) and (y-time_ticks-1)%anthem_length -1 or -100,bowls[drop["bucket"]]["z"])
        outside_beat = ((y-time_ticks) % anthem_length)//1 >1
        if outside_beat and drop["active"] then
          model_colour(drop["model"], colour_raindrop_1[1]/255, colour_raindrop_1[2]/255, colour_raindrop_1[3]/255, 1)
          model_colour(bowls[drop["bucket"]]["water"],0.01,0.01,0.1,1)
          drop["active"] = false
        elseif (not outside_beat) or drop["active"] then
          drop["active"]=true
          myticks = time_ticks % anthem_length - y
          amt1 = myticks/4 - myticks/4//1
          amt2 = 1 - amt1
          model_colour(bowls[drop["bucket"]]["water"],
              colour_raindrop_2[1]/255*amt2 + 0.01*amt1, 
              colour_raindrop_2[2]/255*amt2 + 0.01*amt1, 
              colour_raindrop_2[3]/255*amt2 + 0.1*amt1, 1)
          model_colour(drop["model"], colour_raindrop_2[1]/255, colour_raindrop_2[2]/255, colour_raindrop_2[3]/255, 1)
        end
      end
    end
    for i, bowl in pairs(bowls) do
      ra_rot(bowl["model"])
      ra_rot(bowl["water"])
      translate(bowl["model"], bowl["x"], -1, bowl["z"])
      translate(bowl["water"], bowl["x"], -1, bowl["z"])
      scale(bowl["model"],2,2,2)
      scale(bowl["water"],2,2,2)
    end
 end

 function scene_rain_anthem_finish()
   for x = 1, tracks_count do
    for y = 1,rainheight do
      drop = anthem_drops[x][y]
      if drop then
        setvisible(drop["model"], false)
      end
    end
  end
 end
