colour_bg = {34, 155, 164}
colour_raindrop_1 = {72, 187, 187}
colour_raindrop_2 = {255,255,255}

drops={}
rainheight = 16
tracks_count = 4

kicks = {true,false,false,true, false,false,true,false, true,false,false,true, false,false,false,true}
shakers = {false,true,true,false, false,true,false,false, false,true,true,false, false,true,true,false}
hats = {false,false,false,false, true,false,false,false, false,false,false,false, true,false,false,false}
coos = {false,false,false,false, false,false,false,true, false,false,false,false, false,false,false,false}

sequence = {kicks, shakers, hats, coos}

function scene_rain_init()
  cls(colour_bg[1]/355, colour_bg[2]/355, colour_bg[3]/455,1)

  for i,track in pairs(sequence) do
    drops[i] = {}
    for y = 1,rainheight do 
      if track[y] then 
        drops[i][y]= {model = model("raindrop.stl"), x=40*(math.random()-0.5)/i, active = 0}
        if i ~= 4 then
          model_colour(drops[i][y]["model"], colour_raindrop_1[1]/255, colour_raindrop_1[2]/255, colour_raindrop_1[3]/255, 1)
        else
          model_colour(drops[i][y]["model"], colour_raindrop_2[1]/255, colour_raindrop_2[2]/255, colour_raindrop_2[3]/255, 1)
        end
      end
    end
  end
end

function scene_rain_frame(time_beats)
  progress = math.min(0.9,time_beats/16);
  frameheight = math.min(0.24,math.max(0.05,(time_beats-16)/16))
  setframe(0.1,0.5-frameheight,progress,0.5+frameheight)
  setflatcolour(0.01,0.01,0.1,math.min(math.max(0,time_beats/2-14),1))
  for x = 1, tracks_count do
    for y = 1,rainheight do
      drop = drops[x][y]
      if 7*16 +4 - time_beats*4 < y and drop then
        setvisible(drop["model"], false)
        drop = nil 
      end
      if drop then
        translate(drop["model"],drop["x"]+3,(y-time_beats*4+6)%rainheight -5,-12+x^2/2)
        thisbeat = ((y-time_beats*4) % 16)//1
        if thisbeat <= 1 and not drop["active"] then
          model_colour(drop["model"], colour_raindrop_2[1]/255, colour_raindrop_2[2]/255, colour_raindrop_2[3]/255, 1)
          drop["active"] = true
        elseif thisbeat > 1 and drop["active"] then
          model_colour(drop["model"], colour_raindrop_1[1]/255, colour_raindrop_1[2]/255, colour_raindrop_1[3]/255, 1)
          drop["active"] = false
        end
      end
    end
  end
 end

 function scene_rain_finish()
   for x = 1, tracks_count do
    for y = 1,rainheight do
      drop = drops[x][y]
      if drop then
        setvisible(drop["model"], false)
      end
    end
  end
 end
