#version 460 core
layout (location = 0) in vec4 vertex; // <vec2 pos, vec2 tex>
out vec2 TexCoords;
out vec4 first;
uniform mat4 projection;
uniform float time;
float pi = 3.1415926535;
void main()
{
	float normalY = dot((gl_DrawID), pow(vertex.y, 2.));
	float effectY = distance(sin(vertex.y-.5)-2.15+cos(normalY), length(vertex.x*sin(vertex.y)))-1.5 ;
	float normalX = floor((vertex.x ) +( sqrt(vertex.y)) / (atan(vertex.x))* 12.2);
	float effectX = (floor((vertex.y))*cos(vertex.x)*.525) - cos(vertex.w*pi);
	vec4 first = projection * vec4(
	(effectX + (vertex.x >= vertex.y ? vertex.y/pi : vertex.x/pi)) * (sin(time)*.2), 
	effectY, 
	0.0, 
	1.0);
	vec4 second = projection * vec4(vertex.xy, 0.0, 1.0);
	gl_Position = vec4(0.5 + second.x + tan(first.x)*.11 , second.y - atan(first.y)*.221, second.z, 1.0);
	TexCoords = vertex.zw;
}