;--------------------------------------------------------------------------------------------------
;
;	NAN0W0RM by Aleksi Eeben
;
;	256-byte Game Boy Classic game for Nano Game Competition at Lovebyte 2022
;	
;	aleksi.eeben@gmail.com
;	https://aleksieeben.wordpress.com
;
;--------------------------------------------------------------------------------------------------


;	Game Boy memory map

.MEMORYMAP
DEFAULTSLOT	0
SLOTSIZE	$4000
SLOT 0		$0000
SLOT 1		$4000
.ENDME

.ROMBANKSIZE	$4000
.ROMBANKS	2


;	High RAM variables

.ENUM $80

rnd		DB

speed		DB
length		DB
wormx		DB
wormy		DB
addy		DB
addx		DB
tail		DB

.ENDE


;	Game Boy registers

.DEFINE JOYP	$00	; joypad input
.DEFINE NR12	$12	; channel 1 envelope
.DEFINE NR14	$14	; channel 1 init
.DEFINE	LCDC	$40	; LCD control
.DEFINE BGP	$47	; background palette
.DEFINE IE	$ff	; interrupt enable



;	rst $00: Get a random location for an apple

.ORG	$0000

Apple
-
	rst	$08
	inc	a
	ld	d,a
	inc	e
	rst	$18
	or	a
	jr	nz,-
;	ret		; no space for ret, so executing some extra code below, does no harm


;	rst $08: Return random x- and y-coordinates in a and e (range $00-$0f)

.ORG	$0008

	call 	Random
	ld	e,a
Random
	ldh	a,(rnd)
	rrca
	jr	c,+
	xor	$4d
+
	ldh	(rnd),a
	and	$0f
	ret


;	rst $18: Calculate VRAM location and check tile at coordinates d,e and return location in hl

.ORG	$0018

Check
	ld	a,e
	add	a
	add	a
	add	a

	ld	h,$26			; $98 >> 2
	add	a
	rl	h
	add	a
	rl	h

	add	d
	ld	l,a

	ld	a,(hl)
	ret


;	Graphics

.ORG	$0028
	.DB	$3a,$5f,$8d,$9d,$bb,$ff,$de,$64		; $06 worm
	.DB	$00,$10,$18,$34,$4e,$fd,$f3,$6e		; $07 stinky
	.DB	$08,$10,$6c,$be,$fc,$fe,$7e,$34		; $08 apple


;	VBlank interrupt

.ORG	$0040
	reti


;	End delay

EndDelay
	ld	b,120			; 2 seconds delay
-
	halt
	dec	b
	jr	nz,-
	;

;	Init new game

Init
	xor	a			; assuming we're in VBlank, safe to turn off LCD
	ldh	(LCDC),a

	ld	hl,$9fff
-
	ldd	(hl),a			; clear screen and worm tail buffer
	bit	7,h
	jr	nz,-

	ld	c,a			; copy tile graphics from $0000
	ld	b,a
	ld	hl,$8010		; to VRAM at $8010
-
	ld	a,(bc)			; double bytes to VRAM (b/w graphics)
	ldi	(hl),a
	ldi	(hl),a
	inc	c
	jr	nz,-

	inc	a
	ldh	(IE),a			; enable VBlank interrupt
	ldh	(addx),a		; initial worm direction


	ld	a,10
	ld	hl,$ff00+speed
	ldi	(hl),a			; speed
	rrca				
	ldi	(hl),a			; length
	ldi	(hl),a			; wormy
	ldi	(hl),a			; wormx
	ld	(hl),0			; addy
	;

NewApple
	ld	a,$81			; play a sound
	ldh	(NR12),a
	ldh	(NR14),a

	ld	hl,$ff00+speed
	dec	(hl)			; speed up worm
	inc	l
	inc	(hl)			; increase worm length

	rst	$00			; draw apple at random location
	ld	(hl),$08

	ld	a,$91
	ldh	(LCDC),a		; LCD on, background on, tile data at $8000, map at $9800
	ld	a,%11000000
	ldh	(BGP),a			; set background palette

	ei				; enable interrupts


;	Main game loop

Play
	ldh	a,(speed)		; worm speed
	ld	b,a
-
	halt

	ld	de,$0000		; read joypad every frame

	ld	a,%00100000
	ldh	(JOYP),a

	ldh	a,(JOYP)
	rra
	jr	c,_notright
	inc	d
	jr	_notdown
_notright
	rra
	jr	c,_notleft
	dec	d
	jr	_notdown
_notleft
	rra
	jr	c,_notup
	dec	e
_notup
	rra
	jr	c,_notdown
	inc	e
_notdown
	ld	a,d			; got new direction?
	cp	e
	jr	z,_nokey

	ldh	(addx),a		; set new direction
	ld	a,e
	ldh	(addy),a
_nokey
	dec	b			; worm speed counter
	jr	nz,-

	ld	hl,$ff00+wormx		; move worm
	ldh	a,(addx)
	add	(hl)
	cp	20
_ncon
	jr	nc,EndDelay
	ldi	(hl),a
	ld	d,a
	ldh	a,(addy)
	add	(hl)
	cp	18
	jr	nc,_ncon
	ld	(hl),a
	ld	e,a

	ld	b,$9c			; store tail
	ldh	a,(tail)
	ld	c,a
	inc	a			; increment tail pointer
	ldh	(tail),a
	ld	a,d
	ld	(bc),a
	inc	b
	ld	a,e
	ld	(bc),a

	rst	$18			; draw worm
	ld	(hl),$06
	cp	$08			; got apple?
	jr	z,NewApple
	or	a			; fatal collision?
	jp	nz,EndDelay

	ldh	a,(length)		; clear tail
	ld	d,a
	ldh	a,(tail)
	sub	d
	ld	c,a
	dec	b
	ld	a,(bc)			; b = $9c
	ld	d,a
	inc	b
	ld	a,(bc)
	ld	e,a

	rst	$18			; locate tail

	ldh	a,(speed)		; time for release?
	cp	2
	jr	z,Release

	ld	(hl),$00		; draw space
	jr	Play
Release
	ld	a,$07
	ldh	(speed),a		; reduce speed
	ld	(hl),a			; draw stinky
	jr	Play



;--------------------------------------------------------------------------------------------------
;
;	CARTRIDGE HEADER
;
;--------------------------------------------------------------------------------------------------

;	Entry

.ORG	$0100
	nop
	jp	Init


;	Nintendo logo

.ORG	$0104
	.DB	$ce,$ed,$66,$66,$cc,$0d,$00,$0b,$03,$73,$00,$83,$00,$0c,$00,$0d
	.DB	$00,$08,$11,$1f,$88,$89,$00,$0e,$dc,$cc,$6e,$e6,$dd,$dd,$d9,$99
	.DB	$bb,$bb,$67,$63,$6e,$0e,$ec,$cc,$dd,$dc,$99,$9f,$bb,$b9,$33,$3e


;	Cartridge info

.NAME			"NAN0W0RM"
.RAMSIZE		0
.EMPTYFILL		$00
.CARTRIDGETYPE		$00
.COMPUTECHECKSUM
.COMPUTECOMPLEMENTCHECK
.ROMDMG

.ORG	$014a
	.DB 	1		; destination code: Non-Japanese
.ORG	$014c
	.DB 	0		; mask ROM version number


;	Padding to smallest valid ROM size (32K)

.BANK 1
.ORG $3fff
	.DB 	0
