;--------------------------------------------------------------------------------------------------
;
;	NAN0FR0GGR by Aleksi Eeben
;
;	256-byte Game Boy Classic game for Nano Game Competition at Lovebyte 2022
;	
;	aleksi.eeben@gmail.com
;	https://aleksieeben.wordpress.com
;
;--------------------------------------------------------------------------------------------------


;	Game Boy memory map

.MEMORYMAP
DEFAULTSLOT	0
SLOTSIZE	$4000
SLOT 0		$0000
SLOT 1		$4000
.ENDME

.ROMBANKSIZE	$4000
.ROMBANKS	2


;	High RAM variables

.ENUM $80

lanes		DSB	18
rnd		DB

.ENDE


;	Game Boy registers

.DEFINE JOYP	$00	; joypad input
.DEFINE NR14	$14	; channel 1 init
.DEFINE	LCDC	$40	; LCD control
.DEFINE SCX	$43	; scroll x
.DEFINE LY	$44	; rasterline
.DEFINE BGP	$47	; background palette
.DEFINE OBP0	$48	; OBP0 object palette 0
.DEFINE IE	$ff	; interrupt enable


;	Lane speeds

.ORG	$0000
	.DB	3,1,2,0,-1,-2,-1,0


;	rst $08: RandomCar

.ORG	$0008

RandomCar
	ldh	a,(rnd)
	rla
	sbc	$cc
	ldh	(rnd),a
	and	$3e

	push	hl
	add	l
	ld	l,a
	ld	(hl),$20
	pop	hl

	ret


;	rst $18: FrogToStart

.ORG	$0018

FrogToStart
	ld	hl,$fe00		; frog
	ld	a,$90
	ldi	(hl),a
	rrca
	ldi	(hl),a
	ld	(hl),$1f
	ret


;	Init new game

Init
	xor	a			; assuming we're in VBlank, safe to turn off LCD
	ldh	(LCDC),a

	ld	c,a			; copy tile graphics from $0000
	ld	hl,$8010		; to VRAM at $8010
-
	ld	b,a			; $00cc
	ld	a,(bc)			; double bytes to VRAM (b/w graphics)
	ldi	(hl),a
	ldi	(hl),a
	xor	a
	ld	b,$fe			; clear OAM
	ld	(bc),a
	ld	b,$9c			; clear roads
	ld	(bc),a
	inc	b
	ld	(bc),a
	inc	c
	jr	nz,-

MoreCars
	rst	$18			; FrogToStart

	ld	hl,$9c33		; > $9830 = less cars on fastest lane
	ld	c,4			; four segments
	ld	de,$0080
--
	ld	b,2			; cars added in each segment per round
-
	rst	$08			; RandomCar
	dec	b
	jr	nz,-
	add	hl,de
	dec	c
	jr 	nz,--

	ld	a,$9b
	ldh	(LCDC),a		; LCD on, objects on, background on, tile data at $8000, map at $9c00
	ldh	(OBP0),a		; object palette 0


;	Main game loop

Play
	ld	hl,$ff80		; scroll x and add of each lane
	xor	a
	ld	(hl),a
	ld	c,$07			; lane directions
	ld	b,a
	ld	d,a			; first line $00

nextlane
	ld	e,%11000001
	ld	a,(bc)			; get lane speed
	or	a
	jr	z,+
	dec	e
+
-
	ldh	a,(LY)
	cp	d
	jr	nz,-

	ld	a,e
	ldh	(BGP),a

	ld	a,(bc)
	ld	e,a

	ld	a,(hl)			; lane scroll
	ldh	(SCX),a
	add	e
	ldi	(hl),a

	inc	c
	ld	a,c
	and	$07
	ld	c,a

	ld	a,d			; next lane
	add	8
	ld	d,a
	cp	$98
	jr	nz,nextlane

	ld	hl,$fe00		; check collision
	ldi	a,(hl)
	sub	$10
	rra
	rra
	rra
	or	$80
	ld	c,a
	ld	a,($ff00+c)		; get scroll value for row
	ld	b,a

	ldd	a,(hl)			; $fe01
	add	b
	sub	8
	rra
	rra
	rra
	and	$1f
	ld	e,a

	ld	a,(hl)			; $fe00
	sub	$10
	jr	nz,+

	ld	a,$81			; sound fx
	ldh	(NR14),a
	ld	d,$9c			; round completed, stamp frog
	ld	a,$1f
	ld	(de),a
	jr	MoreCars

+
	ld	b,$27			; $9c >> 2
	and	$f8
	rla
	rl	b
	rla
	rl	b
	add	e
	ld	c,a

	ld	a,(bc)			; frog hit?
	or	a
	jp	nz,Init

	ldh	a,($81)
	and	$03
	jr	nz,Play

	ld	a,%00100000		; read joypad
	ldh	(JOYP),a

	ld	bc,$0000
	ld	de,$08f8

	ldh	a,(JOYP)
	rra
	jr	c,_notright
	ld	b,d
_notright
	rra
	jr	c,_notleft
	ld	b,e
_notleft
	rra
	jr	c,_notup
	ld	c,e
_notup
	rra
	jr	c,_notdown
	ld	c,d
_notdown
	ld	a,c
	add	(hl)
	cp	$98
	jr	z,+
	ld	(hl),a
+
	inc	l
	ld	a,b
	add	(hl)
	or	a
	jr	z,+
	cp	$a8
	jr	z,+
	ld	(hl),a
+
	jp	Play


;	Graphics

.ORG	$00f0
	.DB	$99,$7e,$3c,$7e,$db,$e7,$66,$c3		; $1f frog
	.DB	$00,$3c,$66,$ff,$ff,$99,$66,$00		; $20 car



;--------------------------------------------------------------------------------------------------
;
;	CARTRIDGE HEADER
;
;--------------------------------------------------------------------------------------------------

;	Entry

.ORG	$0100
	nop
	jp	Init


;	Nintendo logo

.ORG	$0104
	.DB	$ce,$ed,$66,$66,$cc,$0d,$00,$0b,$03,$73,$00,$83,$00,$0c,$00,$0d
	.DB	$00,$08,$11,$1f,$88,$89,$00,$0e,$dc,$cc,$6e,$e6,$dd,$dd,$d9,$99
	.DB	$bb,$bb,$67,$63,$6e,$0e,$ec,$cc,$dd,$dc,$99,$9f,$bb,$b9,$33,$3e


;	Cartridge info

.NAME			"NAN0FR0GGR"
.RAMSIZE		0
.EMPTYFILL		$00
.CARTRIDGETYPE		$00
.COMPUTECHECKSUM
.COMPUTECOMPLEMENTCHECK
.ROMDMG

.ORG	$014a
	.DB 	1		; destination code: Non-Japanese
.ORG	$014c
	.DB 	0		; mask ROM version number


;	Padding to smallest valid ROM size (32K)

.BANK 1
.ORG $3fff
	.DB 	0
