;--------------------------------------------------------------------------------------------------
;
;	NAN0B0MBA by Aleksi Eeben
;
;	256-byte Game Boy Classic game for Nano Game Competition at Lovebyte 2022
;	
;	aleksi.eeben@gmail.com
;	https://aleksieeben.wordpress.com
;
;--------------------------------------------------------------------------------------------------


;	Game Boy memory map

.MEMORYMAP
DEFAULTSLOT	0
SLOTSIZE	$4000
SLOT 0		$0000
SLOT 1		$4000
.ENDME

.ROMBANKSIZE	$4000
.ROMBANKS	2


;	High RAM variables

.ENUM $80

rnd		DB
lastjoy		DB

.ENDE


;	Game Boy registers

.DEFINE JOYP	$00	; joypad input
.DEFINE NR42	$21	; NR42 noise channel volume envelope
.DEFINE NR51	$25	; NR51 panning of sound channels
.DEFINE	LCDC	$40	; LCD control
.DEFINE SCX	$43	; scroll x
.DEFINE BGP	$47	; background palette
.DEFINE OBP0	$48	; OBP0 object palette 0
.DEFINE IE	$ff	; interrupt enable


;	rst $00: CreateRandomBuilding (e = building 0-31)

.ORG	$0000

CreateRandomBuilding
	ld	d,$c0			; $c0 stays in d during main game loop

	ldh	a,(rnd)
	rla
	sbc	$cd
	ldh	(rnd),a
	and	7
	add	2

	ld	(de),a			; store in RAM $c0xx
	nop
	nop
	;

;	rst $10: DrawBuilding (e = building 0-31)

.ORG	$0010

DrawBuilding
	ld	h,$9a			; first floor of building
	ld	l,e

	push	hl
	ld	bc,$1200		; draw sky or blank background in this column
	rst	$20
	pop	hl

	ld	a,(de)			; get building height from RAM at $c0xx
	and	a
	jr	z,++			; return if height zero

	ld	b,a
	ld	c,$1e
	;

;	rst $20: Draw (draw b lines of c starting at hl)

.ORG	$0020

Draw
-
	ld	a,c
	ld	(hl),a			; draw building or sky

	ld	a,l			; not using add hl,bc to save registers for better use
	add	$e0
	ld	l,a
	jr	c,+
	dec	h
+
	dec	b
	jr	nz,-
++
	ld	a,e			; copy e to a for Init loop
	ld	h,$ff			; used for sound fx after ret
	ret


;	rst $30: CheckTile (a = y-coordinate in bomb column)

.ORG	$0030

CheckTile
	sub	$0c

	ld	b,$26			; $98 >> 2
	and	$f8
	rla
	rl	b
	rla
	rl	b
	add	e			; add column (0-31)
	ld	c,a
	ld	a,(bc)
	or	a
	;				; reti is fine, we've got interrupts already enabled here

;	VBlank interrupt

.ORG	$0040
	reti


;	Init new game

Init
	xor	a			; assuming we're in VBlank, safe to turn off LCD
	ldh	(LCDC),a

	ld	c,a			; copy tile graphics from $0000
	ld	hl,$8010		; to VRAM at $8010

	inc	a
	ldh	(IE),a			; enable vblank interrupt
	cpl
	ldh	(NR51),a		; pan noise channel to center
	ldh	(OBP0),a		; object palette 0

-
	ld	b,a
	ld	a,(bc)			; double bytes to VRAM (b/w graphics)
	ldi	(hl),a
	ldi	(hl),a
	xor	a
	ld	b,$fe
	ld	(bc),a			; OAM
	inc	c
	jr	nz,-

	ld	hl,OAMTable+10		; init plane and bomb objects in OAM
	ld	e,$0b
	ld	d,b
-
	dec	e
	ldd	a,(hl)
	ld	(de),a
	jr	nz,-

-
	rst	$00			; random building heights, draw buildings and sky
	inc	e
	cp	31			; previous value of e is copied to a at end of rst $00
	jr	nz,-

	ld	a,$93
	ldh	(LCDC),a		; LCD on, objects on, background on, tile data at $8000

	ei

	ld	a,$a4
	ldh	(BGP),a			; background palette

Explosion
	ld	l,NR42			; NR42, h is set to $ff in rst $10
	ldi	(hl),a
	rrca
	ldi	(hl),a			; NR43 freq/div
	ld	(hl),$80		; NR44 set bit 7 init


;	Main game loop

Play
	halt				; wait for VBlank

	ldh	a,(SCX)			; scroll screen
	inc	a
	ldh	(SCX),a

	rra				; pixels to tiles
	rra
	rra

	add	4			; tiles offset to bomb and plane column
	and	$1f			; map line wrap
	ld	e,a			; e used later during this frame

	ld	hl,$fe00		; OAM address, about to move plane and/or bomb

	ldh	a,(SCX)
	and	$1f
	jr	nz,+

	inc	(hl)			; plane left half down
	ld	l,$04
	inc	(hl)			; plane right half down
+
	ld	a,(hl)			; level completed?
	cp	$96
	jr	z,Init

	add	$02			; adjust plane collision check
	rst	$30			; CheckTile
	jr	nz,Init			; plane crashed!

	ld	l,$08			; move bomb down if y<>0
	ld	a,(hl)
	or	a
	jr	nz,+

	ld	a,%00010000		; check button
	ldh	(JOYP),a

	ldh	a,(lastjoy)
	ld	b,a
	ldh	a,(JOYP)
	cp	b
	jr	z,Play			; buttons same as last frame
	ldh	(lastjoy),a
	rra				; button a?
	jr	c,Play

	ld	a,($fe00)		; drop new bomb
+
	inc	a
	cp	$98
	jr	z,+
	ld	(hl),a			; move bomb down

	rst	$30			; CheckTile
	jr	z,Play
+
	xor	a			; stop bomb
	ld	(hl),a

	ld	a,(de)			; shorten building
	sub	3
	jr	nc,+
	xor	a
+
	ld	(de),a
	rst	$10			; draw shortened building

	ld	a,$a6			; env start a, fade out rate 7
	jr	Explosion


;	Plane and Bomb objects

OAMTable
	.DB	$14,$20,$1f,$00
	.DB	$14,$28,$20,$00
	.DB	$00,$28,$1d


;	Graphics

.ORG	$00e0
	.DB	$00,$00,$3c,$18,$3c,$3c,$3c,$18		; bomb
	.DB	$fe,$aa,$aa,$fe,$fe,$aa,$aa,$fe		; building
	.DB	$e0,$f0,$ce,$f7,$3d,$43,$00,$00		; left half of plane
	.DB	$fc,$29,$7d,$ae,$05,$f9,$10,$08		; right half of plane



;--------------------------------------------------------------------------------------------------
;
;	CARTRIDGE HEADER
;
;--------------------------------------------------------------------------------------------------

;	Entry

.ORG	$0100
	nop
	jp	Init


;	Nintendo logo

.ORG	$0104
	.DB	$ce,$ed,$66,$66,$cc,$0d,$00,$0b,$03,$73,$00,$83,$00,$0c,$00,$0d
	.DB	$00,$08,$11,$1f,$88,$89,$00,$0e,$dc,$cc,$6e,$e6,$dd,$dd,$d9,$99
	.DB	$bb,$bb,$67,$63,$6e,$0e,$ec,$cc,$dd,$dc,$99,$9f,$bb,$b9,$33,$3e


;	Cartridge info

.NAME			"NAN0B0MBA"
.RAMSIZE		0
.EMPTYFILL		$00
.CARTRIDGETYPE		$00
.COMPUTECHECKSUM
.COMPUTECOMPLEMENTCHECK
.ROMDMG

.ORG	$014a
	.DB 	1		; destination code: Non-Japanese
.ORG	$014c
	.DB 	0		; mask ROM version number


;	Padding to smallest valid ROM size (32K)

.BANK 1
.ORG $3fff
	.DB 	0
