const Laiva = function(){
    PartBase.call(this);

    //POSTPROCESSING
    this.setDoF({
        focus: 1.1,
        maxblur: 0.01,
        aparture: 0.01
    });

    const texture = TDEMO.TEXTURES.getTextures().farjan;
    const material = new THREE.SpriteMaterial({map : texture});
    const sprite = new THREE.Sprite(material);
    sprite.scale.x = 4;
    sprite.scale.y = 2;
    this.farjan = new THREE.Object3D();
    this.farjan.add(sprite);
    this.scene.add(this.farjan);

    const bg = this.createScene();
    this.scene.add(bg);
};

Laiva.prototype = PartBase.prototype.inheritance();

Laiva.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta, true);
    const pos = TDEMO.SYNC.getObjPosition();
    this.farjan.position.x = pos.x;
    this.farjan.position.y = pos.y;
};

Laiva.prototype.createScene = function(map){
    const tg = new THREE.PlaneBufferGeometry(1600, 800);
    const tm = new THREE.MeshBasicMaterial({
        color: 0x0088FF
    });
    const taivas = new THREE.Mesh(tg, tm);
    taivas.position.z = -1;

    const ag = new THREE.CircleGeometry(0.8, 32);
    const am = new THREE.MeshBasicMaterial( { color: 0xff8800 } );
    const aurinko = new THREE.Mesh( ag, am );
    aurinko.position.x = 2.5;
    aurinko.position.y = 1;

    const mg = new THREE.PlaneBufferGeometry(1600, 800);
    const mm = new THREE.MeshBasicMaterial({
        color: 0x006699
    })
    const meri = new THREE.Mesh(mg, mm);
    meri.position.y = -400;
    meri.position.z = 0;

    const group = new THREE.Object3D();
    group.add(taivas);
    group.add(aurinko);
    group.add(meri);

    return group;
}