import processing.sound.*;
SoundFile file;
PFont f;

int bpm = 174;
float audioDelayMS = 20;
float songStartTime;
boolean started = false;

void setup() {
//  size(640, 360, P3D);
  fullScreen(P3D);
  background(255);
  colorMode(HSB, 360, 100, 100);
    
  // Load a soundfile from the /data folder of the sketch and play it back
  file = new SoundFile(this, "biisi.aif");
  
  // Create the font
  printArray(PFont.list());
  f = createFont("SourceCodePro-Regular.ttf", 24);
  textFont(f);
}      

void draw() {
  if (!started) {
    file.play();
    songStartTime = millis();
    started = true;
  }

  float beat = (millis() - songStartTime + audioDelayMS) / 1000.0 * (bpm / 60.0);
  if (beat >= 32) {
    exit();
  }

  background(0);
  translate(width/2, height/2);
  scale(height / 1000.0);
  
  // end of boilerplate
  
  if (beat % 2 < 1) {
    int[] hues = {320, 220, 50, 140};
    int hue = hues[int(beat/2) % hues.length];
    background(0, 0, 0);
    fill(0, 0, 100);
    stroke(hue, 60, 100);
  } else {
    int[] hues = {50, 140, 320, 220};
    int hue = hues[int(beat/2) % hues.length];
    background(hue, 60, 100);
    fill(0, 0, 0);
    stroke(0, 0, 0);
  }
  
//  int xDetail = int(2 + exp(map(int(beat * 3 % 5), 0, 5, log(1), log(10)))); 
//  int yDetail = int(1 + exp(map(int(int(beat/2) * 4 % 7), 0, 5, log(1), log(5))));

//  int xDetail = 3 + int(beat / 2) * 2 % 3; 
//  int yDetail = 2 + int((beat + 1) / 2) % 2;

  int[] xDetails = {3, 5, 4, 9};
  int[] yDetails = {2, 3, 2, 5};
  int xDetail = xDetails[int(beat / 2) % xDetails.length];
  int yDetail = yDetails[int((beat/2 + 1) / 1.5) % yDetails.length];
  

  sphereDetail(xDetail, yDetail);

  float scale = exp(map(int(int(beat) * 4 % 7), 0, 7, log(0.3), log(3)));
  float pump = cos(6.283 * beat);
  scale *= exp(map(pump, -1, 1, log(0.95), log(1.05)));
  scale(scale);
  
  //translate(0, map(pump, -1, 1, -100, 100), 0);

  noFill();
  strokeWeight(10);
  
  
  float[] zs = {-700, 400, 1600, 400};
  float z = zs[int(beat / 2) % zs.length];
  translate(0, 0, -z);
//  rotateX(1 * cos(6.283 * beat / 4));
  rotateX(1.5 * cos(6.283 * beat / 8 + 4 * int(beat / 4)));
  rotateY(3 * cos(6.283 * beat / 16 + 1 * int(beat / 2)));
  sphere(1000);
  
/*  String out = "" + beat;
  
  textAlign(LEFT);
  textSize(128);
  text(out, -200, 0);*/
}
