/* autogenerated by Processing revision 1277 on 2022-08-27 */
import processing.core.*;
import processing.data.*;
import processing.event.*;
import processing.opengl.*;

import processing.sound.*;

import java.util.HashMap;
import java.util.ArrayList;
import java.io.File;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;

public class demo extends PApplet {


SoundFile file;
PFont f;

int bpm = 174;
float audioDelayMS = 20;
float songStartTime;
boolean started = false;

 public void setup() {
//  size(640, 360, P3D);
  /* size commented out by preprocessor */;
  background(255);
  colorMode(HSB, 360, 100, 100);
    
  // Load a soundfile from the /data folder of the sketch and play it back
  file = new SoundFile(this, "biisi.aif");
  
  // Create the font
  printArray(PFont.list());
  f = createFont("SourceCodePro-Regular.ttf", 24);
  textFont(f);
}      

 public void draw() {
  if (!started) {
    file.play();
    songStartTime = millis();
    started = true;
  }

  float beat = (millis() - songStartTime + audioDelayMS) / 1000.0f * (bpm / 60.0f);
  if (beat >= 32) {
    exit();
  }

  background(0);
  translate(width/2, height/2);
  scale(height / 1000.0f);
  
  // end of boilerplate
  
  if (beat % 2 < 1) {
    int[] hues = {320, 220, 50, 140};
    int hue = hues[PApplet.parseInt(beat/2) % hues.length];
    background(0, 0, 0);
    fill(0, 0, 100);
    stroke(hue, 60, 100);
  } else {
    int[] hues = {50, 140, 320, 220};
    int hue = hues[PApplet.parseInt(beat/2) % hues.length];
    background(hue, 60, 100);
    fill(0, 0, 0);
    stroke(0, 0, 0);
  }
  
//  int xDetail = int(2 + exp(map(int(beat * 3 % 5), 0, 5, log(1), log(10)))); 
//  int yDetail = int(1 + exp(map(int(int(beat/2) * 4 % 7), 0, 5, log(1), log(5))));

//  int xDetail = 3 + int(beat / 2) * 2 % 3; 
//  int yDetail = 2 + int((beat + 1) / 2) % 2;

  int[] xDetails = {3, 5, 4, 9};
  int[] yDetails = {2, 3, 2, 5};
  int xDetail = xDetails[PApplet.parseInt(beat / 2) % xDetails.length];
  int yDetail = yDetails[PApplet.parseInt((beat/2 + 1) / 1.5f) % yDetails.length];
  

  sphereDetail(xDetail, yDetail);

  float scale = exp(map(PApplet.parseInt(PApplet.parseInt(beat) * 4 % 7), 0, 7, log(0.3f), log(3)));
  float pump = cos(6.283f * beat);
  scale *= exp(map(pump, -1, 1, log(0.95f), log(1.05f)));
  scale(scale);
  
  //translate(0, map(pump, -1, 1, -100, 100), 0);

  noFill();
  strokeWeight(10);
  
  
  float[] zs = {-700, 400, 1600, 400};
  float z = zs[PApplet.parseInt(beat / 2) % zs.length];
  translate(0, 0, -z);
//  rotateX(1 * cos(6.283 * beat / 4));
  rotateX(1.5f * cos(6.283f * beat / 8 + 4 * PApplet.parseInt(beat / 4)));
  rotateY(3 * cos(6.283f * beat / 16 + 1 * PApplet.parseInt(beat / 2)));
  sphere(1000);
  
/*  String out = "" + beat;
  
  textAlign(LEFT);
  textSize(128);
  text(out, -200, 0);*/
}


  public void settings() { fullScreen(P3D); }

  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "demo" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
