/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import processing.core.PFont;
import processing.sound.SoundFile;

public class demo
extends PApplet {
    SoundFile file;
    PFont f;
    int bpm = 174;
    float audioDelayMS = 20.0f;
    float songStartTime;
    boolean started = false;

    public void setup() {
        this.background(255);
        this.colorMode(3, 360.0f, 100.0f, 100.0f);
        this.file = new SoundFile((PApplet)this, "biisi.aif");
        demo.printArray((Object)PFont.list());
        this.f = this.createFont("SourceCodePro-Regular.ttf", 24.0f);
        this.textFont(this.f);
    }

    public void draw() {
        int hue;
        int[] hues;
        float beat;
        if (!this.started) {
            this.file.play();
            this.songStartTime = this.millis();
            this.started = true;
        }
        if ((beat = ((float)this.millis() - this.songStartTime + this.audioDelayMS) / 1000.0f * ((float)this.bpm / 60.0f)) >= 32.0f) {
            this.exit();
        }
        this.background(0);
        this.translate(this.width / 2, this.height / 2);
        this.scale((float)this.height / 1000.0f);
        if (beat % 2.0f < 1.0f) {
            hues = new int[]{320, 220, 50, 140};
            hue = hues[PApplet.parseInt((float)(beat / 2.0f)) % hues.length];
            this.background(0.0f, 0.0f, 0.0f);
            this.fill(0.0f, 0.0f, 100.0f);
            this.stroke(hue, 60.0f, 100.0f);
        } else {
            hues = new int[]{50, 140, 320, 220};
            hue = hues[PApplet.parseInt((float)(beat / 2.0f)) % hues.length];
            this.background(hue, 60.0f, 100.0f);
            this.fill(0.0f, 0.0f, 0.0f);
            this.stroke(0.0f, 0.0f, 0.0f);
        }
        int[] xDetails = new int[]{3, 5, 4, 9};
        int[] yDetails = new int[]{2, 3, 2, 5};
        int xDetail = xDetails[PApplet.parseInt((float)(beat / 2.0f)) % xDetails.length];
        int yDetail = yDetails[PApplet.parseInt((float)((beat / 2.0f + 1.0f) / 1.5f)) % yDetails.length];
        this.sphereDetail(xDetail, yDetail);
        float scale = demo.exp((float)demo.map((float)PApplet.parseInt((float)(PApplet.parseInt((float)beat) * 4 % 7)), (float)0.0f, (float)7.0f, (float)demo.log((float)0.3f), (float)demo.log((float)3.0f)));
        float pump = demo.cos((float)(6.283f * beat));
        this.scale(scale *= demo.exp((float)demo.map((float)pump, (float)-1.0f, (float)1.0f, (float)demo.log((float)0.95f), (float)demo.log((float)1.05f))));
        this.noFill();
        this.strokeWeight(10.0f);
        float[] zs = new float[]{-700.0f, 400.0f, 1600.0f, 400.0f};
        float z = zs[PApplet.parseInt((float)(beat / 2.0f)) % zs.length];
        this.translate(0.0f, 0.0f, -z);
        this.rotateX(1.5f * demo.cos((float)(6.283f * beat / 8.0f + (float)(4 * PApplet.parseInt((float)(beat / 4.0f))))));
        this.rotateY(3.0f * demo.cos((float)(6.283f * beat / 16.0f + (float)(1 * PApplet.parseInt((float)(beat / 2.0f))))));
        this.sphere(1000.0f);
    }

    public void settings() {
        this.fullScreen("processing.opengl.PGraphics3D");
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"demo"};
        if (passedArgs != null) {
            PApplet.main((String[])demo.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

