/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.devices.javasound;

import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;

public class MidiDeviceTools {
    public static void listDevices() {
        MidiDevice.Info[] infoArray;
        for (MidiDevice.Info info : infoArray = MidiSystem.getMidiDeviceInfo()) {
            System.out.println("MIDI Info: " + info.getDescription() + ", " + info.getName() + ", " + info.getVendor() + ", " + info.getVersion());
            try {
                MidiDevice midiDevice = MidiSystem.getMidiDevice(info);
                System.out.println("   Device: , #recv = " + midiDevice.getMaxReceivers() + ", #xmit = " + midiDevice.getMaxTransmitters() + ", open = " + midiDevice.isOpen() + ", " + midiDevice);
            }
            catch (MidiUnavailableException midiUnavailableException) {
                midiUnavailableException.printStackTrace();
            }
        }
    }

    public static MidiDevice findKeyboard(String string) {
        MidiDevice.Info[] infoArray;
        MidiDevice midiDevice = null;
        for (MidiDevice.Info info : infoArray = MidiSystem.getMidiDeviceInfo()) {
            try {
                MidiDevice midiDevice2 = MidiSystem.getMidiDevice(info);
                if (midiDevice2 instanceof Synthesizer || midiDevice2 instanceof Sequencer || midiDevice2.getMaxTransmitters() == 0 || string != null && !info.getDescription().toLowerCase().contains(string.toLowerCase())) continue;
                midiDevice = midiDevice2;
                System.out.println("Chose: " + info.getDescription());
                break;
            }
            catch (MidiUnavailableException midiUnavailableException) {
                midiUnavailableException.printStackTrace();
            }
        }
        return midiDevice;
    }

    public static MidiDevice findKeyboard() {
        return MidiDeviceTools.findKeyboard(null);
    }
}

