/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import com.jogamp.common.util.IOUtil;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.MutableGraphicsConfiguration;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.WindowClosingProtocol;
import com.jogamp.nativewindow.util.Dimension;
import com.jogamp.nativewindow.util.DimensionImmutable;
import com.jogamp.nativewindow.util.PixelFormat;
import com.jogamp.nativewindow.util.PixelRectangle;
import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseAdapter;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.WindowUpdateEvent;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.util.FPSAnimator;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import processing.awt.PImageAWT;
import processing.awt.ShimAWT;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PSurface;
import processing.opengl.PGL;
import processing.opengl.PGraphicsOpenGL;
import processing.opengl.PJOGL;

public class PSurfaceJOGL
implements PSurface {
    public static GLProfile profile;
    public PJOGL pgl;
    protected GLWindow window;
    protected FPSAnimator animator;
    protected Rectangle screenRect;
    private Thread drawExceptionHandler;
    protected PApplet sketch;
    protected PGraphics graphics;
    protected int sketchWidth0;
    protected int sketchHeight0;
    protected int sketchWidth;
    protected int sketchHeight;
    protected Display display;
    protected Screen screen;
    protected Rectangle displayRect;
    protected Throwable drawException;
    private final Object drawExceptionMutex = new Object();
    protected NewtCanvasAWT canvas;
    protected int windowScaleFactor;
    protected float[] currentPixelScale = new float[]{0.0f, 0.0f};
    protected boolean external = false;
    static Map<Integer, CursorInfo> cursors;
    static Map<Integer, String> cursorNames;

    public PSurfaceJOGL(PGraphics graphics) {
        this.graphics = graphics;
        this.pgl = (PJOGL)((PGraphicsOpenGL)graphics).pgl;
    }

    @Override
    public PImage loadImage(String path, Object ... args) {
        return ShimAWT.loadImage(this.sketch, path, args);
    }

    @Override
    public void selectInput(String prompt, String callbackMethod, File file, Object callbackObject) {
        EventQueue.invokeLater(() -> {
            boolean hide;
            boolean bl = hide = this.sketch != null && PApplet.platform == 1;
            if (hide) {
                this.setVisible(false);
            }
            ShimAWT.selectImpl(prompt, callbackMethod, file, callbackObject, null, 0);
            if (hide) {
                this.setVisible(true);
            }
        });
    }

    @Override
    public void selectOutput(String prompt, String callbackMethod, File file, Object callbackObject) {
        EventQueue.invokeLater(() -> {
            boolean hide;
            boolean bl = hide = this.sketch != null && PApplet.platform == 1;
            if (hide) {
                this.setVisible(false);
            }
            ShimAWT.selectImpl(prompt, callbackMethod, file, callbackObject, null, 1);
            if (hide) {
                this.setVisible(true);
            }
        });
    }

    @Override
    public void selectFolder(String prompt, String callbackMethod, File file, Object callbackObject) {
        EventQueue.invokeLater(() -> {
            boolean hide;
            boolean bl = hide = this.sketch != null && PApplet.platform == 1;
            if (hide) {
                this.setVisible(false);
            }
            ShimAWT.selectFolderImpl(prompt, callbackMethod, file, callbackObject, null);
            if (hide) {
                this.setVisible(true);
            }
        });
    }

    @Override
    public void initOffscreen(PApplet sketch) {
        this.sketch = sketch;
        this.sketchWidth = sketch.sketchWidth();
        this.sketchHeight = sketch.sketchHeight();
        if (this.window != null) {
            this.canvas = new NewtCanvasAWT((Window)this.window);
            this.canvas.setBounds(0, 0, this.window.getWidth(), this.window.getHeight());
            this.canvas.setFocusable(true);
        }
    }

    @Override
    public void initFrame(PApplet sketch) {
        this.sketch = sketch;
        this.initIcons();
        this.initDisplay();
        this.initGL();
        this.initWindow();
        this.initListeners();
        this.initAnimator();
    }

    @Override
    public Object getNative() {
        return this.window;
    }

    protected void initDisplay() {
        this.display = NewtFactory.createDisplay(null);
        this.display.addReference();
        this.screen = NewtFactory.createScreen((Display)this.display, (int)0);
        this.screen.addReference();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] awtDevices = ge.getScreenDevices();
        GraphicsDevice awtDisplayDevice = null;
        int displayNum = this.sketch.sketchDisplay();
        if (displayNum > 0) {
            if (displayNum <= awtDevices.length) {
                awtDisplayDevice = awtDevices[displayNum - 1];
            } else {
                System.err.format("Display %d does not exist, using the default display instead.%n", displayNum);
                for (int i = 0; i < awtDevices.length; ++i) {
                    System.err.format("Display %d is %s%n", i + 1, awtDevices[i]);
                }
            }
        } else if (0 < awtDevices.length) {
            awtDisplayDevice = awtDevices[0];
        }
        if (awtDisplayDevice == null) {
            awtDisplayDevice = ge.getDefaultScreenDevice();
        }
        GraphicsConfiguration config = awtDisplayDevice.getDefaultConfiguration();
        this.displayRect = config.getBounds();
    }

    protected void initGL() {
        if (profile == null) {
            if (PJOGL.profile == 1) {
                try {
                    profile = GLProfile.getGL2ES1();
                }
                catch (GLException ex) {
                    profile = GLProfile.getMaxFixedFunc((boolean)true);
                }
            } else if (PJOGL.profile == 2) {
                try {
                    GLProfile hardware;
                    profile = GLProfile.getGL2ES2();
                    if (!profile.isHardwareRasterizer() && (hardware = GLProfile.getMaxProgrammable((boolean)true)).isGL2ES2()) {
                        profile = hardware;
                    }
                }
                catch (GLException ex) {
                    profile = GLProfile.getMaxProgrammable((boolean)true);
                }
            } else if (PJOGL.profile == 3) {
                try {
                    profile = GLProfile.getGL2GL3();
                }
                catch (GLException ex) {
                    profile = GLProfile.getMaxProgrammable((boolean)true);
                }
                if (!profile.isGL3()) {
                    PGraphics.showWarning("Requested profile GL3 but is not available, got: " + profile);
                }
            } else if (PJOGL.profile == 4) {
                try {
                    profile = GLProfile.getGL4ES3();
                }
                catch (GLException ex) {
                    profile = GLProfile.getMaxProgrammable((boolean)true);
                }
                if (!profile.isGL4()) {
                    PGraphics.showWarning("Requested profile GL4 but is not available, got: " + profile);
                }
            } else {
                throw new RuntimeException("Unsupported OpenGL profile.");
            }
        }
        GLCapabilities caps = new GLCapabilities(profile);
        caps.setAlphaBits(PGL.REQUESTED_ALPHA_BITS);
        caps.setDepthBits(PGL.REQUESTED_DEPTH_BITS);
        caps.setStencilBits(PGL.REQUESTED_STENCIL_BITS);
        caps.setSampleBuffers(true);
        caps.setNumSamples(PGL.smoothToSamples(this.graphics.smooth));
        caps.setBackgroundOpaque(true);
        caps.setOnscreen(true);
        this.pgl.setCaps(caps);
    }

    protected void initWindow() {
        this.window = GLWindow.create((Screen)this.screen, (GLCapabilitiesImmutable)this.pgl.getCaps());
        this.window.setDefaultCloseOperation(WindowClosingProtocol.WindowClosingMode.DO_NOTHING_ON_CLOSE);
        this.windowScaleFactor = PApplet.platform == 2 ? 1 : this.sketch.pixelDensity;
        boolean spanDisplays = this.sketch.sketchDisplay() == 0;
        this.screenRect = spanDisplays ? new Rectangle(this.screen.getX(), this.screen.getY(), this.screen.getWidth(), this.screen.getHeight()) : new Rectangle((int)this.displayRect.getX(), (int)this.displayRect.getY(), (int)this.displayRect.getWidth(), (int)this.displayRect.getHeight());
        this.sketch.displayWidth = this.screenRect.width;
        this.sketch.displayHeight = this.screenRect.height;
        this.sketchWidth0 = this.sketch.sketchWidth();
        this.sketchHeight0 = this.sketch.sketchHeight();
        this.sketchWidth = this.sketch.sketchWidth();
        this.sketchHeight = this.sketch.sketchHeight();
        boolean fullScreen = this.sketch.sketchFullScreen();
        if (fullScreen || spanDisplays) {
            this.sketchWidth = this.screenRect.width / this.windowScaleFactor;
            this.sketchHeight = this.screenRect.height / this.windowScaleFactor;
        }
        this.sketch.setSize(this.sketchWidth, this.sketchHeight);
        float surfaceScale = this.graphics.is2X() && PApplet.platform == 2 ? 0.0f : 1.0f;
        this.window.setSurfaceScale(new float[]{surfaceScale, surfaceScale});
        this.window.setSize(this.sketchWidth * this.windowScaleFactor, this.sketchHeight * this.windowScaleFactor);
        this.window.setResizable(false);
        this.setSize(this.sketchWidth, this.sketchHeight);
        if (fullScreen) {
            PApplet.hideMenuBar();
            if (spanDisplays) {
                this.window.setFullscreen(this.screen.getMonitorDevices());
            } else {
                this.window.setUndecorated(true);
                this.window.setTopLevelPosition((int)this.displayRect.getX(), (int)this.displayRect.getY());
                this.window.setTopLevelSize((int)this.displayRect.getWidth(), (int)this.displayRect.getHeight());
            }
        }
    }

    protected void initListeners() {
        NEWTMouseListener mouseListener = new NEWTMouseListener();
        this.window.addMouseListener((MouseListener)mouseListener);
        NEWTKeyListener keyListener = new NEWTKeyListener();
        this.window.addKeyListener((KeyListener)keyListener);
        NEWTWindowListener winListener = new NEWTWindowListener();
        this.window.addWindowListener((WindowListener)winListener);
        DrawListener drawlistener = new DrawListener();
        this.window.addGLEventListener((GLEventListener)drawlistener);
    }

    protected void initAnimator() {
        if (PApplet.platform == 1) {
            Thread highResTimerThread = new Thread(() -> {
                try {
                    Thread.sleep(Long.MAX_VALUE);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }, "HighResTimerThread");
            highResTimerThread.setDaemon(true);
            highResTimerThread.start();
        }
        this.animator = new FPSAnimator((GLAutoDrawable)this.window, 60);
        this.drawException = null;
        this.animator.setUncaughtExceptionHandler((animator, drawable, cause) -> {
            Object object = this.drawExceptionMutex;
            synchronized (object) {
                this.drawException = cause;
                this.drawExceptionMutex.notify();
            }
        });
        this.drawExceptionHandler = new Thread(() -> {
            Object object = this.drawExceptionMutex;
            synchronized (object) {
                try {
                    while (this.drawException == null) {
                        this.drawExceptionMutex.wait();
                    }
                    Throwable cause = this.drawException.getCause();
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    if (cause instanceof UnsatisfiedLinkError) {
                        throw new UnsatisfiedLinkError(cause.getMessage());
                    }
                    if (cause == null) {
                        throw new RuntimeException(this.drawException.getMessage());
                    }
                    throw new RuntimeException(cause);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        });
        this.drawExceptionHandler.start();
    }

    @Override
    public void setTitle(String title) {
        this.display.getEDTUtil().invoke(false, () -> this.window.setTitle(title));
    }

    @Override
    public void setVisible(boolean visible) {
        this.display.getEDTUtil().invoke(false, () -> this.window.setVisible(visible));
    }

    @Override
    public void setResizable(boolean resizable) {
        this.display.getEDTUtil().invoke(false, () -> this.window.setResizable(resizable));
    }

    @Override
    public void setIcon(PImage icon) {
        PGraphics.showWarning("Window icons for OpenGL sketches can only be set in settings()\nusing PJOGL.setIcon(filename).");
    }

    @Override
    public void setAlwaysOnTop(boolean always) {
        this.display.getEDTUtil().invoke(false, () -> this.window.setAlwaysOnTop(always));
    }

    protected void initIcons() {
        IOUtil.ClassResources res;
        if (PJOGL.icons == null || PJOGL.icons.length == 0) {
            int[] sizes = new int[]{16, 32, 48, 64, 128, 256, 512};
            String[] iconImages = new String[sizes.length];
            for (int i = 0; i < sizes.length; ++i) {
                iconImages[i] = "/icon/icon-" + sizes[i] + ".png";
            }
            res = new IOUtil.ClassResources(iconImages, PApplet.class.getClassLoader(), PApplet.class);
        } else {
            String[] iconImages = new String[PJOGL.icons.length];
            for (int i = 0; i < PJOGL.icons.length; ++i) {
                iconImages[i] = this.resourceFilename(PJOGL.icons[i]);
            }
            res = new IOUtil.ClassResources(iconImages, this.sketch.getClass().getClassLoader(), this.sketch.getClass());
        }
        NewtFactory.setWindowIcons((IOUtil.ClassResources)res);
    }

    private String resourceFilename(String filename) {
        try {
            File file = new File(this.sketch.dataPath(filename));
            if (!file.exists()) {
                file = this.sketch.sketchFile(filename);
            }
            if (file.exists() && !file.isDirectory()) {
                try {
                    String filePath = file.getCanonicalPath();
                    String filenameActual = new File(filePath).getName();
                    String filenameShort = new File(filename).getName();
                    if (!filenameActual.equals(filenameShort)) {
                        throw new RuntimeException("This file is named " + filenameActual + " not " + filename + ". Rename the file or change your code.");
                    }
                }
                catch (IOException filePath) {
                    // empty catch block
                }
            }
            FileInputStream stream = new FileInputStream(file);
            ((InputStream)stream).close();
            return file.getCanonicalPath();
        }
        catch (IOException | SecurityException file) {
            InputStream stream;
            ClassLoader cl = this.sketch.getClass().getClassLoader();
            try {
                String cn;
                stream = cl.getResourceAsStream("data/" + filename);
                if (stream != null && !(cn = stream.getClass().getName()).equals("sun.plugin.cache.EmptyInputStream")) {
                    stream.close();
                    return "data/" + filename;
                }
                stream = cl.getResourceAsStream(filename);
                if (stream != null && !(cn = stream.getClass().getName()).equals("sun.plugin.cache.EmptyInputStream")) {
                    stream.close();
                    return filename;
                }
            }
            catch (IOException cn) {
                // empty catch block
            }
            try {
                try {
                    try {
                        String path = this.sketch.dataPath(filename);
                        stream = new FileInputStream(path);
                        stream.close();
                        return path;
                    }
                    catch (IOException path) {
                        try {
                            String path22 = this.sketch.sketchPath(filename);
                            stream = new FileInputStream(path22);
                            stream.close();
                            return path22;
                        }
                        catch (Exception path22) {
                            try {
                                stream = new FileInputStream(filename);
                                stream.close();
                                return filename;
                            }
                            catch (IOException path22) {
                            }
                        }
                    }
                }
                catch (SecurityException path22) {}
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return "";
        }
    }

    @Override
    public void placeWindow(int[] location, int[] editorLocation) {
        if (this.sketch.sketchFullScreen()) {
            return;
        }
        int x = this.window.getX() - this.window.getInsets().getLeftWidth();
        int y = this.window.getY() - this.window.getInsets().getTopHeight();
        int w = this.window.getWidth() + this.window.getInsets().getTotalWidth();
        int h = this.window.getHeight() + this.window.getInsets().getTotalHeight();
        if (location != null) {
            this.window.setTopLevelPosition(location[0], location[1]);
        } else if (editorLocation != null) {
            int locationX = editorLocation[0] - 20;
            int locationY = editorLocation[1];
            if (locationX - w > 10) {
                this.window.setTopLevelPosition(locationX - w, locationY);
            } else {
                locationX = (this.sketch.displayWidth - w) / 2;
                locationY = (this.sketch.displayHeight - h) / 2;
                this.window.setTopLevelPosition(locationX, locationY);
            }
        } else {
            this.window.setTopLevelPosition(this.screenRect.x + (this.screenRect.width - this.sketchWidth) / 2, this.screenRect.y + (this.screenRect.height - this.sketchHeight) / 2);
        }
        Point frameLoc = new Point(x, y);
        if (frameLoc.y < 0) {
            this.window.setTopLevelPosition(frameLoc.x, 30);
        }
    }

    @Override
    public void placePresent(int stopColor) {
        float scale = this.getPixelScale();
        this.pgl.initPresentMode(0.5f * ((float)this.screenRect.width / scale - (float)this.sketchWidth), 0.5f * ((float)this.screenRect.height / scale - (float)this.sketchHeight), stopColor);
        PApplet.hideMenuBar();
        this.window.setUndecorated(true);
        this.window.setTopLevelPosition((int)this.displayRect.getX(), (int)this.displayRect.getY());
        this.window.setTopLevelSize((int)this.displayRect.getWidth(), (int)this.displayRect.getHeight());
    }

    @Override
    public void setupExternalMessages() {
        this.external = true;
    }

    @Override
    public void startThread() {
        if (this.animator != null) {
            this.animator.start();
        }
    }

    @Override
    public void pauseThread() {
        if (this.animator != null) {
            this.animator.pause();
        }
    }

    @Override
    public void resumeThread() {
        if (this.animator != null) {
            this.animator.resume();
        }
    }

    @Override
    public boolean stopThread() {
        if (this.drawExceptionHandler != null) {
            this.drawExceptionHandler.interrupt();
            this.drawExceptionHandler = null;
        }
        if (this.animator != null) {
            return this.animator.stop();
        }
        return false;
    }

    @Override
    public boolean isStopped() {
        if (this.animator != null) {
            return !this.animator.isAnimating();
        }
        return true;
    }

    @Override
    public void setLocation(int x, int y) {
        this.display.getEDTUtil().invoke(false, () -> this.window.setTopLevelPosition(x, y));
    }

    @Override
    public void setSize(int wide, int high) {
        if (this.pgl.presentMode()) {
            return;
        }
        if (high <= 0) {
            high = 1;
        }
        if (wide <= 0) {
            wide = 1;
        }
        boolean changed = this.sketch.width != wide || this.sketch.height != high;
        this.sketchWidth = wide;
        this.sketchHeight = high;
        this.sketch.setSize(wide, high);
        this.graphics.setSize(wide, high);
        if (changed) {
            this.window.setSize(wide * this.windowScaleFactor, high * this.windowScaleFactor);
        }
    }

    public float getPixelScale() {
        if (this.graphics.pixelDensity == 1) {
            return 1.0f;
        }
        if (PApplet.platform == 2) {
            return this.getCurrentPixelScale();
        }
        return 2.0f;
    }

    private float getCurrentPixelScale() {
        this.window.getCurrentSurfaceScale(this.currentPixelScale);
        return this.currentPixelScale[0];
    }

    public Component getComponent() {
        return this.canvas;
    }

    public void setSmooth(int level) {
        this.pgl.reqNumSamples = level;
        GLCapabilities caps = new GLCapabilities(profile);
        caps.setAlphaBits(PGL.REQUESTED_ALPHA_BITS);
        caps.setDepthBits(PGL.REQUESTED_DEPTH_BITS);
        caps.setStencilBits(PGL.REQUESTED_STENCIL_BITS);
        caps.setSampleBuffers(true);
        caps.setNumSamples(this.pgl.reqNumSamples);
        caps.setBackgroundOpaque(true);
        caps.setOnscreen(true);
        NativeSurface target = this.window.getNativeSurface();
        MutableGraphicsConfiguration config = (MutableGraphicsConfiguration)target.getGraphicsConfiguration();
        config.setChosenCapabilities((CapabilitiesImmutable)caps);
    }

    @Override
    public void setFrameRate(float fps) {
        if (fps < 1.0f) {
            PGraphics.showWarning("The OpenGL renderer cannot have a frame rate lower than 1.\nYour sketch will run at 1 frame per second.");
            fps = 1.0f;
        } else if (fps > 1000.0f) {
            PGraphics.showWarning("The OpenGL renderer cannot have a frame rate higher than 1000.\nYour sketch will run at 1000 frames per second.");
            fps = 1000.0f;
        }
        if (this.animator != null) {
            this.animator.stop();
            this.animator.setFPS((int)fps);
            this.pgl.setFps(fps);
            this.animator.start();
        }
    }

    public void requestFocus() {
        this.display.getEDTUtil().invoke(false, () -> this.window.requestFocus());
    }

    protected void nativeMouseEvent(MouseEvent nativeEvent, int peAction) {
        int modifiers = nativeEvent.getModifiers();
        int peButton = 0;
        switch (nativeEvent.getButton()) {
            case 1: {
                peButton = 37;
                break;
            }
            case 2: {
                peButton = 3;
                break;
            }
            case 3: {
                peButton = 39;
            }
        }
        int peCount = peAction == 8 ? -(nativeEvent.isShiftDown() ? (int)nativeEvent.getRotation()[0] : (int)nativeEvent.getRotation()[1]) : nativeEvent.getClickCount();
        int scale = PApplet.platform == 2 ? (int)this.getCurrentPixelScale() : (int)this.getPixelScale();
        int sx = nativeEvent.getX() / scale;
        int sy = nativeEvent.getY() / scale;
        int mx = sx;
        int my = sy;
        if (this.pgl.presentMode()) {
            mx -= (int)this.pgl.presentX;
            my -= (int)this.pgl.presentY;
            if (peAction == 2 && this.pgl.insideStopButton(sx, sy - this.screenRect.height / this.windowScaleFactor)) {
                this.sketch.exit();
            }
            if (mx < 0 || this.sketchWidth < mx || my < 0 || this.sketchHeight < my) {
                return;
            }
        }
        processing.event.MouseEvent me = new processing.event.MouseEvent(nativeEvent, nativeEvent.getWhen(), peAction, modifiers, mx, my, peButton, peCount);
        this.sketch.postEvent(me);
    }

    protected void nativeKeyEvent(KeyEvent nativeEvent, int peAction) {
        char keyChar;
        int keyCode;
        int modifiers = nativeEvent.getModifiers();
        short code = nativeEvent.getKeyCode();
        if (PSurfaceJOGL.isPCodedKey(code)) {
            keyCode = PSurfaceJOGL.mapToPConst(code);
            keyChar = '\uffff';
        } else if (PSurfaceJOGL.isHackyKey(code)) {
            keyCode = code == 13 ? 10 : (int)code;
            keyChar = PSurfaceJOGL.hackToChar(code, nativeEvent.getKeyChar());
        } else {
            keyCode = code;
            keyChar = nativeEvent.getKeyChar();
        }
        processing.event.KeyEvent ke = new processing.event.KeyEvent(nativeEvent, nativeEvent.getWhen(), peAction, modifiers, keyChar, keyCode, nativeEvent.isAutoRepeat());
        this.sketch.postEvent(ke);
        if (!PSurfaceJOGL.isPCodedKey(code) && !PSurfaceJOGL.isHackyKey(code) && peAction == 1) {
            processing.event.KeyEvent tke = new processing.event.KeyEvent(nativeEvent, nativeEvent.getWhen(), 3, modifiers, keyChar, 0, nativeEvent.isAutoRepeat());
            this.sketch.postEvent(tke);
        }
    }

    private static boolean isPCodedKey(short code) {
        return code == 150 || code == 152 || code == 149 || code == 151 || code == 18 || code == 17 || code == 15 || code == 154;
    }

    private static int mapToPConst(short code) {
        switch (code) {
            case 150: {
                return 38;
            }
            case 152: {
                return 40;
            }
            case 149: {
                return 37;
            }
            case 151: {
                return 39;
            }
            case 18: {
                return 18;
            }
            case 17: {
                return 17;
            }
            case 15: {
                return 16;
            }
            case 154: {
                return 157;
            }
        }
        return code;
    }

    private static boolean isHackyKey(short code) {
        switch (code) {
            case 8: 
            case 9: 
            case 13: 
            case 27: 
            case 147: {
                return true;
            }
        }
        return false;
    }

    private static char hackToChar(short code, char def) {
        switch (code) {
            case 8: {
                return '\b';
            }
            case 9: {
                return '\t';
            }
            case 13: {
                return '\n';
            }
            case 27: {
                return '\u001b';
            }
            case 147: {
                return '\u007f';
            }
        }
        return def;
    }

    @Override
    public void setCursor(int kind) {
        String name;
        if (!cursorNames.containsKey(kind)) {
            PGraphics.showWarning("Unknown cursor type: " + kind);
            return;
        }
        CursorInfo cursor = cursors.get(kind);
        if (cursor == null && (name = cursorNames.get(kind)) != null) {
            ImageIcon icon = new ImageIcon(this.getClass().getResource("cursors/" + name + ".png"));
            PImageAWT img = new PImageAWT(icon.getImage());
            int x = img.width / 2;
            int y = img.height / 2;
            if (kind == 0) {
                x = 10;
                y = 7;
            } else if (kind == 12) {
                x = 12;
                y = 8;
            } else if (kind == 2) {
                x = 16;
                y = 22;
            }
            cursor = new CursorInfo(img, x, y);
            cursors.put(kind, cursor);
        }
        if (cursor != null) {
            cursor.set();
        } else {
            PGraphics.showWarning("Cannot load cursor type: " + kind);
        }
    }

    @Override
    public void setCursor(PImage image, int hotspotX, int hotspotY) {
        Display disp = this.window.getScreen().getDisplay();
        BufferedImage bimg = (BufferedImage)image.getNative();
        DataBufferInt dbuf = (DataBufferInt)bimg.getData().getDataBuffer();
        int[] ipix = dbuf.getData();
        ByteBuffer pixels = ByteBuffer.allocate(ipix.length * 4);
        pixels.asIntBuffer().put(ipix);
        PixelFormat format = PixelFormat.ARGB8888;
        Dimension size = new Dimension(bimg.getWidth(), bimg.getHeight());
        PixelRectangle.GenericPixelRect pixelrect = new PixelRectangle.GenericPixelRect(format, (DimensionImmutable)size, 0, false, pixels);
        Display.PointerIcon pi = disp.createPointerIcon((PixelRectangle)pixelrect, hotspotX, hotspotY);
        this.display.getEDTUtil().invoke(false, () -> {
            this.window.setPointerVisible(true);
            this.window.setPointerIcon(pi);
        });
    }

    @Override
    public void showCursor() {
        this.display.getEDTUtil().invoke(false, () -> this.window.setPointerVisible(true));
    }

    @Override
    public void hideCursor() {
        this.display.getEDTUtil().invoke(false, () -> this.window.setPointerVisible(false));
    }

    @Override
    public boolean openLink(String url) {
        return ShimAWT.openLink(url);
    }

    static {
        cursors = new HashMap<Integer, CursorInfo>();
        cursorNames = new HashMap<Integer, String>();
        cursorNames.put(0, "arrow");
        cursorNames.put(1, "cross");
        cursorNames.put(3, "wait");
        cursorNames.put(13, "move");
        cursorNames.put(12, "hand");
        cursorNames.put(2, "text");
    }

    class CursorInfo {
        PImage image;
        int x;
        int y;

        CursorInfo(PImage image, int x, int y) {
            this.image = image;
            this.x = x;
            this.y = y;
        }

        void set() {
            PSurfaceJOGL.this.setCursor(this.image, this.x, this.y);
        }
    }

    protected class NEWTKeyListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent e) {
            PSurfaceJOGL.this.nativeKeyEvent(e, 1);
        }

        public void keyReleased(KeyEvent e) {
            PSurfaceJOGL.this.nativeKeyEvent(e, 2);
        }

        public void keyTyped(KeyEvent e) {
            PSurfaceJOGL.this.nativeKeyEvent(e, 3);
        }
    }

    protected class NEWTMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            PSurfaceJOGL.this.nativeMouseEvent(e, 1);
        }

        public void mouseReleased(MouseEvent e) {
            PSurfaceJOGL.this.nativeMouseEvent(e, 2);
        }

        public void mouseClicked(MouseEvent e) {
            PSurfaceJOGL.this.nativeMouseEvent(e, 3);
        }

        public void mouseDragged(MouseEvent e) {
            PSurfaceJOGL.this.nativeMouseEvent(e, 4);
        }

        public void mouseMoved(MouseEvent e) {
            PSurfaceJOGL.this.nativeMouseEvent(e, 5);
        }

        public void mouseWheelMoved(MouseEvent e) {
            PSurfaceJOGL.this.nativeMouseEvent(e, 8);
        }

        public void mouseEntered(MouseEvent e) {
            PSurfaceJOGL.this.nativeMouseEvent(e, 6);
        }

        public void mouseExited(MouseEvent e) {
            PSurfaceJOGL.this.nativeMouseEvent(e, 7);
        }
    }

    protected class NEWTWindowListener
    implements WindowListener {
        public void windowGainedFocus(WindowEvent arg0) {
            PSurfaceJOGL.this.sketch.focused = true;
            PSurfaceJOGL.this.sketch.focusGained();
        }

        public void windowLostFocus(WindowEvent arg0) {
            PSurfaceJOGL.this.sketch.focused = false;
            PSurfaceJOGL.this.sketch.focusLost();
        }

        public void windowDestroyNotify(WindowEvent arg0) {
            PSurfaceJOGL.this.sketch.exit();
        }

        public void windowDestroyed(WindowEvent arg0) {
            PSurfaceJOGL.this.sketch.exit();
        }

        public void windowMoved(WindowEvent arg0) {
            if (PSurfaceJOGL.this.external) {
                PSurfaceJOGL.this.sketch.frameMoved(PSurfaceJOGL.this.window.getX(), PSurfaceJOGL.this.window.getY());
            }
        }

        public void windowRepaint(WindowUpdateEvent arg0) {
        }

        public void windowResized(WindowEvent arg0) {
        }
    }

    class DrawListener
    implements GLEventListener {
        DrawListener() {
        }

        public void display(GLAutoDrawable drawable) {
            if (PSurfaceJOGL.this.display.getEDTUtil().isCurrentThreadEDT()) {
                return;
            }
            if (PSurfaceJOGL.this.sketch.frameCount == 0) {
                if (PSurfaceJOGL.this.sketchWidth < PSurfaceJOGL.this.sketchWidth0 || PSurfaceJOGL.this.sketchHeight < PSurfaceJOGL.this.sketchHeight0) {
                    PGraphics.showWarning("The sketch has been automatically resized to fit the screen resolution");
                }
                PSurfaceJOGL.this.requestFocus();
            }
            if (!PSurfaceJOGL.this.sketch.finished) {
                PSurfaceJOGL.this.pgl.getGL(drawable);
                int pframeCount = PSurfaceJOGL.this.sketch.frameCount;
                PSurfaceJOGL.this.sketch.handleDraw();
                if (pframeCount == PSurfaceJOGL.this.sketch.frameCount || PSurfaceJOGL.this.sketch.finished) {
                    PSurfaceJOGL.this.pgl.beginRender();
                    PSurfaceJOGL.this.pgl.endRender(PSurfaceJOGL.this.sketch.sketchWindowColor());
                }
                PGraphicsOpenGL.completeFinishedPixelTransfers();
            }
            if (PSurfaceJOGL.this.sketch.exitCalled()) {
                PGraphicsOpenGL.completeAllPixelTransfers();
                PSurfaceJOGL.this.sketch.dispose();
                PSurfaceJOGL.this.sketch.exitActual();
            }
        }

        public void dispose(GLAutoDrawable drawable) {
        }

        public void init(GLAutoDrawable drawable) {
            PSurfaceJOGL.this.pgl.getGL(drawable);
            PSurfaceJOGL.this.pgl.init(drawable);
            PSurfaceJOGL.this.sketch.start();
            int c = PSurfaceJOGL.this.graphics.backgroundColor;
            PSurfaceJOGL.this.pgl.clearColor((float)(c >> 16 & 0xFF) / 255.0f, (float)(c >> 8 & 0xFF) / 255.0f, (float)(c & 0xFF) / 255.0f, (float)(c >> 24 & 0xFF) / 255.0f);
            PSurfaceJOGL.this.pgl.clear(PGL.COLOR_BUFFER_BIT);
        }

        public void reshape(GLAutoDrawable drawable, int x, int y, int w, int h) {
            PSurfaceJOGL.this.pgl.resetFBOLayer();
            PSurfaceJOGL.this.pgl.getGL(drawable);
            float scale = PApplet.platform == 2 ? PSurfaceJOGL.this.getCurrentPixelScale() : PSurfaceJOGL.this.getPixelScale();
            PSurfaceJOGL.this.setSize((int)((float)w / scale), (int)((float)h / scale));
        }
    }
}

