#version 330 core

in vec2 texCoord;
in vec4 vertexFragColor;
out vec4 fragColor;
uniform sampler2D texture0;
uniform vec4 color = vec4(0,0,0,1);
uniform float fadeEnd = 0.4;

void main()
{
    vec2 coord = texCoord;
    vec2 screenCoords = coord;
    float fade = 1.0;

    float fadeStart = 0.1;
    
    fade = min(smoothstep(fadeStart, fadeEnd, distance(coord.x,0.5))+smoothstep(0.4, 0.8, distance(coord.y,0.5)),1.0);

    vec4 color1 = color;
    color1 *= vec4(0,0,0,fade);


    fragColor = color1;
}
