
var gl = new WebGL2RenderingContext(); //enable WebGL 2 partial support

var images = {};
var warPos=[200,-50,-40,-110,-100,-50,200];
var bpm=170/60;
var beat = bpm/8;
var tick= beat/8;

var pattern = 8*beat;
var postCreditsTime=47.5*pattern;

var particleMesh = void null;
var fftImage = new Image();
	

function additive(animation) {
	glPushMatrix();     
    gl.enable(gl.BLEND);
	gl.blendFunc(gl.ONE, gl.ONE);
	glPopMatrix();
}

function normal(animation) {
	glPushMatrix();     
	gl.enable(gl.BLEND);
	//gl.blendFunc(gl.ONE, gl.ONE);
	glPopMatrix();
}
	
function blendAdd(animation) {
	gl.enable(gl.DEPTH_TEST);
	gl.depthMask(0);
	gl.enable(gl.BLEND);
	//gl.blendFunc(gl.ONE, gl.ONE);
	gl.blendFunc(gl.SRC_ALPHA, gl.ONE_MINUS_SRC_ALPHA);
}

function blendNormal(animation) {
	gl.enable(gl.BLEND);
	gl.blendFunc(gl.SRC_ALPHA, gl.ONE_MINUS_SRC_ALPHA);
}


Demo.prototype.init = function()
{

	Sync.addSync(
	[
		{ "name":"Char1MainPos", "type":"rocket" },
		{ "name":"Char1LegPos", "type":"rocket" },
		{ "name":"Char1ArmPos", "type":"rocket" },
		{ "name":"Char1HeadPos", "type":"rocket" },
		{ "name":"Char1MainRot", "type":"rocket" },
		{ "name":"Char1ArmRot", "type":"rocket" },
		{ "name":"Char1HeadRot", "type":"rocket" },
		{ "name":"Char1LegRot", "type":"rocket" },
		{ "name":"Char2MainPos", "type":"rocket" },
		{ "name":"Char2LegPos", "type":"rocket" },
		{ "name":"Char2ArmPos", "type":"rocket" },
		{ "name":"Char2HeadPos", "type":"rocket" },
		{ "name":"Char2MainRot", "type":"rocket" },
		{ "name":"Char2ArmRot", "type":"rocket" },
		{ "name":"Char2HeadRot", "type":"rocket" },
		{ "name":"Char2LegRot", "type":"rocket" },
		{ "name":"TunnelSpeed", "type":"rocket" },
		{ "name":"PinjataPos", "type":"rocket" },
		{ "name":"ViiriPos", "type":"rocket" },
		{ "name":"ViiriScroll", "type":"rocket" },
		{ "name":"PinjataSize", "type":"rocket" },
		{ "name":"HappyAlpha", "type":"rocket" },
		{ "name":"BdayAlpha", "type":"rocket" },
		{ "name":"Flash", "type":"rocket" }
	]);

	
    var start = 0;
    var duration = 60*20;

	//fftImage.load("fft0");
	
	//fbot
	this.createFBO(00000,20000,"fbolut");
	
	this.createFBO(20001,30000,"fbo30k");
	 this.createFBO(30003,40000,"fbo40k");
	//debugPrint(666);
	
	

	this.loader.addAnimation ([
	{
	 "start": 0, "duration": 8888
	,"image": ["fbolut.color.fbo","2dlut.png"]
	,"layer": 20105

	}]);
	
   	this.loader.addAnimation ([
	{
	"start": 0, "duration": 8888
	,"image": ["fbo30k.color.fbo", "fft0"]
	,"scale":[{"uniform3d":1.0}]
	,"layer": 31208
	,"position":[{"x":640,"y":360}]

	,"shader":{"name":["edge.fs"]}
	}]);	 
	
	this.loader.addAnimation ([
	{
	 "start": 0, "duration": 88888
	,"image": ["fbo40k.color.fbo"]
	,"layer": 50105
	,"position":[{"x":640,"y":360}
		]
	,"scale":[{"uniform3d":1.0}]

//	,"shader":{"name":["blur.fs"]}

	}]);
	


	this.texts1(0);
		this.texts2(24.9*pattern);
		this.texts2(36.9*pattern);
	this.tunnelbg(0);
	this.raver(0,2);
	this.raver2(0,2);
	this.viiri(0);
	this.confetti(13*pattern);
	this.ground(0);
	this.happy(0);
	this.flash(0);
	this.end(41*pattern);
	this.gift(25*pattern);
	this.pinjataBounce(21*pattern);
/*
    this.loader.addAnimation({
         "start": start, "duration": duration,"layer": 10000
        ,"image": "fft0"
		,"shader":{"name":["singleblockfft.fs"]}

    });
*/
}

Demo.prototype.happy = function (startTime)
{
	
		this.loader.addAnimation([
		{
		 "start": startTime, "duration":99999
		,"layer": 1850, "image": ["data/happy.png"]
		,"scale":[{"x":"{return 2+Math.sin(getSceneTimeFromStart())}","y":"{return 2+Math.sin(getSceneTimeFromStart())}"}]
		,"color":[{"r":255,"g":255,"b":255,"a":"{return Sync.getSyncValue('HappyAlpha')}"}]
		}]);
		
		this.loader.addAnimation([
		{
		 "start": startTime, "duration":99999
		,"layer": 1850, "image": ["data/birthday.png"]
		,"scale":[{"x":"{return 2+Math.sin(getSceneTimeFromStart())}","y":"{return 2+Math.sin(getSceneTimeFromStart())}"}]
		,"color":[{"r":255,"g":255,"b":255,"a":"{return Sync.getSyncValue('BdayAlpha')}"}]
		}]);
}
		
Demo.prototype.texts2 = function (startTime)
{
	
	for(i=0;i<4;i++)
	{
		this.loader.addAnimation([
		{
		 "start": startTime+i*pattern, "duration":99999
		,"layer": 1250, "image": ["data/happy.png"]
		,"scale":[{"x":2.0,"y":2.0}]
		,"position":[{"x":3000,"y":780}
		,{"duration":4*beat,"x":-1100}]
		}]);

		this.loader.addAnimation([
		{
		 "start": startTime+beat*1.25+i*pattern, "duration":99999
		,"layer": 1250, "image": ["data/birthday.png"]
		,"scale":[{"x":2.0,"y":2.0}]
		,"position":[{"x":3000,"y":780}
		,{"duration":5.8*beat,"x":-1000}]
		}]);
		
		this.loader.addAnimation([
		{
		 "start": startTime+3*beat+i*pattern, "duration":99999
		,"layer": 1250, "image": ["data/to.png"]
		,"scale":[{"x":2.0,"y":2.0}]
		,"position":[{"x":3000,"y":780}
		,{"duration":6*beat,"x":-1000}]
		}]);
		
		this.loader.addAnimation([
		{
		 "start": startTime+4*beat+i*pattern, "duration":99999
		,"layer": 1250, "image": ["data/you.png"]
		,"scale":[{"x":2.0,"y":2.0}]
		,"position":[{"x":3200,"y":780}
		,{"duration":6*beat,"x":-1000}]
		}]);
	}
	
}

Demo.prototype.texts1 = function (startTime)
{
	
	for(i=0;i<4;i++)
	{
		this.loader.addAnimation([
		{
		 "start": startTime+i*pattern, "duration":99999
		,"layer": 1250, "image": ["data/happy.png"]
		,"scale":[{"x":2.0,"y":2.0}]
		,"position":[{"x":3000,"y":780}
		,{"duration":4*beat,"x":-1100}]
		}]);

		this.loader.addAnimation([
		{
		 "start": startTime+beat*1.25+i*pattern, "duration":99999
		,"layer": 1250, "image": ["data/birthday.png"]
		,"scale":[{"x":2.0,"y":2.0}]
		,"position":[{"x":3000,"y":780}
		,{"duration":5.8*beat,"x":-1000}]
		}]);
		
		this.loader.addAnimation([
		{
		 "start": startTime+3*beat+i*pattern, "duration":99999
		,"layer": 1250, "image": ["data/to.png"]
		,"scale":[{"x":2.0,"y":2.0}]
		,"position":[{"x":3000,"y":780}
		,{"duration":6*beat,"x":-1000}]
		}]);
		
		if(i<3)
		{	
			this.loader.addAnimation([
			{
			 "start": startTime+4*beat+i*pattern, "duration":99999
			,"layer": 1250, "image": ["data/you.png"]
			,"scale":[{"x":2.0,"y":2.0}]
			,"position":[{"x":3200,"y":780}
			,{"duration":6*beat,"x":-1000}]
			}]);
		} else
		{
			this.loader.addAnimation([
			{
			 "start": startTime+4*beat+i*pattern, "duration":99999
			,"layer": 1250, "image": ["data/youu.png"]
			,"scale":[{"x":2.0,"y":2.0}]
			,"position":[{"x":9500,"y":780}
			,{"duration":1*pattern+5*beat,"x":-6000}]
			}]);
		}
	}
	
}

Demo.prototype.viiri = function (startTime)
{
		this.loader.addAnimation([
    {
         "start": 0, "duration":99999
        ,"layer": 0
		,"object":"viiri2.obj"
		,"position":[{"z":-1,"x":0,"y":"{return Sync.getSyncValue('ViiriPos')+.3*Math.sin(getSceneTimeFromStart())}"}]
		,"scale":[{"uniform3d":.352}]
        ,"layer": 1002
		,"angle": [{"degreesX":-90}]
		,"shader":{
            "name":["scroll.fs"],
            "variable":[
                  {"name":"tim3","value":["{return Sync.getSyncValue('ViiriScroll')*getSceneTimeFromStart()}"]}
			]
        }
	}]);
	
	this.loader.addAnimation([
    {
         "start": 0, "duration":99999
        ,"layer": 0
		,"object":"viiri.obj"
		,"position":[{"z":-1,"x":0,"y":"{return Sync.getSyncValue('ViiriPos')+.3*Math.sin(getSceneTimeFromStart())}"}]
		,"scale":[{"uniform3d":.352}]
        ,"layer": 1002
		,"angle": [{"degreesX":-90}]
		,"shader":{
            "name":["scroll.fs"],
            "variable":[
                  {"name":"tim3","value":["{return Sync.getSyncValue('ViiriScroll')*getSceneTimeFromStart()}"]}
			]
        }
	}]);
}

Demo.prototype.confetti = function (startTime)
{
	for(i=0;i<180;i++)	
	{
		for (ii=0;ii<10;ii++)
		{
			this.loader.addAnimation([
			{	
				 "start": i*beat+startTime, "duration":.5*pattern
				,"layer": 0,
				"image": "data/confetti_"+Math.floor(1+Math.random()*7)+".png"
				,"angle": [{"degreesZ":Math.random()*720-360}
				,{"duration":.5*pattern,"degreesZ":Math.random()*720-360}]
				,"position":[{"x":Math.random()*1920,"y":1080+200+Math.random()*500}
				,{"duration":.5*pattern-Math.random()*.3*pattern,"y":-500-Math.random()*100}]
				,"scale":[{"uniform3d":Math.random()*1.5+.35}]
			}]);
		}
	}
}
Demo.prototype.gift = function (startTime)
{

		for (ii=0;ii<94;ii++)
		{
			this.loader.addAnimation([
			{	
				 "start": ii*beat+startTime, "duration":4*pattern
				,"layer": 110,
				"image": "data/gift.png"
				,"angle": [{"degreesZ":Math.random()*60-30}]
				,"position":[{"x":-940,"y":580}
				,{"duration":.5*pattern,"x":2840}]
				,"scale":[{"uniform3d":Math.random()*1.5+.35}]
			}]);
		}
	
}
Demo.prototype.whitebg = function (startTime)
{
	this.loader.addAnimation([
    {
         "start": 0, "duration":99999
        ,"layer": 0, "image": ["data/white.png"]
		,"scale":[{"x":15.0,"y":15.0}]
		,"color":[{"r":120,"g":120,"b":120,"a":255}]
		}
	]);
}

Demo.prototype.end = function (startTime)
{
	this.loader.addAnimation([
    {
         "start": startTime, "duration":99999
        ,"layer": 9001, "image": ["data/jml22.png"]
		,"scale":[{"x":15.0,"y":15.0}]

		}
	]);
}

Demo.prototype.flash = function (startTime)
{
	this.loader.addAnimation([
    {
         "start": 0, "duration":99999
        ,"layer": 9000, "image": ["data/white.png"]
		,"scale":[{"x":15.0,"y":15.0}]
		,"color":[{"r":"{return Sync.getSyncValue('Flash')}","g":"{return Sync.getSyncValue('Flash')}","b":"{return Sync.getSyncValue('Flash')}","a":"{return Sync.getSyncValue('Flash')}"}]
		}
	]);
}

Demo.prototype.ground = function (startTime)
{
	this.loader.addAnimation([
    {
         "start": 0, "duration":99999
        ,"layer": 10, "image": ["data/ground.png"]
		,"scale":[{"x":1.75,"y":1.60}]
		,"color":[{"r":255,"g":255,"b":255,"a":255}]
		,"position":[{"x":1000,"y":-15}]
		,"shader":{
            "name":["mirrorscroll2.fs"],
            "variable":[
                  {"name":"tim3","value":["{return Sync.getSyncValue('ViiriScroll')*getSceneTimeFromStart()}"]}
			]
        }
		}
	]);
}

Demo.prototype.tunnelbg = function (startTime)
{
	this.loader.addAnimation([
    {
         "start": 0, "duration":99999
        ,"layer": 0, "image": ["data/background.png"]
		,"scale":[{"x":1.95,"y":1.95}]
		,"shader":{
            "name":["tunnel.fs"],
            "variable":[
                  {"name":"tim3","value":["{return Sync.getSyncValue('TunnelSpeed')*getSceneTimeFromStart()}"]}
			]
        }
	}]);
}
Demo.prototype.raver = function (startTime,raverPosX)
{
	this.loader.addAnimation([{
		"start": startTime, "duration": 48*pattern
		,"object":"raver.obj"
        ,"layer": 1002
		,"position":[{"z":-.5,"x":.5,"y":"{return -.4+Sync.getSyncValue('Char1MainPos');}"}]
		,"angle": [{"degreesY":0,"degreesX":-90}
		,{"duration":8*pattern,"degreesY":0}]
		,"nodes": {
            "head_Plane.003": {
				"position":[{"z":"{return Sync.getSyncValue('Char1HeadPos');}","x":0,"y":0}]
                ,"angle": [{"degreesY":"{return Sync.getSyncValue('Char1HeadRot');}"}]
            },
			"lhand_Plane.010": {
				"position":[{"z":"{return 0.05+Sync.getSyncValue('Char1ArmPos');}","x":-0.18,"y":0}]
                ,"angle": [{"degreesY":"{return Sync.getSyncValue('Char1ArmRot');}"}]
            },
			"rhand_Plane.009": {
				"position":[{"z":"{return 0.05+Sync.getSyncValue('Char1ArmPos');}","x":.18,"y":0}]
                ,"angle": [{"degreesY":"{return -Sync.getSyncValue('Char1ArmRot');}"}]
            },
			"legs_Plane.012": {
				"position":[{"z":"{return 0.23+Sync.getSyncValue('Char1LegPos');}","x":0.01,"y":0}]
                ,"angle": [{"degreesY":"{return Sync.getSyncValue('Char1LegRot');}"}]
            }
        }
    }]);
}

Demo.prototype.raver2 = function (startTime,raverPosX)
{
	this.loader.addAnimation([{
		"start": startTime, "duration": 48*pattern
		,"object":"raver2.obj"
        ,"layer": 1002
		,"position":[{"z":-.5,"x":-.5,"y":"{return -.4+Sync.getSyncValue('Char1MainPos');}"}]
		,"angle": [{"degreesY":0,"degreesX":-90}
		,{"duration":8*pattern,"degreesY":0}]
		,"nodes": {
            "head2_Plane.002": {
				"position":[{"z":"{return 0.01+Sync.getSyncValue('Char1HeadPos');}","x":0.01,"y":0}]
                ,"angle": [{"degreesY":"{return Sync.getSyncValue('Char1HeadRot');}"}]
            },
			"lhand2_Plane.005": {
				"position":[{"z":"{return 0.05+Sync.getSyncValue('Char1ArmPos');}","x":-0.13,"y":-.01}]
                ,"angle": [{"degreesY":"{return Sync.getSyncValue('Char1ArmRot');}"}]
            },
			"rhand2_Plane.004": {
				"position":[{"z":"{return 0.05+Sync.getSyncValue('Char1ArmPos');}","x":.13,"y":-.01}]
                ,"angle": [{"degreesY":"{return -Sync.getSyncValue('Char1ArmRot');}"}]
            },
			"legs2_Plane.013": {
				"position":[{"z":"{return 0.2+Sync.getSyncValue('Char1LegPos');}","x":0.01,"y":-.01}]
                ,"angle": [{"degreesY":"{return Sync.getSyncValue('Char1LegRot');}"}]
            }
        }
    }]);
}


Demo.prototype.pinjataBounce = function (startTime)
{
	this.loader.addAnimation([{
		"start": startTime, "duration": 8*pattern
		,"object":"pinata.obj"
        ,"layer": 5002
		,"scale":[{"uniform3d":"{return .2*Sync.getSyncValue('PinjataSize');}"}]
		,"position":[{"z":0,"x":0,"y":0}]
		,"angle": [{"degreesZ":9000,"degreesX":-90}
		,{"duration":8*pattern,"degreesZ":-9000}]
    }]);
}

Demo.prototype.createFBO = function (startLayer, endLayer, name)
{
   	this.loader.addAnimation ([
	{
		"start": 0, "duration": 99999
		,"layer": startLayer
		,"fbo":{"name":name,"action":"begin","storeDepth":true}
	}
	]);
	
	this.loader.addAnimation ([
	{
		"start": 0, "duration": 99999
		,"layer": endLayer,"fbo":{"name":name,"action":"unbind"}
	}
	]);
	
}

Demo.prototype.explosion = function (startTime, posx, posy)
{
	for(i=0;i<54;i++)
	{
			this.loader.addAnimation([{
			 "start": startTime, "duration": 2*pattern,"layer": 9000
			,"image": "explo.png"
					,"color":[{"r":0,"g":0,"b":0,"a":255}
		,{"duration":2*pattern,"a":0}]
			,"scale":[{"uniform3d":Math.random()*.5+.25}
			,{"duration":2*pattern,"uniform3d":0}]
			,"angle":[{"degreesZ":Math.random()*360}
			,{"duration":2*pattern,"degreesZ":Math.random()*360}
			]
			,"position":[{"x":posx+Math.random()*33,"y":posy+Math.random()*300,"z":0}
			,{"duration":2*pattern,"x":Math.random()*1280*2,"y":Math.random()*720*2-222,"z":-1+Math.random()*2}
			]
			}]);
	}
	
		for(i=0;i<54;i++)
	{
			this.loader.addAnimation([{
			 "start": startTime, "duration": 2*pattern,"layer": 49000
			,"image": "explo.png"
					,"color":[{"r":0,"g":0,"b":0,"a":255}
		,{"duration":2*pattern,"a":0}]
			,"scale":[{"uniform3d":Math.random()*.5+.25}
			,{"duration":2*pattern,"uniform3d":0}]
			,"angle":[{"degreesZ":Math.random()*360}
			,{"duration":2*pattern,"degreesZ":Math.random()*360}
			]
			,"position":[{"x":posx+Math.random()*33,"y":posy+Math.random()*300,"z":0}
			,{"duration":2*pattern,"x":Math.random()*1280*2,"y":Math.random()*720*2-222,"z":-1+Math.random()*2}
			]
			}]);
	}
	
}