const Symbols = function(){
    PartBase.call(this);

    this.setEdgeDetection();
    this.setBloom(1.0);

    this.symbol = this.createSprite();
    this.symbol.scale.set(50, 50, 1);
    this.scene.add(this.symbol);
};

Symbols.prototype = PartBase.prototype.inheritance();

Symbols.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta, true);

    const pos = TDEMO.SYNC.getObjPosition();
    this.symbol.position.x = pos.x;
    this.symbol.position.y = pos.y;
    this.symbol.position.z = pos.z;

    const edges = TDEMO.SYNC.getEdges();
    this.edge.enabled = edges;
};

Symbols.prototype.createSprite = function(){
    const material = new THREE.SpriteMaterial({
        map : TDEMO.TEXTURES.getTextures().ak11,
        color: 0xFF00AA,
        transparent: true,
        opacity: 0.8,
        blending: THREE.AdditiveBlending,
    });

    const sprite = new THREE.Sprite(material);
    return sprite;
}