/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.sound.sampled.Clip;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010,\u001a\u00020-H\u0016J\u0018\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u00020\f2\u0006\u00100\u001a\u00020\"H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\fX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\fX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0019\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001e\u0010!\u001a\u0004\u0018\u00010\"X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010'\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0011\u0010(\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+\u00a8\u00061"}, d2={"LSyncTestEffect;", "LEffect;", "()V", "bg", "", "getBg", "()[B", "bleep", "Ljavax/sound/sampled/Clip;", "getBleep", "()Ljavax/sound/sampled/Clip;", "circleCols", "", "getCircleCols", "()I", "circleR", "getCircleR", "circleRows", "getCircleRows", "colors", "", "LTeletextColor;", "getColors", "()Ljava/util/List;", "g", "Ljava/awt/Graphics2D;", "kotlin.jvm.PlatformType", "getG", "()Ljava/awt/Graphics2D;", "img", "Ljava/awt/image/BufferedImage;", "getImg", "()Ljava/awt/image/BufferedImage;", "lastLastElapsed", "", "getLastLastElapsed", "()Ljava/lang/Double;", "setLastLastElapsed", "(Ljava/lang/Double;)V", "Ljava/lang/Double;", "page", "LTeletextPage;", "getPage", "()LTeletextPage;", "doReset", "", "doTick", "ticks", "elapsed", "teletext-tools"})
public final class SyncTestEffect
extends Effect {
    private final int circleR;
    private final int circleCols;
    private final int circleRows;
    @NotNull
    private final BufferedImage img;
    private final Graphics2D g;
    @NotNull
    private final List<TeletextColor> colors;
    @NotNull
    private final byte[] bg;
    @NotNull
    private final TeletextPage page;
    @Nullable
    private Double lastLastElapsed;
    @NotNull
    private final Clip bleep;

    public SyncTestEffect() {
        super("Sync test");
        this.circleR = 42;
        this.circleCols = this.circleR / 2;
        this.circleRows = this.circleR / 3;
        this.img = new BufferedImage(this.circleR, this.circleR, 1);
        this.g = this.img.createGraphics();
        TeletextColor[] teletextColorArray = new TeletextColor[]{TeletextColor.RED, TeletextColor.YELLOW, TeletextColor.GREEN, TeletextColor.WHITE, TeletextColor.BLUE, TeletextColor.MAGENTA, TeletextColor.CYAN};
        this.colors = CollectionsKt.listOf(teletextColorArray);
        this.bg = FilesKt.readBytes(new File("gfx/refresh-test.bin"));
        this.page = new TeletextPage(null, 1, null);
        this.bleep = new AudioOutput().prepareClip("sfx/blip.wav");
    }

    public final int getCircleR() {
        return this.circleR;
    }

    public final int getCircleCols() {
        return this.circleCols;
    }

    public final int getCircleRows() {
        return this.circleRows;
    }

    @NotNull
    public final BufferedImage getImg() {
        return this.img;
    }

    public final Graphics2D getG() {
        return this.g;
    }

    @NotNull
    public final List<TeletextColor> getColors() {
        return this.colors;
    }

    @NotNull
    public final byte[] getBg() {
        return this.bg;
    }

    @NotNull
    public final TeletextPage getPage() {
        return this.page;
    }

    @Nullable
    public final Double getLastLastElapsed() {
        return this.lastLastElapsed;
    }

    public final void setLastLastElapsed(@Nullable Double d) {
        this.lastLastElapsed = d;
    }

    @NotNull
    public final Clip getBleep() {
        return this.bleep;
    }

    @Override
    public void doReset() {
    }

    @Override
    public void doTick(int ticks, double elapsed) {
        this.page.takeDataFrom(this.bg);
        int amp = this.circleR / 2;
        int cx = this.img.getWidth() / 2;
        int cy = this.img.getHeight() / 2;
        this.g.setColor(Color.WHITE);
        this.g.fillRect(0, 0, this.img.getWidth(), this.img.getHeight());
        this.g.setColor(Color.BLACK);
        this.g.fillArc(0, 0, this.circleR - 1, this.circleR - 1, 0, 360);
        int toX = (int)Math.round((double)amp * Math.sin(Math.PI * 2 * -(0.5 + elapsed % 1.0)));
        int toY = (int)Math.round((double)amp * Math.cos(Math.PI * 2 * -(0.5 + elapsed % 1.0)));
        this.g.setColor(Color.WHITE);
        this.g.drawLine(cx, cy, cx + toX, cy + toY);
        this.g.drawLine(cx + 1, cy, cx + toX + 1, cy + toY);
        this.g.drawLine(cx, cy + 1, cx + toX, cy + toY + 1);
        this.g.drawLine(cx + 1, cy + 1, cx + toX + 1, cy + toY + 1);
        byte[] cBuf = ImageUtilsKt.convertImage(this.img, 32, this.circleCols, this.circleRows, null, false);
        int n = this.circleRows;
        for (int y = 0; y < n; ++y) {
            int n2 = this.circleCols;
            for (int x = 0; x < n2; ++x) {
                this.page.set(1 + x, 6 + y, cBuf[this.circleCols * y + x]);
            }
        }
        TeletextColor col = this.colors.get((int)elapsed % this.colors.size());
        for (int y = 6; y < 20; ++y) {
            this.page.set(0, y, 0x10 | col.ordinal());
        }
        int dotPos = MathKt.roundToInt(GlobalsKt.lerp(elapsed % 1.0, 2.0, 38.0));
        this.page.set(dotPos, 22, 127);
        String fpsString = null;
        Double reference = this.lastLastElapsed;
        if (reference == null) {
            fpsString = "?";
        } else {
            double elapsedSinceLastTick = elapsed - reference;
            double fps = 2.0 / elapsedSinceLastTick;
            String string = "%3.1f";
            Object[] objectArray = new Object[]{fps};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(this, *args)");
            fpsString = string2;
        }
        String elapsedSinceLastTick = "%5s";
        Object[] objectArray = new Object[]{fpsString};
        String string = String.format(elapsedSinceLastTick, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string, "format(this, *args)");
        this.page.drawString(35, 6, string);
        elapsedSinceLastTick = "%5d";
        objectArray = new Object[]{ticks};
        String string3 = String.format(elapsedSinceLastTick, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(this, *args)");
        this.page.drawString(35, 7, string3);
        elapsedSinceLastTick = "%5s";
        objectArray = new Object[1];
        String fps = "%3.1f";
        Object[] objectArray2 = new Object[]{elapsed};
        Intrinsics.checkNotNullExpressionValue(String.format(fps, Arrays.copyOf(objectArray2, objectArray2.length)), "format(this, *args)");
        String string4 = String.format(elapsedSinceLastTick, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string4, "format(this, *args)");
        this.page.drawString(35, 8, string4);
        double second = elapsed % 1.0;
        Double d = this.getLastElapsed();
        double lastSecond = (d != null ? d : 0.9) % 1.0;
        if (second < lastSecond) {
            this.bleep.setMicrosecondPosition(0L);
            this.bleep.start();
        }
        this.lastLastElapsed = this.getLastElapsed();
        this.setLastElapsed(elapsed);
        int code = ticks % 96 + 32;
        for (int x = 25; x < 40; ++x) {
            this.page.set(x, 17, code);
            if (++code <= 127) continue;
            code = 32;
        }
        BuffersAndEncodingKt.formatAsPage(this.page.getData(), 256, this.getBuf());
    }
}

