/*
 * Decompiled with CFR 0.152.
 */
import composite.BlendComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0006\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010)\u001a\u00020\tJ\u0018\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\u0019H\u0002J\u000e\u0010-\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020/R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014Ra\u0010\u0015\u001aI\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u001a\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(\u00a8\u00060"}, d2={"LPlasmaRenderer;", "", "dots", "", "LMovingThing;", "useBrightness", "", "(Ljava/util/List;Z)V", "canvasScaledUp", "Ljava/awt/image/BufferedImage;", "getCanvasScaledUp", "()Ljava/awt/image/BufferedImage;", "getDots", "()Ljava/util/List;", "setDots", "(Ljava/util/List;)V", "g", "Ljava/awt/Graphics2D;", "kotlin.jvm.PlatformType", "getG", "()Ljava/awt/Graphics2D;", "overlayRenderBeforeRastering", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "", "w", "h", "", "getOverlayRenderBeforeRastering", "()Lkotlin/jvm/functions/Function3;", "setOverlayRenderBeforeRastering", "(Lkotlin/jvm/functions/Function3;)V", "page", "LTeletextPage;", "getPage", "()LTeletextPage;", "getUseBrightness", "()Z", "setUseBrightness", "(Z)V", "paint", "scaleDown", "img", "factor", "tick", "elapsed", "", "teletext-tools"})
public final class PlasmaRenderer {
    @NotNull
    private List<? extends MovingThing> dots;
    private boolean useBrightness;
    @NotNull
    private final BufferedImage canvasScaledUp;
    private final Graphics2D g;
    @NotNull
    private final TeletextPage page;
    @Nullable
    private Function3<? super Graphics2D, ? super Integer, ? super Integer, Unit> overlayRenderBeforeRastering;

    public PlasmaRenderer(@NotNull List<? extends MovingThing> dots, boolean useBrightness) {
        Intrinsics.checkNotNullParameter(dots, "dots");
        this.dots = dots;
        this.useBrightness = useBrightness;
        this.canvasScaledUp = new BufferedImage(156, 96, 3);
        this.g = this.canvasScaledUp.createGraphics();
        this.page = new TeletextPage(null, 1, null);
    }

    public /* synthetic */ PlasmaRenderer(List list, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(list, bl);
    }

    @NotNull
    public final List<MovingThing> getDots() {
        return this.dots;
    }

    public final void setDots(@NotNull List<? extends MovingThing> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.dots = list;
    }

    public final boolean getUseBrightness() {
        return this.useBrightness;
    }

    public final void setUseBrightness(boolean bl) {
        this.useBrightness = bl;
    }

    @NotNull
    public final BufferedImage getCanvasScaledUp() {
        return this.canvasScaledUp;
    }

    public final Graphics2D getG() {
        return this.g;
    }

    @NotNull
    public final TeletextPage getPage() {
        return this.page;
    }

    @Nullable
    public final Function3<Graphics2D, Integer, Integer, Unit> getOverlayRenderBeforeRastering() {
        return this.overlayRenderBeforeRastering;
    }

    public final void setOverlayRenderBeforeRastering(@Nullable Function3<? super Graphics2D, ? super Integer, ? super Integer, Unit> function3) {
        this.overlayRenderBeforeRastering = function3;
    }

    public final void tick(double elapsed) {
        Iterable $this$forEach$iv = this.dots;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MovingThing it = (MovingThing)element$iv;
            boolean bl = false;
            it.tick(elapsed);
        }
    }

    @NotNull
    public final BufferedImage paint() {
        this.g.setColor(Color.BLACK);
        this.g.fillRect(0, 0, this.canvasScaledUp.getWidth(), this.canvasScaledUp.getHeight());
        Composite oldComposite = this.g.getComposite();
        this.g.setComposite(BlendComposite.Screen);
        Iterable $this$forEach$iv = this.dots;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MovingThing it = (MovingThing)element$iv;
            boolean bl = false;
            Graphics2D graphics2D = this.g;
            Intrinsics.checkNotNullExpressionValue(graphics2D, "g");
            it.draw(graphics2D);
        }
        this.g.setComposite(oldComposite);
        Function3<? super Graphics2D, ? super Integer, ? super Integer, Unit> function3 = this.overlayRenderBeforeRastering;
        if (function3 != null) {
            Graphics2D graphics2D = this.g;
            Intrinsics.checkNotNullExpressionValue(graphics2D, "g");
            function3.invoke(graphics2D, (Integer)this.canvasScaledUp.getWidth(), (Integer)this.canvasScaledUp.getHeight());
        }
        BufferedImage canvas = this.scaleDown(this.canvasScaledUp, 4);
        int n = canvas.getHeight();
        for (int y = 0; y < n; ++y) {
            this.page.set(0, y, (byte)BuffersAndEncodingKt.parity(30));
            PLASMA_COLOR lastPlasmaCol = null;
            int n2 = canvas.getWidth();
            for (int x = 0; x < n2; ++x) {
                if (y == 0 && x < 8) {
                    if (x != 7) continue;
                    this.page.set(7, y, (byte)BuffersAndEncodingKt.parity(30));
                    continue;
                }
                int rgb = canvas.getRGB(x, y);
                PLASMA_COLOR plasmaCol = this.useBrightness ? PLASMA_COLOR.Companion.byBrightness(rgb) : PLASMA_COLOR.Companion.closest(rgb);
                PLASMA_COLOR pLASMA_COLOR = lastPlasmaCol;
                if ((pLASMA_COLOR != null ? pLASMA_COLOR.getTeletextColor() : null) != plasmaCol.getTeletextColor()) {
                    this.page.set(x + 1, y, plasmaCol.getSetColorCommand());
                } else {
                    this.page.set(x + 1, y, plasmaCol.getPixelChar());
                }
                lastPlasmaCol = plasmaCol;
            }
        }
        return canvas;
    }

    private final BufferedImage scaleDown(BufferedImage img, int factor) {
        int newW = img.getWidth() / factor;
        int newH = img.getHeight() / factor;
        BufferedImage newImg = new BufferedImage(newW, newH, 1);
        Graphics2D g = newImg.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.drawImage(img, 0, 0, newW, newH, null);
        g.dispose();
        return newImg;
    }
}

