/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001e"}, d2={"LPlasmaEffect;", "LEffect;", "filename", "", "(Ljava/lang/String;)V", "center", "LPointXY;", "getCenter", "()LPointXY;", "dots", "", "Ljava/awt/image/BufferedImage;", "getDots", "()Ljava/util/List;", "movingDots", "LMovingDot;", "getMovingDots", "setMovingDots", "(Ljava/util/List;)V", "renderer", "LPlasmaRenderer;", "getRenderer", "()LPlasmaRenderer;", "doReset", "", "doTick", "ticks", "", "elapsed", "", "teletext-tools"})
public final class PlasmaEffect
extends Effect {
    @NotNull
    private final List<BufferedImage> dots;
    @NotNull
    private final PointXY center;
    @NotNull
    private List<MovingDot> movingDots;
    @NotNull
    private final PlasmaRenderer renderer;

    public PlasmaEffect(@NotNull String filename) {
        Intrinsics.checkNotNullParameter(filename, "filename");
        super("Plasma");
        this.dots = PlasmaKt.extractDotImages(filename);
        this.center = new PointXY(78, 48);
        MovingDot[] movingDotArray = new MovingDot[]{new MovingDot(this.dots.get(0), this.center, new SineMover(20.0, 25.3, 3.4, 5.0, 0.0, 0.0, 48, null).chain(new SineMover(19.0, 5.0, 6.4, 12.5, 0.0, 0.0, 48, null))), new MovingDot(this.dots.get(0), this.center, new SineMover(12.0, 17.0, 6.5, 4.7, 0.0, 0.0, 48, null).chain(new SineMover(17.3, 8.4, 5.7, 9.1, 0.0, 0.0, 48, null))), new MovingDot(this.dots.get(2), this.center, new SineMover(30.0, 13.5, 4.8, 2.7, 0.0, 0.0, 48, null)), new MovingDot(this.dots.get(2), this.center, new SineMover(13.0, 21.5, 4.8, 4.7, 0.0, 0.0, 48, null)), new MovingDot(this.dots.get(4), this.center, new SineMover(12.0, 11.0, 3.3, 1.9, 0.0, 0.0, 48, null).chain(new SineMover(11.0, 9.0, 6.1, 4.5, 0.0, 0.0, 48, null))), new MovingDot(this.dots.get(4), this.center, new SineMover(21.0, 24.0, 6.3, 3.9, 0.0, 0.0, 48, null))};
        this.movingDots = CollectionsKt.listOf(movingDotArray);
        this.renderer = new PlasmaRenderer(this.movingDots, false, 2, null);
    }

    public /* synthetic */ PlasmaEffect(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "gfx/colordots.png";
        }
        this(string);
    }

    @NotNull
    public final List<BufferedImage> getDots() {
        return this.dots;
    }

    @NotNull
    public final PointXY getCenter() {
        return this.center;
    }

    @NotNull
    public final List<MovingDot> getMovingDots() {
        return this.movingDots;
    }

    public final void setMovingDots(@NotNull List<MovingDot> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.movingDots = list;
    }

    @NotNull
    public final PlasmaRenderer getRenderer() {
        return this.renderer;
    }

    @Override
    public void doReset() {
    }

    @Override
    public void doTick(int ticks, double elapsed) {
        this.renderer.tick(elapsed);
        this.renderer.paint();
        BuffersAndEncodingKt.formatAsPage(this.renderer.getPage().getData(), 256, this.getBuf());
    }

    public PlasmaEffect() {
        this(null, 1, null);
    }
}

