/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\u001aG\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000b\u001a2\u0010\f\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\n\u00a8\u0006\u000f"}, d2={"convertImage", "", "img", "Ljava/awt/image/BufferedImage;", "emptyCellCharacter", "", "cols", "rows", "includeStartGfxCharacter", "inverted", "", "(Ljava/awt/image/BufferedImage;IIILjava/lang/Integer;Z)[B", "encodeAt", "x", "y", "teletext-tools"})
public final class ImageUtilsKt {
    @NotNull
    public static final byte[] convertImage(@NotNull BufferedImage img, int emptyCellCharacter, int cols, int rows, @Nullable Integer includeStartGfxCharacter, boolean inverted) {
        Intrinsics.checkNotNullParameter(img, "img");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (int row = 0; row < rows; ++row) {
            Integer n = includeStartGfxCharacter;
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                out.write(it);
            }
            for (int col = 0; col < cols; ++col) {
                int b = ImageUtilsKt.encodeAt(img, col * 2, row * 3, emptyCellCharacter, inverted);
                out.write(b);
            }
        }
        byte[] byArray = out.toByteArray();
        Intrinsics.checkNotNullExpressionValue(byArray, "out.toByteArray()");
        return byArray;
    }

    public static /* synthetic */ byte[] convertImage$default(BufferedImage bufferedImage, int n, int n2, int n3, Integer n4, boolean bl, int n5, Object object) {
        if ((n5 & 2) != 0) {
            n = 32;
        }
        if ((n5 & 4) != 0) {
            n2 = 39;
        }
        if ((n5 & 8) != 0) {
            n3 = 24;
        }
        if ((n5 & 0x10) != 0) {
            n4 = 23;
        }
        if ((n5 & 0x20) != 0) {
            bl = false;
        }
        return ImageUtilsKt.convertImage(bufferedImage, n, n2, n3, n4, bl);
    }

    public static final int encodeAt(@NotNull BufferedImage img, int x, int y, int emptyCellCharacter, boolean inverted) {
        int n;
        Intrinsics.checkNotNullParameter(img, "img");
        int upper = 0;
        if (x + 1 >= img.getWidth() || y + 2 >= img.getHeight()) {
            return emptyCellCharacter;
        }
        if ((img.getRGB(x + 0, y + 0) & 0xFF) == 0) {
            upper |= 1;
        }
        if ((img.getRGB(x + 1, y + 0) & 0xFF) == 0) {
            upper |= 2;
        }
        if ((img.getRGB(x + 0, y + 1) & 0xFF) == 0) {
            upper |= 4;
        }
        if ((img.getRGB(x + 1, y + 1) & 0xFF) == 0) {
            upper |= 8;
        }
        int lower = 0;
        if ((img.getRGB(x + 0, y + 2) & 0xFF) == 0) {
            lower |= 1;
        }
        if ((img.getRGB(x + 1, y + 2) & 0xFF) == 0) {
            lower |= 2;
        }
        if (inverted) {
            upper ^= 0xF;
            lower ^= 3;
        }
        if (upper == 0 && lower == 0) {
            return emptyCellCharacter;
        }
        switch (lower) {
            case 0: {
                n = 0xA0 | upper;
                break;
            }
            case 1: {
                n = 0xB0 | upper;
                break;
            }
            case 2: {
                n = 0xE0 | upper;
                break;
            }
            case 3: {
                n = 0xF0 | upper;
                break;
            }
            default: {
                throw new IllegalStateException("wat");
            }
        }
        return n;
    }

    public static /* synthetic */ int encodeAt$default(BufferedImage bufferedImage, int n, int n2, int n3, boolean bl, int n4, Object object) {
        if ((n4 & 8) != 0) {
            n3 = 32;
        }
        if ((n4 & 0x10) != 0) {
            bl = false;
        }
        return ImageUtilsKt.encodeAt(bufferedImage, n, n2, n3, bl);
    }
}

