/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Box;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0019\u0010\u0004\u001a\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"errorExit", "", "s", "", "main", "args", "", "([Ljava/lang/String;)V", "teletext-tools"})
public final class DemoRunnerKt {
    public static final void main(@NotNull String[] args2) {
        Intrinsics.checkNotNullParameter(args2, "args");
        System.out.println((Object)"\u001b[41m teletext demo runner \u001b[0m");
        RunnerConf conf = RunnerConf.Companion.parse(args2);
        NetworkConnection networkSink = null;
        TeletextDisplayPanel previewSink = null;
        Boolean bl = conf.getPreview();
        boolean usePreview = bl != null ? bl : false;
        JFrame frame = null;
        if (!conf.hasNetworkData() && !usePreview) {
            System.out.println((Object)"Neither network target nor preview specified, using graphical preview.");
            System.out.println((Object)"Run with \"-host <host> -port <port> [-preview true]\" to send via TCP.");
            usePreview = true;
        }
        if (usePreview) {
            PaintListener fpsMon = new PaintListener();
            previewSink = new TeletextDisplayPanel(FontAndRenderingKt.getTeletextFont$default(false, 1, null));
            previewSink.setPaintListener(fpsMon);
            Box prevPanel = Box.createVerticalBox();
            prevPanel.add(previewSink);
            Intrinsics.checkNotNullExpressionValue(prevPanel, "prevPanel");
            frame = FontAndRenderingKt.showInFrame("Teletext preview", prevPanel, true);
            frame.setLocation(new Point(0, 0));
        } else {
            previewSink = null;
        }
        if (conf.hasNetworkData()) {
            if (conf.getHost() == null) {
                boolean $i$a$-requireNotNull-DemoRunnerKt$main$32 = false;
                String $i$a$-requireNotNull-DemoRunnerKt$main$32 = "no host";
                throw new IllegalArgumentException($i$a$-requireNotNull-DemoRunnerKt$main$32.toString());
            }
            if (conf.getPort() == null) {
                boolean $i$a$-requireNotNull-DemoRunnerKt$main$42 = false;
                String $i$a$-requireNotNull-DemoRunnerKt$main$42 = "no port";
                throw new IllegalArgumentException($i$a$-requireNotNull-DemoRunnerKt$main$42.toString());
            }
            System.out.println((Object)("Connect to " + conf.getHost() + ':' + conf.getPort() + "..."));
            networkSink = new NetworkConnection(conf.getHost(), conf.getPort(), null);
        } else {
            networkSink = null;
        }
        BufRenderer sink = null;
        if (previewSink != null && networkSink != null) {
            sink = new CompoundSink(previewSink, networkSink);
        } else if (previewSink != null) {
            sink = previewSink;
        } else if (networkSink != null) {
            sink = networkSink;
        } else {
            throw new IllegalStateException("no network or display preview sink");
        }
        AudioOutput audio = new AudioOutput();
        Boolean bl2 = conf.getTimestamp();
        boolean timestamp = bl2 != null ? bl2 : false;
        Integer n = conf.getFps();
        int fps = n != null ? n : 25;
        try {
            DemoRunner runner = new DemoRunner(sink, fps, audio, timestamp);
            KeyAdapter keyListener2 = new KeyAdapter(runner){
                final /* synthetic */ DemoRunner $runner;
                {
                    this.$runner = $runner;
                }

                public void keyPressed(@Nullable KeyEvent e) {
                    this.$runner.keyPressed();
                }
            };
            JFrame jFrame = frame;
            if (jFrame != null) {
                jFrame.addKeyListener(keyListener2);
            }
            runner.run();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            System.out.println();
            DemoRunnerKt.errorExit(e.toString());
            return;
        }
    }

    public static final void errorExit(@NotNull String s) {
        Intrinsics.checkNotNullParameter(s, "s");
        System.out.println((Object)("Error: " + s));
        System.out.println();
        System.out.println((Object)"Usage: java DemoRunnerKt [-fps <fps>] [-host <host> -port <port>] [-preview true] [-sound true] [-ts true]");
        System.exit(5);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }
}

