/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u001fJ\b\u0010>\u001a\u00020<H\u0016J\u0018\u0010?\u001a\u00020<2\u0006\u0010@\u001a\u00020\r2\u0006\u0010=\u001a\u00020\u001fH\u0016J(\u0010A\u001a\u00020<2\u0006\u0010B\u001a\u00020\r2\u0006\u0010C\u001a\u00020\r2\u0006\u0010D\u001a\u00020\r2\u0006\u0010E\u001a\u00020\rH\u0002J\u0018\u0010F\u001a\u00020<2\u0006\u0010G\u001a\u00020\u001f2\u0006\u0010H\u001a\u00020\u0004H\u0002J\"\u0010I\u001a\u00020<2\u0006\u0010G\u001a\u00020\u001f2\b\b\u0002\u0010J\u001a\u00020\u001f2\b\b\u0002\u0010K\u001a\u00020\u001fJ\u000e\u0010L\u001a\u00020<2\u0006\u0010=\u001a\u00020\u001fR\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0019\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0014\u0010\f\u001a\u00020\rX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0019\u0010\u0012\u001a\n \u0005*\u0004\u0018\u00010\u00130\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001d\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u000f\"\u0004\b.\u0010/R\u0014\u00100\u001a\u000201X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0014\u00104\u001a\u00020\rX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u000fR\u0014\u00106\u001a\u00020\rX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\u000fR\u001a\u00108\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010)\"\u0004\b:\u0010+\u00a8\u0006M"}, d2={"LContrastEffect;", "LEffect;", "()V", "atw", "Ljava/awt/image/BufferedImage;", "kotlin.jvm.PlatformType", "getAtw", "()Ljava/awt/image/BufferedImage;", "constrast1", "getConstrast1", "constrast2", "getConstrast2", "diceW", "", "getDiceW", "()I", "fadePic", "getFadePic", "fadePicG", "Ljava/awt/Graphics2D;", "getFadePicG", "()Ljava/awt/Graphics2D;", "page", "LTeletextPage;", "getPage", "()LTeletextPage;", "setPage", "(LTeletextPage;)V", "startByState", "", "LContrastState;", "", "getStartByState", "()Ljava/util/Map;", "state", "getState", "()LContrastState;", "setState", "(LContrastState;)V", "stateStart", "getStateStart", "()D", "setStateStart", "(D)V", "stateTicks", "getStateTicks", "setStateTicks", "(I)V", "text", "", "getText", "()Ljava/lang/String;", "textX", "getTextX", "textY", "getTextY", "waitForDice", "getWaitForDice", "setWaitForDice", "doContrast", "", "elapsed", "doReset", "doTick", "ticks", "drawDice", "dicex", "dicey", "col", "num", "drawFaded", "T", "image", "pink", "textStart", "textEnd", "random", "teletext-tools"})
public final class ContrastEffect
extends Effect {
    @NotNull
    private TeletextPage page = new TeletextPage(null, 1, null);
    @NotNull
    private ContrastState state = ArraysKt.first(ContrastState.values());
    private int stateTicks;
    private double stateStart;
    @NotNull
    private final Map<ContrastState, Double> startByState = new LinkedHashMap();
    private final BufferedImage constrast1 = ImageIO.read(new File("gfx/in-contrast1.png"));
    private final BufferedImage constrast2 = ImageIO.read(new File("gfx/in-contrast2.png"));
    private final BufferedImage atw = ImageIO.read(new File("gfx/in-atw.png"));
    @NotNull
    private final BufferedImage fadePic = new BufferedImage(78, 72, 1);
    private final Graphics2D fadePicG = this.fadePic.createGraphics();
    private double waitForDice;
    private final int diceW;
    @NotNull
    private final String text;
    private final int textX;
    private final int textY;

    public ContrastEffect() {
        super("Contrast");
        this.doReset();
        this.diceW = 9;
        this.text = "...aaand PINK. What a ride! :)";
        this.textX = 20 - this.text.length() / 2 + 1;
        this.textY = 22;
    }

    @NotNull
    public final TeletextPage getPage() {
        return this.page;
    }

    public final void setPage(@NotNull TeletextPage teletextPage) {
        Intrinsics.checkNotNullParameter(teletextPage, "<set-?>");
        this.page = teletextPage;
    }

    @NotNull
    public final ContrastState getState() {
        return this.state;
    }

    public final void setState(@NotNull ContrastState contrastState) {
        Intrinsics.checkNotNullParameter((Object)contrastState, "<set-?>");
        this.state = contrastState;
    }

    public final int getStateTicks() {
        return this.stateTicks;
    }

    public final void setStateTicks(int n) {
        this.stateTicks = n;
    }

    public final double getStateStart() {
        return this.stateStart;
    }

    public final void setStateStart(double d) {
        this.stateStart = d;
    }

    @NotNull
    public final Map<ContrastState, Double> getStartByState() {
        return this.startByState;
    }

    public final BufferedImage getConstrast1() {
        return this.constrast1;
    }

    public final BufferedImage getConstrast2() {
        return this.constrast2;
    }

    public final BufferedImage getAtw() {
        return this.atw;
    }

    @NotNull
    public final BufferedImage getFadePic() {
        return this.fadePic;
    }

    public final Graphics2D getFadePicG() {
        return this.fadePicG;
    }

    @Override
    public void doReset() {
        this.stateTicks = 0;
        this.stateStart = 0.0;
        this.state = ArraysKt.first(ContrastState.values());
        this.startByState.clear();
        this.waitForDice = 0.0;
    }

    @Override
    public void doTick(int ticks, double elapsed) {
        int n = this.stateTicks;
        this.stateTicks = n + 1;
        ContrastState newState = ContrastState.Companion.getStateByElapsedTime(elapsed);
        if (newState != this.state) {
            this.state = newState;
            this.stateTicks = 0;
            this.stateStart = elapsed;
            Double d = elapsed;
            this.startByState.put(newState, d);
        }
        double stateT = (elapsed - this.stateStart) / newState.getDuration();
        switch (WhenMappings.$EnumSwitchMapping$0[newState.ordinal()]) {
            case 1: {
                this.doContrast(elapsed);
                break;
            }
            case 2: {
                this.page.fill(32);
                break;
            }
            case 3: {
                ContrastEffect.pink$default(this, 1.0 - stateT, 0.0, 0.0, 6, null);
                break;
            }
            case 4: {
                ContrastEffect.pink$default(this, stateT, 0.0, 0.0, 6, null);
                break;
            }
            case 5: {
                ContrastEffect.pink$default(this, 0.0, 0.0, 0.0, 6, null);
                break;
            }
            case 6: {
                this.pink(0.0, 0.0, stateT);
                break;
            }
            case 7: {
                this.pink(0.0, 0.0, 1.0);
                break;
            }
            case 8: {
                this.pink(0.0, stateT, 1.0);
                break;
            }
            case 9: {
                this.random(elapsed);
            }
        }
        this.page.set(8, 0, 23);
        BuffersAndEncodingKt.formatAsPage(this.page.getData(), 256, this.getBuf());
    }

    public final void doContrast(double elapsed) {
        BufferedImage which = elapsed % 2.0 < 1.0 ? this.constrast1 : this.constrast2;
        boolean inverted = elapsed % 0.2 < 0.1;
        Intrinsics.checkNotNullExpressionValue(which, "which");
        byte[] buf = ImageUtilsKt.convertImage$default(which, 0, 0, 0, null, inverted, 30, null);
        this.page.takeDataFrom(buf);
    }

    public final double getWaitForDice() {
        return this.waitForDice;
    }

    public final void setWaitForDice(double d) {
        this.waitForDice = d;
    }

    public final int getDiceW() {
        return this.diceW;
    }

    public final void random(double elapsed) {
        if (this.waitForDice >= elapsed) {
            return;
        }
        this.waitForDice = elapsed + 0.0 + Random.Default.nextDouble(0.21);
        int x = RandomKt.nextInt(Random.Default, new IntRange(1, 37 - this.diceW));
        int y = RandomKt.nextInt(Random.Default, new IntRange(1, 24 - this.diceW));
        int col = RandomKt.nextInt(Random.Default, new IntRange(1, 7));
        int num = RandomKt.nextInt(Random.Default, new IntRange(1, 6));
        this.drawDice(x, y, col, num);
    }

    private final void drawDice(int dicex, int dicey, int col, int num) {
        int n = dicey + this.diceW;
        for (int y = dicey; y < n; ++y) {
            List<TeletextState> states = this.page.getLineStates(y);
            this.page.set(dicex - 1, y, 16 + col);
            int ch = 0;
            int n2 = y;
            ch = n2 == dicey ? 124 : (n2 == dicey + this.diceW - 1 ? 47 : 127);
            int n3 = dicex + this.diceW;
            for (int x = dicex; x < n3; ++x) {
                this.page.set(x, y, ch);
            }
            this.page.set(dicex + this.diceW, y, 16 + states.get(dicex + this.diceW).getColor());
        }
        switch (num) {
            case 1: {
                this.page.set(dicex + 4, dicey + 4, 32);
                break;
            }
            case 2: {
                this.page.set(dicex + 2, dicey + 2, 32);
                this.page.set(dicex + 6, dicey + 6, 32);
                break;
            }
            case 3: {
                this.page.set(dicex + 6, dicey + 2, 32);
                this.page.set(dicex + 2, dicey + 6, 32);
                this.page.set(dicex + 4, dicey + 4, 32);
                break;
            }
            case 4: {
                this.page.set(dicex + 6, dicey + 2, 32);
                this.page.set(dicex + 2, dicey + 6, 32);
                this.page.set(dicex + 2, dicey + 2, 32);
                this.page.set(dicex + 6, dicey + 6, 32);
                break;
            }
            case 5: {
                this.page.set(dicex + 4, dicey + 4, 32);
                this.page.set(dicex + 6, dicey + 2, 32);
                this.page.set(dicex + 2, dicey + 6, 32);
                this.page.set(dicex + 2, dicey + 2, 32);
                this.page.set(dicex + 6, dicey + 6, 32);
                break;
            }
            default: {
                this.page.set(dicex + 4, dicey + 4, 32);
            }
        }
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final int getTextX() {
        return this.textX;
    }

    public final int getTextY() {
        return this.textY;
    }

    public final void pink(double T, double textStart, double textEnd) {
        int i;
        BufferedImage bufferedImage = this.atw;
        Intrinsics.checkNotNullExpressionValue(bufferedImage, "atw");
        this.drawFaded(T, bufferedImage);
        for (int y = 0; y < 24; ++y) {
            this.page.set(0, y, 21);
        }
        this.page.set(0, this.textY, 5);
        int firstChar = (int)GlobalsKt.lerp(textStart, 0.0, (double)this.text.length() - 1.0);
        int lastChar = (int)GlobalsKt.lerp(textEnd, 0.0, (double)this.text.length() - 1.0);
        if (lastChar >= firstChar && (i = firstChar) <= lastChar) {
            while (true) {
                char ch = this.text.charAt(i);
                this.page.set(this.textX + i, this.textY, ch);
                if (i == lastChar) break;
                ++i;
            }
        }
    }

    public static /* synthetic */ void pink$default(ContrastEffect contrastEffect, double d, double d2, double d3, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = 1.0;
        }
        if ((n & 4) != 0) {
            d3 = 0.0;
        }
        contrastEffect.pink(d, d2, d3);
    }

    private final void drawFaded(double T, BufferedImage image) {
        this.fadePicG.drawImage((Image)image, 0, 0, null);
        this.fadePicG.setColor(new Color(255, 255, 255, MathKt.roundToInt(GlobalsKt.lerp(T, 0.0, 255.0))));
        this.fadePicG.fillRect(0, 0, this.fadePic.getWidth(), this.fadePic.getHeight());
        this.page.takeDataFrom(ImageUtilsKt.convertImage$default(DitherKt.dither$default(this.fadePic, false, 2, null), 0, 0, 0, null, false, 62, null));
        for (int x = 0; x < 40; ++x) {
            this.page.set(x, 0, 32);
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ContrastState.values().length];
            nArray[ContrastState.CONTRAST.ordinal()] = 1;
            nArray[ContrastState.BLACK2.ordinal()] = 2;
            nArray[ContrastState.PINK_IN.ordinal()] = 3;
            nArray[ContrastState.PINK_OUT.ordinal()] = 4;
            nArray[ContrastState.PINK_SHOW.ordinal()] = 5;
            nArray[ContrastState.PINK_SHOW_SCROLL_IN.ordinal()] = 6;
            nArray[ContrastState.PINK_SHOW_SCROLL_SHOW.ordinal()] = 7;
            nArray[ContrastState.PINK_SHOW_SCROLL_OUT.ordinal()] = 8;
            nArray[ContrastState.RANDOM.ordinal()] = 9;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

