#version 330 core

in vec2 texCoord;
out vec4 fragColor;

uniform sampler2D texture0; 
uniform sampler2D texture1; // fft

uniform vec3 iResolution;
uniform vec4 color = vec4(1);
uniform float time;

void starfield() {
    vec2 coord = texCoord;

    vec2 position = ( coord.xy)-vec2(0.5,0.5);

    // 256 angle steps
    float angle = atan(position.y,position.x)/(2*3.14159265359);
    angle -= floor(angle);
    float rad = length(position);
    
    float color1 = 0.0;
    for (int i = 0; i < 2; i++) {
        float angleFract = fract(angle*36.);
        float angleRnd = floor(angle*360.)+1.;
        float angleRnd1 = fract(angleRnd*fract(angleRnd*.7235)*45.1);
        float angleRnd2 = fract(angleRnd*fract(angleRnd*.82657)*13.724);
        float t = time+angleRnd1*100.;
        float radDist = sqrt(angleRnd2+float(i));
        
        float adist = radDist/rad*1.5;
        float dist = (t*.2+adist);
        dist = abs(fract(dist)-.1);
        color1 += max(0.,.8-dist*100./adist)*(.5-abs(angleFract-.5))*5./adist/radDist;
        
        angle = fract(angle);
    }
    
    fragColor = vec4(color1)*color;
}

void main()
{
    starfield();
}
